/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.view;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Space;
import com.yy.mobile.channelpk.ui.view.CropImageView;
import com.yy.mobile.channelpk.utils.CalculateUtils;
import com.yy.mobile.memoryrecycle.views.YYRelativeLayout;
import com.yy.mobile.memoryrecycle.views.YYTextView;
import com.yy.mobile.plugin.pluginunionchannelpk.R;

public class PkBarView
extends LinearLayout {
    private static final String TAG = PkBarView.class.getSimpleName();
    public static final float DEFAULT_RATIO = 0.5f;
    public static final long DEFAULT_ANIMATION_DURATION = 2100L;
    private boolean isInit = true;
    private float mOldRatio = 0.5f;
    protected float mRatio = 0.5f;
    public CropImageView mImgLeft;
    public CropImageView mImgRight;
    private boolean needShowProgress = false;
    public ImageView mPkProgressImg;
    private ValueAnimator mValueAnimator;
    public YYRelativeLayout mRootView;
    public Space mSpaceReady;
    public YYTextView mTvLeftScore;
    public YYTextView mTvRightScore;

    public PkBarView(Context context) {
        this(context, null);
    }

    public PkBarView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PkBarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    public void initialize(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_pk_root_customview_bar, (ViewGroup)this);
        this.mRootView = (YYRelativeLayout)this.findViewById(R.id.rl_pk_bar_root);
        this.mImgLeft = (CropImageView)this.findViewById(R.id.img_left_bar);
        this.mImgRight = (CropImageView)this.findViewById(R.id.img_right_bar);
        this.mPkProgressImg = (ImageView)this.findViewById(R.id.img_pk_progress);
        this.mSpaceReady = (Space)this.findViewById(R.id.space_pk_ready);
        this.mTvLeftScore = (YYTextView)this.findViewById(R.id.tv_pk_bar_left_score);
        this.mTvRightScore = (YYTextView)this.findViewById(R.id.tv_pk_bar_right_score);
    }

    public void onValueAnimationUpdate(ValueAnimator animation) {
        float progress;
        LinearLayout.LayoutParams paramsLeft = (LinearLayout.LayoutParams)this.mImgLeft.getLayoutParams();
        LinearLayout.LayoutParams paramsRight = (LinearLayout.LayoutParams)this.mImgRight.getLayoutParams();
        if (this.needShowProgress && this.mPkProgressImg.getVisibility() != 0) {
            this.mPkProgressImg.setVisibility(0);
        }
        paramsLeft.weight = progress = ((Float)animation.getAnimatedValue()).floatValue();
        paramsRight.weight = 1.0f - progress;
        this.mImgLeft.setLayoutParams((ViewGroup.LayoutParams)paramsLeft);
        this.mImgRight.setLayoutParams((ViewGroup.LayoutParams)paramsRight);
        float tx = (float)(this.mRootView.getPaddingLeft() + this.mImgLeft.getRight()) - (float)this.mPkProgressImg.getWidth() * 0.5f;
        this.mPkProgressImg.setX(tx);
    }

    public void playAnimation() {
        if (this.mValueAnimator == null) {
            this.mValueAnimator = new ValueAnimator();
            this.mValueAnimator.setDuration(2100L);
            this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    PkBarView.this.onValueAnimationUpdate(animation);
                }
            });
            this.mValueAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    PkBarView.this.mPkProgressImg.setVisibility(4);
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
        if (this.mValueAnimator.isStarted() && this.mValueAnimator.isRunning()) {
            this.mValueAnimator.end();
        }
        this.mValueAnimator.setFloatValues(new float[]{this.mOldRatio, this.mRatio});
        this.mValueAnimator.start();
    }

    public void setLeftBitmap(Bitmap leftBitmap) {
        this.mImgLeft.setImageBitmap(leftBitmap);
    }

    public void setRightBitmap(Bitmap rightBitmap) {
        this.mImgRight.setImageBitmap(rightBitmap);
    }

    public void setPkData(float leftNum, float rightNum, String leftScoreText, String rightScoreText) {
        this.mOldRatio = this.mRatio;
        this.mRatio = CalculateUtils.getPkRatio(leftNum, rightNum);
        this.mTvLeftScore.setText((CharSequence)leftScoreText);
        this.mTvRightScore.setText((CharSequence)rightScoreText);
    }

    public void setPkText(String leftScoreText, String rightScoreText) {
        this.mTvLeftScore.setText((CharSequence)leftScoreText);
        this.mTvRightScore.setText((CharSequence)rightScoreText);
    }

    public void updatePkView() {
        if (this.isInit || this.mOldRatio == this.mRatio) {
            this.initPosition();
        } else {
            this.playAnimation();
        }
    }

    public void initPosition() {
        this.mOldRatio = this.mRatio;
        this.mPkProgressImg.setVisibility(4);
        LinearLayout.LayoutParams paramsLeft = (LinearLayout.LayoutParams)this.mImgLeft.getLayoutParams();
        LinearLayout.LayoutParams paramsRight = (LinearLayout.LayoutParams)this.mImgRight.getLayoutParams();
        paramsLeft.weight = this.mRatio;
        paramsRight.weight = 1.0f - this.mRatio;
        this.mImgLeft.setLayoutParams((ViewGroup.LayoutParams)paramsLeft);
        this.mImgRight.setLayoutParams((ViewGroup.LayoutParams)paramsRight);
        this.isInit = false;
    }

    public float getRatio() {
        return this.mRatio;
    }

    public float getOldRatio() {
        return this.mOldRatio;
    }

    public ImageView getProgressImageView() {
        return this.mPkProgressImg;
    }

    public YYRelativeLayout getBarRootView() {
        return this.mRootView;
    }

    public void hideReadySpace() {
        this.mSpaceReady.setVisibility(8);
    }

    public void showReadySpace() {
        this.mSpaceReady.setVisibility(0);
    }

    public void setNeedShowProgress(boolean needShowProgress) {
        this.needShowProgress = needShowProgress;
        if (!needShowProgress) {
            this.mPkProgressImg.setImageDrawable(null);
            this.mPkProgressImg.setVisibility(4);
        }
    }

    public void clear() {
        if (this.mValueAnimator != null) {
            this.mValueAnimator.removeAllUpdateListeners();
            this.mValueAnimator.removeAllListeners();
            this.mValueAnimator.cancel();
            this.mValueAnimator = null;
        }
        this.mOldRatio = 0.5f;
        this.mRatio = 0.5f;
        LinearLayout.LayoutParams paramsLeft = (LinearLayout.LayoutParams)this.mImgLeft.getLayoutParams();
        LinearLayout.LayoutParams paramsRight = (LinearLayout.LayoutParams)this.mImgRight.getLayoutParams();
        paramsLeft.weight = 0.5f;
        paramsRight.weight = 0.5f;
        this.isInit = true;
        this.needShowProgress = false;
        this.mPkProgressImg.setImageDrawable(null);
        this.mPkProgressImg.setVisibility(4);
        this.mImgLeft.setImageBitmap(null);
        this.mImgRight.setImageBitmap(null);
    }
}

