/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.module;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IPKClient_crownInfoNotify_EventArgs;
import com.duowan.mobile.entlive.events.IPKClient_onReceiveMstate_EventArgs;
import com.duowan.mobile.entlive.events.IPKClient_onSendPkGift_EventArgs;
import com.duowan.mobile.entlive.events.IPKClient_pkGiftInfoRsp_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.channelpk.coremodule.M_One;
import com.yy.mobile.channelpk.coremodule.core.IChannelPKCore;
import com.yy.mobile.channelpk.coremodule.model.ChannelPkNotifyInfo;
import com.yy.mobile.channelpk.ui.module.PKCrownModule$$EventBinder;
import com.yy.mobile.channelpk.ui.module.PkCrownBead;
import com.yy.mobile.channelpk.ui.module.base.LayoutModule;
import com.yy.mobile.channelpk.ui.pknor.ui.circleProgressView.CirclepkAnimationView;
import com.yy.mobile.channelpk.ui.pknor.ui.circleProgressView.PKCoolingLayer;
import com.yy.mobile.liveapi.necklace.Bead;
import com.yy.mobile.liveapi.necklace.BeadFactory;
import com.yy.mobile.liveapi.necklace.BeadsConfig;
import com.yy.mobile.liveapi.necklace.BeadsId;
import com.yy.mobile.liveapi.necklace.Necklace;
import com.yy.mobile.liveapi.necklace.NecklaceContext;
import com.yy.mobile.liveapi.pk.IPkCore;
import com.yy.mobile.liveapi.pk.IPkScenenGiftCore;
import com.yy.mobile.liveapi.pk.PkCrownInfo;
import com.yy.mobile.liveapi.pk.PkScenenConfig;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onChatEmotionComponentDismiss_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onShowChatInputBroadcast_EventArgs;
import com.yy.mobile.plugin.pluginunionchannelpk.R;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gift.GiftConfigItemBase;
import com.yymobile.core.mobilelive.ILivePluginCore;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class PKCrownModule
extends LayoutModule {
    private CirclepkAnimationView leftStatisticView;
    private CirclepkAnimationView rightStatisticView;
    private int detaY = ScreenUtil.getInstance().dip2px(120);
    private static final String TAG = "PKCrownModule";
    @Nullable
    private PkCrownBead pkCrownUi;
    private Queue<PkAction> cachePkAction = new LinkedList<PkAction>();
    private EventBinder mPKCrownModuleSniperEventBinder;

    @Override
    protected int onViewAttach() {
        return R.id.module_pk_crown;
    }

    @Override
    public int onGetLayoutResId() {
        return R.layout.module_pk_crown;
    }

    @Override
    protected void onViewCreated(View view) {
        Necklace.ViewModelProxy necklace;
        super.onViewCreated(view);
        MLog.info((Object)TAG, (String)"onViewCreated", (Object[])new Object[0]);
        this.leftStatisticView = (CirclepkAnimationView)view.findViewById(R.id.left_statistics);
        this.rightStatisticView = (CirclepkAnimationView)view.findViewById(R.id.right_statistics);
        this.leftStatisticView.setColorResourseId(R.color.miaobian_crown_color);
        this.rightStatisticView.setColorResourseId(R.color.miaobian_crown_color_two);
        this.leftStatisticView.setOnCountDownFinishedListener(new PKCoolingLayer.OnCountDownFinishedListener(){

            @Override
            public void onCountDownFinished() {
                if (((IPkScenenGiftCore)CoreFactory.getCore(IPkScenenGiftCore.class)).getPkCrownInfo() != null && PKCrownModule.this.leftStatisticView != null) {
                    PKCrownModule.this.leftStatisticView.setCurrentGiftCount(((IPkScenenGiftCore)CoreFactory.getCore(IPkScenenGiftCore.class)).getPkCrownInfo().lgnum);
                }
            }
        });
        this.rightStatisticView.setOnCountDownFinishedListener(new PKCoolingLayer.OnCountDownFinishedListener(){

            @Override
            public void onCountDownFinished() {
                if (((IPkScenenGiftCore)CoreFactory.getCore(IPkScenenGiftCore.class)).getPkCrownInfo() != null && PKCrownModule.this.rightStatisticView != null) {
                    PKCrownModule.this.rightStatisticView.setCurrentGiftCount(((IPkScenenGiftCore)CoreFactory.getCore(IPkScenenGiftCore.class)).getPkCrownInfo().rgnum);
                }
            }
        });
        if (this.mContext != null && this.mContext.get() != null && this.pkCrownUi == null && !((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() && (necklace = Necklace.of((LifecycleOwner)((LifecycleOwner)this.mContext.get()))) != null) {
            MLog.info((Object)TAG, (String)"necklace is not null", (Object[])new Object[0]);
            Bead bead = necklace.getBead(BeadsId.PK_CROWN_ICON);
            if (bead == null) {
                necklace.register((BeadFactory)new PkCrownBeadFactory((Context)this.mContext.get()), BeadsId.PK_CROWN_ICON);
            } else if (bead instanceof PkCrownBead) {
                this.pkCrownUi = (PkCrownBead)bead;
            }
        }
        if (((IPkScenenGiftCore)CoreFactory.getCore(IPkScenenGiftCore.class)).getPkScenenConfig() != null) {
            this.updateStaticCount(((IPkScenenGiftCore)CoreFactory.getCore(IPkScenenGiftCore.class)).getPkCrownInfo());
        }
        this.updateStisticLayout();
        this.initStatisticIcon();
    }

    @Override
    protected void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        this.updateStisticLayout();
    }

    @Override
    protected void onPkStart() {
        MLog.info((Object)TAG, (String)("onPkStart, module:" + this + ", ui:" + (Object)((Object)this.pkCrownUi)), (Object[])new Object[0]);
        if (this.pkCrownUi != null) {
            this.pkCrownUi.onPkStart();
        } else {
            this.cachePkAction.add(PkAction.Start);
        }
    }

    @Override
    protected void onPkGoing() {
        MLog.info((Object)TAG, (String)("onPkGoing, module:" + this + ", ui:" + (Object)((Object)this.pkCrownUi)), (Object[])new Object[0]);
        if (this.pkCrownUi != null) {
            this.pkCrownUi.onPkGoing();
        } else {
            this.cachePkAction.add(PkAction.Going);
        }
        ChannelPkNotifyInfo pkInfo = ((IChannelPKCore)ICoreManagerBase.getCore(IChannelPKCore.class)).getChannelPkInfo();
        if (pkInfo.simpleVer != 1 && (pkInfo.lnum > 0 || pkInfo.rnum > 0) && ((IPkScenenGiftCore)CoreFactory.getCore(IPkScenenGiftCore.class)).getPkScenenConfig() != null && ((IPkScenenGiftCore)CoreFactory.getCore(IPkScenenGiftCore.class)).getPkCrownInfo() != null) {
            int state = ((IPkScenenGiftCore)CoreFactory.getCore(IPkScenenGiftCore.class)).getPkScenenConfig().mState;
            if (state != 1) {
                if (pkInfo.lnum > pkInfo.rnum) {
                    this.setStatisticVisibility(true, false);
                } else {
                    this.setStatisticVisibility(false, true);
                }
            } else {
                this.setStatisticVisibility(false, false);
            }
        }
    }

    @Override
    protected void onPkEnd() {
        MLog.info((Object)TAG, (String)("onPkEnd, module:" + this + ", ui:" + (Object)((Object)this.pkCrownUi)), (Object[])new Object[0]);
        if (this.pkCrownUi != null) {
            this.pkCrownUi.onPkEnd();
        } else {
            this.cachePkAction.add(PkAction.End);
        }
        this.setStatisticVisibility(false, false);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.leftStatisticView != null) {
            this.leftStatisticView.stopAnimation();
        }
        if (this.rightStatisticView != null) {
            this.rightStatisticView.stopAnimation();
        }
    }

    @BusEvent
    public void crownInfoNotify(IPKClient_crownInfoNotify_EventArgs busEventArgs) {
        PkCrownInfo info = busEventArgs.getInfo();
        MLog.info((Object)TAG, (String)("crownInfoNotify: " + info), (Object[])new Object[0]);
        if (this.pkCrownUi != null) {
            this.pkCrownUi.updateGiftCount(info);
        }
        if (info != null && info.mState != 1) {
            this.updateStaticCount(info);
        }
    }

    @BusEvent
    public void onReceiveMstate(IPKClient_onReceiveMstate_EventArgs busEventArgs) {
        PkScenenConfig config = busEventArgs.getConfig();
        String appdata = busEventArgs.getAppdata();
        if (config != null && this.pkCrownUi != null) {
            this.pkCrownUi.onReceiveMstate(config, appdata);
        }
    }

    @BusEvent
    public void onSendPkGift(IPKClient_onSendPkGift_EventArgs busEventArgs) {
        int resultCode = busEventArgs.getResultCode();
        int type = busEventArgs.getType();
        int number = busEventArgs.getNumber();
        MLog.info((Object)TAG, (String)("onSendPkGift resultCode=" + resultCode + " type=" + type + " number=" + number), (Object[])new Object[0]);
        if (((IPkScenenGiftCore)CoreFactory.getCore(IPkScenenGiftCore.class)).getPkScenenConfig() != null && resultCode == 0 && type == ((IPkScenenGiftCore)CoreFactory.getCore(IPkScenenGiftCore.class)).getPkScenenConfig().cfCROWNGIFTID) {
            this.showAddAnimation();
        }
    }

    @BusEvent
    public void pkGiftInfoRsp(IPKClient_pkGiftInfoRsp_EventArgs busEventArgs) {
        PkCrownInfo info = busEventArgs.getInfo();
        this.onPkGiftConfigRsp(info);
    }

    private void onPkGiftConfigRsp(PkCrownInfo info) {
        MLog.info((Object)TAG, (String)("onPkGiftConfigRsp info = " + info), (Object[])new Object[0]);
        if (info != null && info.mState != 1) {
            this.checkShowCrownView();
            if (this.pkCrownUi != null) {
                this.pkCrownUi.initView();
            }
            this.initStatisticIcon();
        }
    }

    private void initStatisticIcon() {
        PkScenenConfig sceneConfig = ((IPkScenenGiftCore)CoreFactory.getCore(IPkScenenGiftCore.class)).getPkScenenConfig();
        if (sceneConfig == null) {
            return;
        }
        GiftConfigItemBase item = ((ILivePluginCore)CoreFactory.getCore(ILivePluginCore.class)).getGiftConfigItemByType(sceneConfig.cfCROWNGIFTID);
        if (item != null) {
            this.rightStatisticView.setCenterImageInfo(item.iconPath);
            this.leftStatisticView.setCenterImageInfo(item.iconPath);
        }
    }

    private void checkShowCrownView() {
        if (((IChannelPKCore)ICoreManagerBase.getCore(IChannelPKCore.class)).getChannelPkInfo() == null) {
            return;
        }
        int stata = ((IChannelPKCore)ICoreManagerBase.getCore(IChannelPKCore.class)).getChannelPkInfo().state;
        int type = ((IChannelPKCore)ICoreManagerBase.getCore(IChannelPKCore.class)).getChannelPkInfo().type;
        MLog.info((Object)TAG, (String)("checkShowCrownView state = " + stata + " type = " + type), (Object[])new Object[0]);
        if (stata == 1 && type == 5) {
            ((IChannelPKCore)ICoreManagerBase.getCore(IChannelPKCore.class)).reqChannelPKLoad();
        }
    }

    @BusEvent(sync=true)
    public void onChatEmotionComponentDismiss(IChatEmotionClient_onChatEmotionComponentDismiss_EventArgs busEventArgs) {
        if (!this.isLandScape() && !((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
            int statisticViewMarginTop;
            RelativeLayout.LayoutParams leftparams = (RelativeLayout.LayoutParams)this.leftStatisticView.getLayoutParams();
            RelativeLayout.LayoutParams rightparams = (RelativeLayout.LayoutParams)this.rightStatisticView.getLayoutParams();
            leftparams.topMargin = statisticViewMarginTop = this.screenWith * 3 / 4 + ScreenUtil.getInstance().dip2px(80) + 6 - ScreenUtil.getInstance().dip2px(88);
            rightparams.topMargin = statisticViewMarginTop;
        }
    }

    @BusEvent
    public void onShowChatInputBroadcast(IChatEmotionClient_onShowChatInputBroadcast_EventArgs busEventArgs) {
        boolean showChatInput = busEventArgs.getShowChatInput();
        if (!this.isLandScape() && !((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() && showChatInput) {
            RelativeLayout.LayoutParams leftparams = (RelativeLayout.LayoutParams)this.leftStatisticView.getLayoutParams();
            RelativeLayout.LayoutParams rightparams = (RelativeLayout.LayoutParams)this.rightStatisticView.getLayoutParams();
            int statisticViewMarginTop = this.screenWith * 3 / 4 + ScreenUtil.getInstance().dip2px(80) + 6 - ScreenUtil.getInstance().dip2px(88) - this.detaY;
            if (M_One.isMvp()) {
                statisticViewMarginTop -= ScreenUtil.getInstance().dip2px(90);
            }
            leftparams.topMargin = statisticViewMarginTop;
            rightparams.topMargin = statisticViewMarginTop;
        }
    }

    private void showAddAnimation() {
        FragmentActivity fragmentActivity = (FragmentActivity)this.mContext.get();
        if (fragmentActivity != null) {
            this.leftStatisticView.playAnimationOnce((Context)fragmentActivity);
        }
    }

    private void updateStisticLayout() {
        RelativeLayout.LayoutParams leftparams = (RelativeLayout.LayoutParams)this.leftStatisticView.getLayoutParams();
        RelativeLayout.LayoutParams rightparams = (RelativeLayout.LayoutParams)this.rightStatisticView.getLayoutParams();
        if (!this.isLandScape()) {
            leftparams.bottomMargin = 0;
            rightparams.bottomMargin = 0;
            int marginTop = this.screenWith * 3 / 4 + ScreenUtil.getInstance().dip2px(80) + 6 - ScreenUtil.getInstance().dip2px(88);
            if (!((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() && ((IPkCore)CoreFactory.getCore(IPkCore.class)).isShowChatInput()) {
                marginTop -= this.detaY;
            }
            leftparams.addRule(12, 0);
            leftparams.topMargin = marginTop;
            leftparams.leftMargin = ScreenUtil.getInstance().dip2px(15);
            rightparams.addRule(12, 0);
            rightparams.topMargin = marginTop;
            rightparams.leftMargin = this.screenWith - ScreenUtil.getInstance().dip2px(65);
        } else {
            int marginBottom;
            if (((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
                marginBottom = ScreenUtil.getInstance().dip2px(117);
                if (M_One.isMvp()) {
                    marginBottom += ScreenUtil.getInstance().dip2px(45);
                }
            } else {
                marginBottom = ScreenUtil.getInstance().dip2px(107);
                if (M_One.isMvp()) {
                    marginBottom += ScreenUtil.getInstance().dip2px(45);
                }
            }
            leftparams.topMargin = 0;
            rightparams.topMargin = 0;
            leftparams.addRule(12);
            leftparams.bottomMargin = marginBottom;
            leftparams.leftMargin = this.screenHight / 2 - ScreenUtil.getInstance().dip2px(65);
            rightparams.addRule(12);
            rightparams.bottomMargin = marginBottom;
            rightparams.leftMargin = this.screenHight / 2 + ScreenUtil.getInstance().dip2px(15);
        }
        this.rightStatisticView.requestLayout();
        this.rightStatisticView.requestLayout();
    }

    public void setStatisticVisibility(boolean showLeft, boolean showRight) {
        if (showLeft) {
            this.leftStatisticView.setVisibility(0);
        } else {
            this.leftStatisticView.setVisibility(8);
        }
        if (showRight) {
            this.rightStatisticView.setVisibility(0);
        } else {
            this.rightStatisticView.setVisibility(8);
        }
    }

    public void updateStaticCount(PkCrownInfo info) {
        this.leftStatisticView.setAlertCount(info.cfCEPNUM);
        this.rightStatisticView.setAlertCount(info.cfCEPNUM);
        this.leftStatisticView.setMaxCount(info.cfCFNUM);
        this.rightStatisticView.setMaxCount(info.cfCFNUM);
        if (info != null && info.mState == 1) {
            this.setStatisticVisibility(false, false);
        }
        if (info.frozenSec > 0) {
            int frozenLength = info.frozenSec * 1000;
            this.leftStatisticView.startCountDown(frozenLength);
            this.rightStatisticView.startCountDown(frozenLength);
            if (info.crownEf == 1) {
                this.leftStatisticView.setCurrentGiftCount(info.cfCFNUM);
                this.rightStatisticView.setCurrentGiftCount(info.rgnum);
            } else if (info.crownEf == 2) {
                this.leftStatisticView.setCurrentGiftCount(info.lgnum);
                this.rightStatisticView.setCurrentGiftCount(info.cfCFNUM);
            } else {
                this.leftStatisticView.setCurrentGiftCount(info.lgnum);
                this.rightStatisticView.setCurrentGiftCount(info.rgnum);
            }
        } else {
            this.leftStatisticView.setCurrentGiftCount(info.lgnum);
            this.rightStatisticView.setCurrentGiftCount(info.rgnum);
        }
    }

    @Override
    public void onEventBind() {
        super.onEventBind();
        if (this.mPKCrownModuleSniperEventBinder == null) {
            this.mPKCrownModuleSniperEventBinder = new PKCrownModule$$EventBinder();
        }
        this.mPKCrownModuleSniperEventBinder.bindEvent((Object)this);
    }

    @Override
    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mPKCrownModuleSniperEventBinder != null) {
            this.mPKCrownModuleSniperEventBinder.unBindEvent();
        }
    }

    private static enum PkAction {
        Start,
        Going,
        End;

    }

    private class PkCrownBeadFactory
    implements BeadFactory {
        private Context mContext;

        private PkCrownBeadFactory(Context context) {
            this.mContext = context;
        }

        @NotNull
        public Bead create(@NotNull NecklaceContext necklace, @NotNull Lifecycle lifecycle, @NonNull BeadsConfig beadsConfig) {
            MLog.info((Object)PKCrownModule.TAG, (String)"onCreateCrownBead", (Object[])new Object[0]);
            PKCrownModule.this.pkCrownUi = new PkCrownBead(this.mContext, necklace);
            while (PKCrownModule.this.cachePkAction.size() > 0) {
                PkAction action = (PkAction)((Object)PKCrownModule.this.cachePkAction.poll());
                switch (action) {
                    case Start: {
                        PKCrownModule.this.pkCrownUi.onPkStart();
                        break;
                    }
                    case Going: {
                        PKCrownModule.this.pkCrownUi.onPkGoing();
                        break;
                    }
                    case End: {
                        PKCrownModule.this.pkCrownUi.onPkEnd();
                        break;
                    }
                }
            }
            return PKCrownModule.this.pkCrownUi;
        }
    }
}

