/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.pkmvp.ui.seat;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Typeface;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.channelpk.coremodule.model.pkmvp.PkMvpSeatRankItem;
import com.yy.mobile.channelpk.ui.pkmvp.ui.seat.CircleCoverView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.CircleCompatImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.memoryrecycle.drawablerecycle.DrawableUtil;
import com.yy.mobile.plugin.pluginunionchannelpk.R;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class PkMvpSeatAdapter
extends RecyclerView.Adapter<SeatItemHolder> {
    private boolean isAnimationPlayed = false;
    private ArrayList<PkMvpSeatRankItem> items = new ArrayList();
    OnItemClickListener mItemClickListener;

    public SeatItemHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == ITEM_TYPE.ITEM_TYPE_BIG.ordinal()) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_pk_mvp_seat_big, parent, false);
            return new SeatItemHolder(view);
        }
        if (viewType == ITEM_TYPE.ITEM_TYPE_SMALL.ordinal()) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_pk_nor_seat_small, parent, false);
            return new SeatItemHolder(view);
        }
        return null;
    }

    public void onBindViewHolder(final SeatItemHolder holder, final int position) {
        PkMvpSeatRankItem item = this.items.get(position);
        if (item != null) {
            if (holder.iconMvp != null) {
                if (item.isMvp()) {
                    this.playMinAnimationWithRotation((View)holder.tvRankNumber);
                    this.playMaxAnimationWithRotation(holder.iconMvp, 500L);
                } else {
                    holder.tvRankNumber.setRotationY(0.0f);
                    holder.iconMvp.setRotationY(-90.0f);
                    holder.iconMvp.setVisibility(8);
                }
            }
            if (!item.isOurTeam()) {
                try {
                    holder.tvRankNumber.setTypeface(Typeface.createFromAsset((AssetManager)BasicConfig.getInstance().getAppContext().getAssets(), (String)"fonts/DINMittelschrift_Alternate.otf"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                holder.tvRankNumber.setTextColor(Color.parseColor((String)"#ffffff"));
                holder.tvRankNumber.setText((CharSequence)(item.rankNum() + ""));
                holder.tvRankNumber.setBackgroundResource(R.drawable.bkg_pk_mvp_number_them);
                if (!StringUtils.isEmpty((String)item.getHeadImageUrl()).booleanValue()) {
                    ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)item.getHeadImageUrl(), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                        public void onLoadFailed(Exception e) {
                        }

                        public void onResourceReady(Bitmap bitmap) {
                            holder.ciHead.setImageBitmap(bitmap);
                        }
                    });
                    holder.rlHeadBkg.setBackgroundResource(R.drawable.bkg_head_out_them);
                } else {
                    holder.rlHeadBkg.setBackgroundResource(R.drawable.bkg_head_out_them_nobody);
                    holder.ciHead.setImageDrawable(DrawableUtil.getDrawable((int)R.drawable.pk_mvp_seat_nobody));
                }
                if (item.isFirstRank()) {
                    this.playFirstInRankAnimation(holder.vScanLight, holder.itemView, holder.ciHead.getWidth());
                }
            } else {
                try {
                    holder.tvRankNumber.setTypeface(Typeface.createFromAsset((AssetManager)BasicConfig.getInstance().getAppContext().getAssets(), (String)"fonts/DINMittelschrift_Alternate.otf"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                holder.tvRankNumber.setText((CharSequence)(item.rankNum() + ""));
                holder.tvRankNumber.setBackgroundResource(R.drawable.bkg_pk_mvp_number_us);
                if (!StringUtils.isEmpty((String)item.getHeadImageUrl()).booleanValue()) {
                    ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)item.getHeadImageUrl(), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                        public void onLoadFailed(Exception e) {
                        }

                        public void onResourceReady(Bitmap bitmap) {
                            holder.ciHead.setImageBitmap(bitmap);
                        }
                    });
                    if (item.isMyself()) {
                        holder.tvRankNumber.setBackgroundResource(R.drawable.bkg_pk_mvp_number_me);
                        holder.tvRankNumber.setTextColor(Color.parseColor((String)"#000000"));
                        holder.rlHeadBkg.setBackgroundResource(R.drawable.bkg_head_out_me);
                    } else {
                        holder.tvRankNumber.setTextColor(Color.parseColor((String)"#ffffff"));
                        holder.rlHeadBkg.setBackgroundResource(R.drawable.bkg_head_out_us);
                    }
                } else {
                    holder.tvRankNumber.setTextColor(Color.parseColor((String)"#ffffff"));
                    holder.rlHeadBkg.setBackgroundResource(R.drawable.bkg_head_out_us_nobody);
                    holder.ciHead.setImageDrawable(DrawableUtil.getDrawable((int)R.drawable.pk_mvp_seat_nobody));
                }
                if (item.isFirstRank()) {
                    this.playFirstInRankAnimation(holder.vScanLight, holder.itemView, holder.ciHead.getWidth());
                }
            }
            if (item.isFailed() && !item.isMvp()) {
                holder.rlHeadBkg.setBackgroundResource(R.drawable.bkg_head_pk_mvp_ace);
                holder.tvRankNumber.setBackgroundResource(R.drawable.bkg_pk_mvp_number_ace);
                holder.tvRankNumber.setTextColor(Color.parseColor((String)"#ffffff"));
                holder.headCover.setVisibility(0);
            } else {
                holder.headCover.setVisibility(8);
            }
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PkMvpSeatAdapter.this.mItemClickListener != null) {
                    PkMvpSeatAdapter.this.mItemClickListener.onItemClick(position);
                }
            }
        });
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getItemViewType(int position) {
        if (this.items.get(position).rankNum() == 1) {
            return ITEM_TYPE.ITEM_TYPE_BIG.ordinal();
        }
        return ITEM_TYPE.ITEM_TYPE_SMALL.ordinal();
    }

    public void setItems(List<PkMvpSeatRankItem> seatItems) {
        this.items.clear();
        this.items.addAll(seatItems);
        this.notifyDataSetChanged();
    }

    private void playMaxAnimation(View view, long millisecon) {
        ObjectAnimator animX = ObjectAnimator.ofFloat((Object)view, (String)"scaleX", (float[])new float[]{0.2f, 1.0f});
        ObjectAnimator animY = ObjectAnimator.ofFloat((Object)view, (String)"scaleY", (float[])new float[]{0.2f, 1.0f});
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)animX).with((Animator)animY);
        animatorSet.setDuration(millisecon);
        animatorSet.start();
    }

    private void playMaxAnimationWithRotation(final View view, long millisecon) {
        ObjectAnimator animatorRY = ObjectAnimator.ofFloat((Object)view, (String)"rotationY", (float[])new float[]{-90.0f, 0.0f});
        animatorRY.setDuration(millisecon);
        animatorRY.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                view.setVisibility(0);
            }

            public void onAnimationEnd(Animator animator) {
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        animatorRY.setStartDelay(500L);
        animatorRY.start();
    }

    private void playMinAnimationWithRotation(View view) {
        ObjectAnimator animatorRY = ObjectAnimator.ofFloat((Object)view, (String)"rotationY", (float[])new float[]{0.0f, 90.0f});
        animatorRY.setDuration(500L);
        animatorRY.start();
    }

    private void playFirstInRankAnimation(final View scanLight, View viewNumber, int width) {
        this.playMaxAnimation(viewNumber, 500L);
        ObjectAnimator transX = ObjectAnimator.ofFloat((Object)scanLight, (String)"translationX", (float[])new float[]{-ScreenUtil.getInstance().dip2px(31), ScreenUtil.getInstance().dip2px(31)});
        transX.setDuration(500L);
        transX.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                scanLight.setVisibility(0);
            }

            public void onAnimationEnd(Animator animator) {
                scanLight.setVisibility(8);
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        transX.setStartDelay(700L);
        transX.start();
    }

    public void setItemClickListener(OnItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    static interface OnItemClickListener {
        public void onItemClick(int var1);
    }

    public class SeatItemHolder
    extends RecyclerView.ViewHolder {
        public CircleCompatImageView ciHead;
        public TextView tvRankNumber;
        public RelativeLayout rlHeadBkg;
        public View iconMvp;
        public CircleCoverView headCover;
        public View vScanLight;

        public SeatItemHolder(View itemView) {
            super(itemView);
            this.ciHead = (CircleCompatImageView)itemView.findViewById(R.id.iv_pk_head_item);
            this.tvRankNumber = (TextView)itemView.findViewById(R.id.tv_pk_rank_item);
            this.rlHeadBkg = (RelativeLayout)itemView.findViewById(R.id.rl_head_bkg);
            this.iconMvp = itemView.findViewById(R.id.icon_mvp);
            this.headCover = (CircleCoverView)itemView.findViewById(R.id.head_corver);
            this.vScanLight = itemView.findViewById(R.id.v_scan_light);
        }
    }

    private static enum ITEM_TYPE {
        ITEM_TYPE_BIG,
        ITEM_TYPE_SMALL;

    }
}

