/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.channelpk.utils.VideoUtils;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.util.ActivityUtilKt;
import com.yymobile.core.ICoreManagerBase;
import java.lang.ref.WeakReference;

public abstract class PKModule
implements EventCompat {
    protected DisplayMetrics dm;
    protected int screenWith;
    protected int screenHight;
    protected View mRootView;
    protected View mContainerView;
    protected WeakReference<FragmentActivity> mContext;
    protected DialogLinkManager mDialogManager;
    protected float mRatio;
    private static final String TAG = "[channelpk_main] PKModule";

    public void onEventBind() {
    }

    public void onEventUnBind() {
    }

    protected void attach(FragmentActivity activity) {
        if (this.mContext == null) {
            this.mContext = new WeakReference<FragmentActivity>(activity);
            this.dm = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getMetrics(this.dm);
            this.screenWith = this.dm.widthPixels < this.dm.heightPixels ? this.dm.widthPixels : this.dm.heightPixels;
            this.screenHight = this.dm.widthPixels < this.dm.heightPixels ? this.dm.heightPixels : this.dm.widthPixels;
            this.mDialogManager = new DialogLinkManager((Context)this.mContext.get());
            this.mRatio = VideoUtils.getRatio();
        }
    }

    protected void create(ViewGroup container) {
        this.mContainerView = container;
        if (this.mRootView == null) {
            if (null != container) {
                container.removeAllViews();
            }
            this.mRootView = this.onCreateView(this.getActivity().getLayoutInflater(), container);
        }
        this.onViewCreated(this.mRootView);
    }

    protected void onViewCreated(View view) {
        if (null != this.mContainerView) {
            this.mContainerView.setVisibility(0);
        }
        ICoreManagerBase.addClient((Object)this);
    }

    protected void onDestroy() {
        if (null != this.mContainerView) {
            this.mContainerView.setVisibility(8);
        }
        ICoreManagerBase.removeClient((Object)this);
    }

    protected Activity getActivity() {
        if (this.mContext != null && this.mContext.get() != null) {
            return (Activity)this.mContext.get();
        }
        return null;
    }

    protected boolean checkActivityInvalid() {
        return this.mContext != null && this.mContext.get() != null && !((FragmentActivity)this.mContext.get()).isFinishing() && (Build.VERSION.SDK_INT <= 17 || !((FragmentActivity)this.mContext.get()).isDestroyed());
    }

    @Nullable
    protected FragmentManager getFragmentManager() {
        FragmentActivity fragmentActivity = (FragmentActivity)this.mContext.get();
        if (fragmentActivity != null) {
            return fragmentActivity.getSupportFragmentManager();
        }
        return null;
    }

    protected Resources getResources() {
        return BasicConfig.getInstance().getAppContext().getResources();
    }

    protected boolean isLandScape() {
        if (this.mContext == null && this.mContext.get() == null) {
            return false;
        }
        Activity activity = (Activity)this.mContext.get();
        return ActivityUtilKt.isLandScape((Activity)activity);
    }

    @SuppressLint(value={"ToastUsage"})
    protected void toast(String message) {
        Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)message, (int)0).show();
    }

    protected abstract int onViewAttach();

    @Nullable
    protected abstract View onCreateView(LayoutInflater var1, ViewGroup var2);

    protected void onOrientationChanged(boolean isLandscape) {
        this.mRatio = VideoUtils.getRatio();
    }

    protected abstract void onPkStart();

    protected abstract void onPkGoing();

    protected abstract void onPkEnd();
}

