/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui;

import android.content.Context;
import android.support.v4.app.FragmentActivity;
import android.view.ViewGroup;
import com.yy.mobile.channelpk.presenter.PkComponentPresenter;
import com.yy.mobile.channelpk.ui.IPkComponentView;
import com.yy.mobile.channelpk.ui.PkComponentViewProxy;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.SafeDispatchHandler;
import java.lang.ref.WeakReference;

public class PkComponentManager
implements IPkComponentView {
    private SafeDispatchHandler mHandler;
    public WeakReference<FragmentActivity> mContext;
    private PkComponentPresenter presenter;
    private PkComponentViewProxy proxy;

    public PkComponentManager(FragmentActivity context, SafeDispatchHandler handler) {
        this.mHandler = handler;
        this.mContext = new WeakReference<FragmentActivity>(context);
        this.presenter = new PkComponentPresenter(this);
    }

    public void addPkComponent(ViewGroup viewGroup) {
        FragmentActivity fragmentActivity = (FragmentActivity)this.mContext.get();
        if (fragmentActivity != null && this.proxy == null) {
            this.proxy = new PkComponentViewProxy(fragmentActivity, this.mHandler, this.presenter);
        }
        if (null != this.proxy) {
            this.proxy.addPkComponent(viewGroup);
        }
    }

    public void updateUI() {
        if (this.proxy != null) {
            this.proxy.updateUI();
        }
    }

    @Override
    public boolean isHaveLoadCompnoent() {
        if (this.proxy != null) {
            return this.proxy.isHaveLoadCompnoent();
        }
        return false;
    }

    @Override
    public void removePkBar() {
        if (this.proxy != null) {
            this.proxy.removePkBar();
        }
    }

    @Override
    public SafeDispatchHandler getHandler() {
        return this.mHandler;
    }

    @Override
    public void showDialogOnStop(int leftCount, long forbidsec) {
        if (this.proxy != null) {
            this.proxy.showDialogOnStop(leftCount, forbidsec);
        }
    }

    @Override
    public void showTips(String tips) {
        if (this.mContext != null && this.mContext.get() != null) {
            Toast.makeText((Context)((Context)this.mContext.get()), (CharSequence)tips, (int)0).show();
        }
    }

    @Override
    public void onPkStart() {
        if (this.proxy != null) {
            this.proxy.onPkStart();
        }
    }

    @Override
    public void onPkGoing() {
        if (this.proxy != null) {
            this.proxy.onPkGoing();
        }
    }

    @Override
    public void onPkEnd() {
        if (this.proxy != null) {
            this.proxy.onPkEnd();
        }
    }

    @Override
    public void addModel(int model) {
        if (this.proxy != null) {
            this.proxy.addModel(model);
        }
    }

    @Override
    public void removeModel(int model) {
        if (this.proxy != null) {
            this.proxy.removeModel(model);
        }
    }

    public void clear() {
        this.presenter.clear();
        if (this.proxy != null) {
            this.proxy.clear();
            this.proxy = null;
        }
    }
}

