/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.module;

import android.graphics.Color;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import com.yy.mobile.RxBus;
import com.yy.mobile.channelpk.coremodule.core.IChannelPKCore;
import com.yy.mobile.channelpk.ui.module.base.UserInvisibleModule;
import com.yy.mobile.liveapi.pk.PkChannelMessage;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.channel.ChannelMessage;

public class PKRankTicketModule
extends UserInvisibleModule {
    private boolean isShowStarTip = false;
    private Runnable showTicketMessageRunnable = new Runnable(){

        @Override
        public void run() {
            PKRankTicketModule.this.sendTicketMessage();
        }
    };

    @Override
    protected void onViewCreated(View view) {
        super.onViewCreated(view);
    }

    @Override
    protected void onPkStart() {
        this.updateView();
    }

    @Override
    protected void onPkGoing() {
        this.updateView();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.isShowStarTip = false;
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.showTicketMessageRunnable);
    }

    private void updateView() {
        if (!this.isShowStarTip) {
            this.isShowStarTip = true;
            YYTaskExecutor.postToMainThread((Runnable)this.showTicketMessageRunnable, (long)1000L);
        }
    }

    public void sendTicketMessage() {
        if (((IChannelPKCore)CoreFactory.getCore(IChannelPKCore.class)).getChannelPkInfo().minTicketForStar == 0L) {
            return;
        }
        String ticket = String.valueOf(((IChannelPKCore)CoreFactory.getCore(IChannelPKCore.class)).getChannelPkInfo().minTicketForStar);
        PkChannelMessage message = new PkChannelMessage();
        message.channelMessageType = ChannelMessage.ChannelMsgType.CUSTOMS_MESSAGE_TYPE;
        String msg = "\u672c\u573a\u8fbe\u5230" + ticket + "\u7968\uff0c\u6b22\u4e50\u6597\u83b7\u80dc\u624d\u80fd\u83b7\u5f97\u661f\u661f~";
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)msg);
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#4bc2ff")), 0, msg.length(), 33);
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffc426")), 4, 4 + ticket.length(), 33);
        message.spannable = spannable;
        RxBus.getDefault().post((Object)message);
    }
}

