/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.pknor.ui;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.RelativeLayout;
import com.yy.mobile.plugin.pluginunionchannelpk.R;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;

public class RadarLayout
extends RelativeLayout {
    private static final String TAG = "SearchLayout";
    private static final int DEFAULT_RADAR_NUMS = 2;
    private static final int DEFAULT_DURATION_TIME = 850;
    private static final float DEFAULT_SCALE = 4.0f;
    private static final int DEFAULT_RADAR_COLOR = Color.rgb((int)255, (int)221, (int)0);
    private static final int DEFAULT_STROKE_WIDTH = 0;
    private static final int DEFAULT_RADIUS = 64;
    private int mRadarColor = DEFAULT_RADAR_COLOR;
    private float mStrokeWidth = 0.0f;
    private float mRadarRadius = 64.0f;
    private int mAnimDuration;
    private int mRadarViewNums;
    private int mAnimDelay;
    private float mRadarScale;
    private boolean animationRunning = false;
    private Paint mPaint = new Paint();
    private AnimatorSet mAnimatorSet = new AnimatorSet();
    private ArrayList<Animator> mAnimatorList = new ArrayList();
    private RelativeLayout.LayoutParams mRadarViewParams;

    public void startRadarAnimation() {
        if (!this.isRadarAnimationRunning()) {
            this.makeRadarViewsVisible();
            this.mAnimatorSet.start();
            this.animationRunning = true;
        }
    }

    public void makeRadarViewsVisible() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            if (!(childView instanceof RadarItemView)) continue;
            childView.setVisibility(0);
        }
    }

    public void stopRadarAnimation() {
        if (this.isRadarAnimationRunning()) {
            this.mAnimatorSet.end();
            this.animationRunning = false;
        }
    }

    public boolean isRadarAnimationRunning() {
        return this.animationRunning;
    }

    public void onReleaseRadarResource() {
        if (this.mAnimatorSet != null) {
            this.mAnimatorSet.end();
            this.mAnimatorSet = null;
            this.animationRunning = false;
        }
    }

    public RadarLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public RadarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public RadarLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            MLog.error((Object)TAG, (String)"is in edit mode..", (Object[])new Object[0]);
            return;
        }
        if (null != attrs) {
            this.initTypedArray(context, attrs);
        }
        this.initPaint();
        this.initRadarViewLayoutParams();
        this.generateRadarViews();
    }

    private void initTypedArray(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.RadarLayout);
        this.mRadarColor = typedArray.getColor(R.styleable.RadarLayout_radarColor, DEFAULT_RADAR_COLOR);
        this.mStrokeWidth = typedArray.getDimension(R.styleable.RadarLayout_radarStrokeWidth, 0.0f);
        this.mRadarRadius = (int)typedArray.getDimension(R.styleable.RadarLayout_radarRadius, 64.0f);
        this.mAnimDuration = typedArray.getInt(R.styleable.RadarLayout_radarDuration, 850);
        this.mRadarViewNums = typedArray.getInt(R.styleable.RadarLayout_radarNums, 2);
        this.mRadarScale = typedArray.getFloat(R.styleable.RadarLayout_radarScale, 4.0f);
        typedArray.recycle();
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mStrokeWidth = 0.0f;
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mRadarColor);
    }

    private void initRadarViewLayoutParams() {
        int radarSide = (int)(2.0f * (this.mRadarRadius + this.mStrokeWidth));
        this.mRadarViewParams = new RelativeLayout.LayoutParams(radarSide, radarSide);
        this.mRadarViewParams.addRule(13, -1);
    }

    private void calculateAnimDelay() {
        this.mAnimDelay = this.mAnimDuration / this.mRadarViewNums;
    }

    private void generateRadarViews() {
        this.calculateAnimDelay();
        this.initAnimSet();
        for (int i = 0; i < this.mRadarViewNums; ++i) {
            RadarItemView radarItemView = new RadarItemView(this.getContext());
            this.addView(radarItemView, (ViewGroup.LayoutParams)this.mRadarViewParams);
            this.addAnimToRadarView(radarItemView, i);
        }
        this.mAnimatorSet.playTogether(this.mAnimatorList);
    }

    private void initAnimSet() {
        this.mAnimatorSet.setDuration((long)this.mAnimDuration);
        this.mAnimatorSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
    }

    private void addAnimToRadarView(RadarItemView radarItemView, int i) {
        ObjectAnimator scaleXAnimator = ObjectAnimator.ofFloat((Object)((Object)radarItemView), (String)"scaleX", (float[])new float[]{1.0f, this.mRadarScale});
        scaleXAnimator.setRepeatCount(-1);
        scaleXAnimator.setRepeatMode(1);
        scaleXAnimator.setStartDelay((long)(i * this.mAnimDelay));
        scaleXAnimator.setDuration((long)this.mAnimDuration);
        this.mAnimatorList.add((Animator)scaleXAnimator);
        ObjectAnimator scaleYAnimator = ObjectAnimator.ofFloat((Object)((Object)radarItemView), (String)"scaleY", (float[])new float[]{1.0f, this.mRadarScale});
        scaleYAnimator.setRepeatMode(1);
        scaleYAnimator.setRepeatCount(-1);
        scaleYAnimator.setStartDelay((long)(i * this.mAnimDelay));
        scaleYAnimator.setDuration((long)this.mAnimDuration);
        this.mAnimatorList.add((Animator)scaleYAnimator);
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)((Object)radarItemView), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        alphaAnimator.setRepeatMode(1);
        alphaAnimator.setRepeatCount(-1);
        alphaAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        alphaAnimator.setDuration((long)this.mAnimDuration);
        alphaAnimator.setStartDelay((long)(i * this.mAnimDelay));
        this.mAnimatorList.add((Animator)alphaAnimator);
    }

    private class RadarItemView
    extends View {
        public RadarItemView(Context context) {
            super(context);
            this.setVisibility(4);
        }

        protected void onDraw(Canvas canvas) {
            int radius = Math.min(this.getWidth(), this.getHeight()) / 2;
            canvas.drawCircle((float)radius, (float)radius, (float)radius - RadarLayout.this.mStrokeWidth, RadarLayout.this.mPaint);
        }
    }
}

