/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.module;

import android.renderscript.Float2;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.channelpk.coremodule.core.IChannelPKCore;
import com.yy.mobile.channelpk.coremodule.event.ChannelPK_OnRevengeIconClick_EventArgs;
import com.yy.mobile.channelpk.coremodule.event.ChannelPK_OnShowInvitationTips_EventArgs;
import com.yy.mobile.channelpk.coremodule.model.ChannelPkNotifyInfo;
import com.yy.mobile.channelpk.ui.module.base.LayoutModule;
import com.yy.mobile.channelpk.utils.RxViewUtlis;
import com.yy.mobile.channelpk.utils.VideoUtils;
import com.yy.mobile.plugin.pluginunionchannelpk.PluginBus;
import com.yy.mobile.plugin.pluginunionchannelpk.R;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.functions.Functions;

public class PKRevengeIconModule
extends LayoutModule {
    private static final String TAG = "PKRevengeIconModule";
    private ImageView mIcon;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();
    public static Float2 sIconScreenPos = new Float2(0.0f, 0.0f);
    private int mCurChannelgeNotify = 0;

    @Override
    protected int onViewAttach() {
        return R.id.module_pk_revenge_icon;
    }

    @Override
    public int onGetLayoutResId() {
        return R.layout.module_pk_revenge_icon;
    }

    @Override
    protected void onViewCreated(View view) {
        super.onViewCreated(view);
        this.mIcon = (ImageView)view.findViewById(R.id.iv_revenge_icon);
        this.mIcon.setVisibility(4);
        this.mCompositeDisposable.add(RxViewUtlis.clicks((View)this.mIcon, 500L).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                MLog.debug((Object)PKRevengeIconModule.TAG, (String)"post ChannelPK_OnRevengeIconClick_EventArgs", (Object[])new Object[0]);
                PluginBus.INSTANCE.get().post((Object)new ChannelPK_OnRevengeIconClick_EventArgs());
            }
        }, Functions.ERROR_CONSUMER));
        this.updateIconScreenPosition();
    }

    private void updateIconScreenPosition() {
        this.mIcon.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                PKRevengeIconModule.this.mIcon.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                int[] pos = new int[2];
                PKRevengeIconModule.this.mIcon.getLocationOnScreen(pos);
                PKRevengeIconModule.sIconScreenPos.x = pos[0];
                PKRevengeIconModule.sIconScreenPos.y = pos[1];
                MLog.info((Object)PKRevengeIconModule.TAG, (String)("icon Pos x:" + PKRevengeIconModule.sIconScreenPos.x + " y:" + PKRevengeIconModule.sIconScreenPos.y), (Object[])new Object[0]);
                PKRevengeIconModule.this.showInvationTips();
            }
        });
        this.mIcon.requestLayout();
    }

    @Override
    protected void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        PKRevengeIconModule.sIconScreenPos.x = 0.0f;
        PKRevengeIconModule.sIconScreenPos.y = 0.0f;
        this.updateIconLayout();
        this.updateIconScreenPosition();
    }

    @Override
    protected void onPkStart() {
        this.updateView();
    }

    @Override
    protected void onPkGoing() {
        this.updateView();
    }

    @Override
    protected void onPkEnd() {
        this.updateView();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.mCurChannelgeNotify = 0;
        this.mCompositeDisposable.clear();
        PKRevengeIconModule.sIconScreenPos.x = 0.0f;
        PKRevengeIconModule.sIconScreenPos.y = 0.0f;
    }

    private void updateView() {
        ChannelPkNotifyInfo notifyInfo = ((IChannelPKCore)ICoreManagerBase.getCore(IChannelPKCore.class)).getChannelPkInfo();
        this.mIcon.setVisibility(4);
        if (null != notifyInfo) {
            int challengeNotify = notifyInfo.challengeNotify;
            long luid = notifyInfo.luid;
            if (luid != 0L && LoginUtil.getUid() == luid) {
                this.mCurChannelgeNotify = challengeNotify;
                boolean isVisible = challengeNotify == 1 || challengeNotify == 2 || challengeNotify == 3 || challengeNotify == 4 || challengeNotify == 8;
                this.mIcon.setVisibility(isVisible ? 0 : 4);
                this.showInvationTips();
            }
        }
    }

    private void showInvationTips() {
        MLog.debug((Object)TAG, (String)("showInvationTips curChannelgeNotify:" + this.mCurChannelgeNotify + " x :" + PKRevengeIconModule.sIconScreenPos.x + " y :" + PKRevengeIconModule.sIconScreenPos.y), (Object[])new Object[0]);
        if (this.mCurChannelgeNotify == 1 && PKRevengeIconModule.sIconScreenPos.y > 0.0f) {
            PluginBus.INSTANCE.get().postDelay((Object)new ChannelPK_OnShowInvitationTips_EventArgs(), 500L);
        }
    }

    private void updateIconLayout() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mRootView.getLayoutParams();
        int topMargin = !this.isLandScape() ? (int)((float)this.screenWith / this.mRatio / 2.0f) + VideoUtils.getMarginTop() - ScreenUtil.getInstance().dip2px(58) / 2 : this.screenWith / 2 - ScreenUtil.getInstance().dip2px(58) / 2;
        params.addRule(14);
        params.topMargin = topMargin;
        this.mRootView.requestLayout();
    }
}

