/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.module.PKLogoSvgaModule;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.mobile.channelpk.ui.PKConstants;
import com.yy.mobile.channelpk.ui.module.base.LayoutModule;
import com.yy.mobile.channelpk.utils.VideoUtils;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.pluginunionchannelpk.R;
import com.yy.mobile.util.log.MLog;

public class PKLogoSvgaModule
extends LayoutModule {
    private static final String TAG = "[channelpk_main] PKLogoSvgaModule";
    private static final String LOGO_START_SVGA = "https://github.com/YvesCheung/SVGAPlayer-Android/raw/master/app/src/main/assets/norsvga/logo-start.svga";
    private boolean isShow = false;
    private SVGAImageView svgaImageView;
    private RelativeLayout svgaRootView;
    private RequestManager glideRequest;

    @Override
    protected int onViewAttach() {
        return R.id.module_pk_logo_svga;
    }

    @Override
    public int onGetLayoutResId() {
        return R.layout.layout_pk_nor_svga_base_component;
    }

    @Override
    protected void onViewCreated(View view) {
        super.onViewCreated(view);
        this.svgaRootView = (RelativeLayout)view.findViewById(R.id.svga_root_view);
        this.svgaImageView = (SVGAImageView)view.findViewById(R.id.svga_view);
        this.svgaImageView.setLoops(1);
        Context context = this.mContext.get() != null ? (Context)this.mContext.get() : view.getContext();
        this.glideRequest = Build.VERSION.SDK_INT >= 17 && context instanceof Activity && ((Activity)context).isDestroyed() ? Glide.with((Context)BasicConfig.getInstance().getAppContext()) : Glide.with((Context)context);
        this.onLayoutChange();
    }

    @Override
    protected void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        this.onLayoutChange();
    }

    @Override
    protected void onPkStart() {
        this.isShow = false;
    }

    @Override
    protected void onPkGoing() {
        this.showLogoSvga(LOGO_START_SVGA);
    }

    @Override
    protected void onPkEnd() {
        this.showLogoSvga(LOGO_START_SVGA);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.svgaImageView.stopAnimation();
    }

    public void showLogoSvga(String path) {
        if (!this.isShow) {
            this.isShow = true;
            this.glideRequest.load(path).into((ImageView)this.svgaImageView);
        }
    }

    public void onLayoutChange() {
        if (this.isLandScape()) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.svgaRootView.getLayoutParams();
            params.topMargin = this.screenWith / 2 - PKConstants.SIZE.LOGO_SVGA / 2;
            this.svgaRootView.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.svgaRootView.getLayoutParams();
            params.topMargin = (int)((float)this.screenWith / this.mRatio) / 2 + VideoUtils.getMarginTop() - PKConstants.SIZE.LOGO_SVGA / 2;
            this.svgaRootView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        MLog.info((Object)TAG, (String)("isLandscape:" + this.isLandScape() + " params.topMargin:" + ((RelativeLayout.LayoutParams)this.svgaRootView.getLayoutParams()).topMargin), (Object[])new Object[0]);
        MLog.info((Object)TAG, (String)("screenWith:" + this.screenWith + " mRatio:" + this.mRatio + " (int) (screenWith / mRatio) / 2:" + (int)((float)this.screenWith / this.mRatio) / 2), (Object[])new Object[0]);
    }
}

