/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui;

import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.view.ViewGroup;
import com.duowan.mobile.channelpk.ModuleFactory;
import com.yy.mobile.channelpk.coremodule.M_One;
import com.yy.mobile.channelpk.coremodule.M_Two;
import com.yy.mobile.channelpk.ui.PKModule;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PkModuleManager {
    private static final String TAG = "[channelpk_main] PkModuleManager ";
    private FragmentActivity activity;
    private View container;
    private List<String> currentModel;
    private Map<String, PKModule> moduleMap;

    public PkModuleManager() {
        ArrayList<String> mountList = new ArrayList<String>();
        ArrayList<String> unmountList = new ArrayList<String>();
        this.moduleMap = new HashMap<String, PKModule>();
        this.currentModel = new ArrayList<String>();
        if (M_One.isNew()) {
            MLog.info((Object)TAG, (String)"new mode", (Object[])new Object[0]);
            mountList.addAll(ModuleFactory.INSTANCE.addNewModule());
            unmountList.addAll(ModuleFactory.INSTANCE.removeNewModule());
            this.currentModel.add("2");
        } else {
            MLog.info((Object)TAG, (String)"nor mode", (Object[])new Object[0]);
            mountList.addAll(ModuleFactory.INSTANCE.addNorModule());
            unmountList.addAll(ModuleFactory.INSTANCE.removeNorModule());
            this.currentModel.add("1");
        }
        if (M_One.isRankForPkBar()) {
            MLog.info((Object)TAG, (String)"rank version1 mode", (Object[])new Object[0]);
            mountList.addAll(ModuleFactory.INSTANCE.addRankVersion1Module());
            unmountList.addAll(ModuleFactory.INSTANCE.removeRankVersion1Module());
            this.currentModel.add("5");
        } else if (M_Two.isRankForPkBar()) {
            MLog.info((Object)TAG, (String)"rank version2 mode", (Object[])new Object[0]);
            mountList.addAll(ModuleFactory.INSTANCE.addRankVersion2Module());
            unmountList.addAll(ModuleFactory.INSTANCE.removeRankVersion2Module());
            this.currentModel.add("6");
        }
        if (M_One.isMvp()) {
            MLog.info((Object)TAG, (String)"mvp mode", (Object[])new Object[0]);
            mountList.addAll(ModuleFactory.INSTANCE.addMvpModule());
            unmountList.addAll(ModuleFactory.INSTANCE.removeMvpModule());
            this.currentModel.add("3");
        }
        if (M_Two.isRevenge()) {
            MLog.info((Object)TAG, (String)"mvp mode", (Object[])new Object[0]);
            mountList.addAll(ModuleFactory.INSTANCE.addRevengeModule());
            unmountList.addAll(ModuleFactory.INSTANCE.removeRevengeModule());
            this.currentModel.add("4");
        }
        for (String module : mountList) {
            PKModule m;
            if (unmountList.contains(module) || (m = (PKModule)this.newInstance(module)) == null) continue;
            this.moduleMap.put(module, m);
        }
    }

    public void attach(FragmentActivity activity) {
        this.activity = activity;
        for (String key : this.moduleMap.keySet()) {
            this.moduleMap.get(key).attach(activity);
        }
    }

    public void create(View container) {
        this.container = container;
        for (String key : this.moduleMap.keySet()) {
            View viewPlaceHolder = container.findViewById(this.moduleMap.get(key).onViewAttach());
            if (viewPlaceHolder instanceof ViewGroup) {
                MLog.info((Object)TAG, (String)("module.create :" + key), (Object[])new Object[0]);
                this.moduleMap.get(key).create((ViewGroup)viewPlaceHolder);
                continue;
            }
            MLog.info((Object)TAG, (String)("module.create :" + key + "[no root]"), (Object[])new Object[0]);
            this.moduleMap.get(key).onViewCreated(null);
        }
    }

    public void destroy() {
        this.moduleMap.clear();
    }

    public void onPkStart() {
        for (String key : this.moduleMap.keySet()) {
            this.moduleMap.get(key).onPkStart();
        }
    }

    public void onPkGoing() {
        for (String key : this.moduleMap.keySet()) {
            this.moduleMap.get(key).onPkGoing();
        }
    }

    public void onPkEnd() {
        for (String key : this.moduleMap.keySet()) {
            this.moduleMap.get(key).onPkEnd();
        }
    }

    public void onOrientationChanged(boolean isLandscape) {
        for (String key : this.moduleMap.keySet()) {
            MLog.info((Object)TAG, (String)("module.onOrientationChanged :" + key), (Object[])new Object[0]);
            this.moduleMap.get(key).onOrientationChanged(isLandscape);
        }
    }

    public void onDestroy() {
        for (String key : this.moduleMap.keySet()) {
            MLog.info((Object)TAG, (String)("module.onDestroy :" + key), (Object[])new Object[0]);
            this.moduleMap.get(key).onDestroy();
        }
    }

    private Object newInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)("module.newInstance :" + className + " " + " [ERROR] " + e.getMessage()), (Object[])new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    public void addModel(int model) {
        if (this.activity == null || this.container == null) {
            return;
        }
        if (this.currentModel.contains(model + "")) {
            return;
        }
        ArrayList<String> addModuleList = new ArrayList<String>();
        ArrayList<String> removeModuleList = new ArrayList<String>();
        MLog.info((Object)TAG, (String)("add mode :" + model), (Object[])new Object[0]);
        if (model == 4) {
            addModuleList.addAll(ModuleFactory.INSTANCE.addRevengeModule());
            removeModuleList.addAll(ModuleFactory.INSTANCE.removeRevengeModule());
            this.currentModel.add("4");
        }
        this.onDestroy();
        for (String addModule : addModuleList) {
            PKModule m;
            if (this.moduleMap.get(addModule) != null || (m = (PKModule)this.newInstance(addModule)) == null) continue;
            this.moduleMap.put(addModule, m);
        }
        for (String removeModule : removeModuleList) {
            if (this.moduleMap.get(removeModule) == null || !this.moduleMap.containsKey(removeModule)) continue;
            this.moduleMap.remove(removeModule);
        }
        this.attach(this.activity);
        this.create(this.container);
    }

    public void removeModel(int model) {
        if (this.activity == null || this.container == null) {
            return;
        }
        if (!this.currentModel.contains(model + "")) {
            return;
        }
        ArrayList<String> addModuleList = new ArrayList<String>();
        ArrayList<String> removeModuleList = new ArrayList<String>();
        MLog.info((Object)TAG, (String)("remove mode :" + model), (Object[])new Object[0]);
        if (model == 4) {
            addModuleList.addAll(ModuleFactory.INSTANCE.addRevengeModule());
            removeModuleList.addAll(ModuleFactory.INSTANCE.removeRevengeModule());
            this.currentModel.remove("4");
        }
        this.onDestroy();
        for (String addModule : removeModuleList) {
            PKModule m;
            if (this.moduleMap.get(addModule) != null || (m = (PKModule)this.newInstance(addModule)) == null) continue;
            this.moduleMap.put(addModule, m);
        }
        for (String removeModule : addModuleList) {
            if (this.moduleMap.get(removeModule) == null || !this.moduleMap.containsKey(removeModule)) continue;
            this.moduleMap.remove(removeModule);
        }
        this.attach(this.activity);
        this.create(this.container);
    }
}

