/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.yy.mobile.plugin.pluginunionchannelpk.R;

public class CropImageView
extends AppCompatImageView {
    private static final String TAG = CropImageView.class.getSimpleName();
    private CropType mCropType;
    private Bitmap mBitmap;

    public CropImageView(Context context) {
        this(context, null);
    }

    public CropImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CropImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initTypeArray(context, attrs);
        this.initView();
    }

    private void initTypeArray(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CropImageView);
        int cropType = typedArray.getInt(R.styleable.CropImageView_cropType, -1);
        if (cropType == 0) {
            this.mCropType = CropType.LEFT_CROP;
        } else if (cropType == 1) {
            this.mCropType = CropType.RIGHT_CROP;
        } else if (cropType == 2) {
            this.mCropType = CropType.TOP_CROP;
        } else if (cropType == 3) {
            this.mCropType = CropType.BOTTOM_CROP;
        }
        typedArray.recycle();
    }

    private void initView() {
        if (this.mCropType != null) {
            this.updateCropMatrix();
        }
    }

    private void updateCropMatrix() {
        Bitmap bitmap = this.getImageBitmap();
        if (bitmap == null) {
            return;
        }
        this.setScaleType(ImageView.ScaleType.MATRIX);
        Matrix mMatrix = new Matrix();
        float scale = 1.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        int vHeight = this.getHeight() - this.getPaddingLeft() - this.getPaddingRight();
        int vWidth = this.getWidth() - this.getPaddingTop() - this.getPaddingBottom();
        int dWidth = this.getImageBitmap().getWidth();
        int dHeight = this.getImageBitmap().getHeight();
        if (this.mCropType == CropType.LEFT_CROP) {
            scale = (float)vHeight / (float)dHeight;
            dx = 0.0f;
        } else if (this.mCropType == CropType.RIGHT_CROP) {
            scale = (float)vHeight / (float)dHeight;
            dx = (float)vWidth - (float)dWidth * scale;
        } else if (this.mCropType == CropType.TOP_CROP) {
            scale = (float)vWidth / (float)dWidth;
            dy = 0.0f;
        } else if (this.mCropType == CropType.BOTTOM_CROP) {
            scale = (float)vWidth / (float)dWidth;
            dy = (float)vHeight - (float)dHeight * scale;
        }
        mMatrix.setScale(scale, scale);
        mMatrix.postTranslate((float)Math.round(dx), (float)Math.round(dy));
        this.setImageMatrix(mMatrix);
    }

    public void setCropType(CropType cropType) {
        this.mCropType = cropType;
        this.updateCropMatrix();
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.mBitmap = bm;
        this.updateCropMatrix();
    }

    private Bitmap getImageBitmap() {
        if (this.mBitmap != null) {
            return this.mBitmap;
        }
        this.setDrawingCacheEnabled(true);
        Bitmap bitmap = this.getDrawingCache();
        this.setDrawingCacheEnabled(false);
        if (bitmap == null) {
            return null;
        }
        return bitmap;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateCropMatrix();
    }

    public static enum CropType {
        LEFT_CROP,
        RIGHT_CROP,
        TOP_CROP,
        BOTTOM_CROP;

    }
}

