/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.pknor.ui.circleProgressView;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.yy.mobile.plugin.pluginunionchannelpk.R;

public class CirclepkprogressView
extends View {
    Context mContex;
    Paint mCirclePaint;
    Paint mCircleInnerPaint;
    Paint mTextPaintColor;
    Paint mTextPaintWhite;
    int mWidth = 0;
    int mHeight = 0;
    float mCount = 1.0f;
    String textColor = "";
    String textWhite = "";
    RectF mCircleRectF;
    float circleRadiusExtra = 0.0f;
    float circleRadius = 0.0f;
    int maxCOUNT = 66;
    private static final int MIN_COUNT = 0;
    private static final int CIRCLE_LINE_WIDTH = 5;
    private static final int TEXT_SIZE = 10;
    private static final int PADDING = 8;
    int colorResourseId = R.color.miaobian_crown_color;

    public CirclepkprogressView(Context context) {
        super(context);
        this.init(context);
    }

    public CirclepkprogressView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mContex = context;
        this.mCirclePaint = new Paint();
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setStrokeWidth((float)this.dp2px(context, 5.0f));
        this.mCirclePaint.setStyle(Paint.Style.STROKE);
        this.mCirclePaint.setColor(ContextCompat.getColor((Context)context, (int)this.colorResourseId));
        this.mCircleInnerPaint = new Paint();
        this.mCircleInnerPaint.setAntiAlias(true);
        this.mCircleInnerPaint.setStyle(Paint.Style.FILL);
        this.mCircleInnerPaint.setColor(ContextCompat.getColor((Context)context, (int)R.color.supergrey));
        this.mCircleInnerPaint.setAlpha(180);
        this.mTextPaintColor = new TextPaint();
        this.mTextPaintColor.setAntiAlias(true);
        this.mTextPaintColor.setStyle(Paint.Style.FILL);
        this.mTextPaintColor.setTypeface(Typeface.DEFAULT_BOLD);
        this.mTextPaintColor.setColor(ContextCompat.getColor((Context)context, (int)this.colorResourseId));
        this.mTextPaintColor.setTextSize((float)this.sp2px(context, 10.0f));
        this.mTextPaintWhite = new TextPaint();
        this.mTextPaintWhite.setAntiAlias(true);
        this.mTextPaintWhite.setStyle(Paint.Style.FILL);
        this.mTextPaintWhite.setTypeface(Typeface.DEFAULT_BOLD);
        this.mTextPaintWhite.setColor(ContextCompat.getColor((Context)context, (int)R.color.white));
        this.mTextPaintWhite.setTextSize((float)this.sp2px(context, 10.0f));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mHeight = this.getMeasuredHeight();
        this.mWidth = this.getMeasuredWidth();
    }

    public void setCount(int count) {
        if (count > this.maxCOUNT) {
            count = this.maxCOUNT;
        }
        if (count < 0) {
            count = 0;
        }
        this.mCount = count;
        this.textColor = count + "";
        this.textWhite = "/" + this.maxCOUNT;
        if (this.mCount < (float)this.maxCOUNT) {
            this.postInvalidate();
        } else {
            this.textWhite = "";
            this.textColor = "";
        }
    }

    protected void onDraw(Canvas canvas) {
        float halfWidth = this.mWidth / 2;
        float halfHeight = this.mHeight / 2;
        this.circleRadius = halfWidth - (float)this.dp2px(this.mContex, 8.0f);
        this.circleRadiusExtra = halfWidth;
        canvas.drawCircle(halfWidth, halfHeight, this.circleRadiusExtra - (float)(this.dp2px(this.mContex, 5.0f) / 2), this.mCircleInnerPaint);
        if (null == this.mCircleRectF) {
            this.mCircleRectF = new RectF(halfWidth - this.circleRadius, halfHeight - this.circleRadius, halfWidth + this.circleRadius, halfHeight + this.circleRadius);
        }
        float swipeProgress = this.mCount / (float)this.maxCOUNT * 360.0f;
        this.mCirclePaint.setColor(ContextCompat.getColor((Context)this.mContex, (int)R.color.lightgrey));
        this.mCirclePaint.setAlpha(50);
        canvas.drawArc(this.mCircleRectF, -90.0f, 360.0f, false, this.mCirclePaint);
        this.mCirclePaint.setColor(ContextCompat.getColor((Context)this.mContex, (int)this.colorResourseId));
        this.mCirclePaint.setAlpha(255);
        canvas.drawArc(this.mCircleRectF, -90.0f, swipeProgress, false, this.mCirclePaint);
        canvas.drawText(this.textColor, halfWidth - this.mTextPaintColor.measureText(this.textColor + this.textWhite) / 2.0f, halfHeight - (this.mTextPaintColor.ascent() + this.mTextPaintColor.descent()) / 2.0f, this.mTextPaintColor);
        canvas.drawText(this.textWhite, halfWidth - this.mTextPaintWhite.measureText(this.textColor + this.textWhite) / 2.0f + this.mTextPaintColor.measureText(this.textColor), halfHeight - (this.mTextPaintWhite.ascent() + this.mTextPaintWhite.descent()) / 2.0f, this.mTextPaintWhite);
    }

    public int dp2px(Context context, float dpVal) {
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public int sp2px(Context context, float spVal) {
        return (int)TypedValue.applyDimension((int)2, (float)spVal, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public void setMaxCount(int maxCount) {
        this.maxCOUNT = maxCount;
        this.setCount((int)this.mCount);
        this.postInvalidate();
    }

    public void setColorResourseId(int resourseId) {
        this.colorResourseId = resourseId;
        this.mCirclePaint.setColor(ContextCompat.getColor((Context)this.mContex, (int)this.colorResourseId));
        this.mTextPaintColor.setColor(ContextCompat.getColor((Context)this.mContex, (int)this.colorResourseId));
        this.postInvalidate();
    }
}

