/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui.pknor.ui;

import android.content.Context;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.widget.WhitespaceSpannable;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;

public class MarqueeLayout
extends FrameLayout {
    private static final String TAG = "PkMarqueeLayout";
    public static final String SPACE_PLACEHOLDER = "[space]";
    public static final float SPACE_WIDTH = 60.0f;
    private Context mContext;
    private TextView mTextView;
    private int mMarqueWidth = 0;
    private long mDuration = 3000L;
    private int mScrollWidth = 0;
    private TranslateAnimation translateAnimation;
    private int moveStartX = (int)ResolutionUtils.convertDpToPixel((float)33.0f, (Context)BasicConfig.getInstance().getAppContext());
    private OffsetType type = OffsetType.Cancle;

    public void setType(OffsetType type) {
        this.type = type;
    }

    public MarqueeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mTextView = new TextView(this.mContext);
        this.mTextView.setSingleLine(true);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -2);
        this.addView((View)this.mTextView, lp);
    }

    public void setMarqueWidth(int width) {
        if (width < 0) {
            return;
        }
        this.mMarqueWidth = width;
    }

    private void startMarquee() {
        this.reserverAnimation();
        if (this.mTextView != null) {
            TextPaint paint = this.mTextView.getPaint();
            CharSequence content = this.mTextView.getText();
            float len = Layout.getDesiredWidth((CharSequence)content, (TextPaint)paint);
            if (this.getMeasuredWidth() > 0) {
                this.mMarqueWidth = this.getMeasuredWidth();
            }
            int marqueWidth = this.mMarqueWidth;
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)(" len = " + len + " ; mMarqueWidth " + marqueWidth), (Object[])new Object[0]);
            }
            if (len > (float)marqueWidth) {
                SpannableStringBuilder spannable = new SpannableStringBuilder(content);
                int idx = spannable.toString().indexOf(SPACE_PLACEHOLDER);
                float spaceWidth = ResolutionUtils.convertDpToPixel((float)60.0f, (Context)this.getContext());
                if (idx >= 0 && idx + SPACE_PLACEHOLDER.length() < spannable.length()) {
                    spannable.setSpan((Object)new WhitespaceSpannable(spaceWidth), idx, idx + SPACE_PLACEHOLDER.length(), 33);
                }
                this.mTextView.setText((CharSequence)spannable);
                float width = Layout.getDesiredWidth((CharSequence)spannable, (TextPaint)paint);
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams((int)width, -2);
                lp.leftMargin = 0;
                this.mTextView.setLayoutParams((ViewGroup.LayoutParams)lp);
                this.mScrollWidth = (int)(-(len - (float)marqueWidth)) - 60;
                if (this.translateAnimation == null) {
                    this.translateAnimation = this.type == OffsetType.Cancle ? new TranslateAnimation(0.0f, (float)this.mScrollWidth, 0.0f, 0.0f) : new TranslateAnimation((float)this.moveStartX, (float)this.mScrollWidth, 0.0f, 0.0f);
                    this.translateAnimation.setFillAfter(false);
                    this.translateAnimation.setDuration(this.mDuration);
                    this.translateAnimation.setInterpolator((Interpolator)new LinearInterpolator());
                }
                this.mTextView.startAnimation((Animation)this.translateAnimation);
            } else {
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
                if (this.type == OffsetType.Need) {
                    lp.leftMargin = this.moveStartX;
                } else if (this.type == OffsetType.Cancle) {
                    lp.leftMargin = 0;
                }
                this.mTextView.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
    }

    public void reserverAnimation() {
        if (this.translateAnimation != null) {
            this.translateAnimation.cancel();
            this.translateAnimation = null;
        }
        if (this.mTextView != null) {
            this.mTextView.setTranslationX(0.0f);
        }
    }

    public void setText(Spannable info) {
        if (this.mTextView != null) {
            if (info != null) {
                this.mTextView.setTextSize(1, 11.0f);
                this.mTextView.setText((CharSequence)info);
            }
            this.startMarquee();
        }
    }

    public static enum OffsetType {
        Need,
        Cancle;

    }
}

