/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.ui;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.FragmentActivity;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.mobile.spdt.annotation.VIVO;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.channelpk.coremodule.M_One;
import com.yy.mobile.channelpk.coremodule.core.IChannelPKCore;
import com.yy.mobile.channelpk.presenter.PkComponentPresenter;
import com.yy.mobile.channelpk.ui.PKConstants;
import com.yy.mobile.channelpk.ui.PkComponentViewProxy$$EventBinder;
import com.yy.mobile.channelpk.ui.PkModuleManager;
import com.yy.mobile.channelpk.ui.manager.model.PKModelManager;
import com.yy.mobile.channelpk.ui.pkproxy.BasePKModuleManager;
import com.yy.mobile.channelpk.ui.pkproxy.IPKViewProxy;
import com.yy.mobile.channelpk.utils.VideoUtils;
import com.yy.mobile.liveapi.container.action.VideoCompnoentRateChangeAction;
import com.yy.mobile.liveapi.pk.IPkCore;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onChatEmotionComponentDismiss_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onShowChatInputBroadcast_EventArgs;
import com.yy.mobile.plugin.main.events.VivoSplitScreen_EventArgs;
import com.yy.mobile.plugin.pluginunionchannelpk.R;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.liveapi.reqaction.MoveTabReqAction;
import java.lang.ref.WeakReference;

public class PkComponentViewProxy
implements IPKViewProxy,
EventCompat {
    private static final String TAG = "[channelpk_main] PkComponentViewProxy";
    public WeakReference<FragmentActivity> mContext;
    private PkComponentPresenter presenter;
    public ViewGroup pkRootView;
    protected View pkComponentView;
    public LayoutInflater inflater;
    protected RelativeLayout pkBar;
    private DisplayMetrics dm;
    protected int screenWith = 0;
    protected int screenHight = 0;
    private DialogLinkManager mDialogManager;
    private float mRatio;
    private boolean isMoveTab;
    public BasePKModuleManager pkModuleManager;
    private PKModelManager pkModelManager;
    private EventBinder mPkComponentViewProxySniperEventBinder;

    public PkComponentViewProxy(FragmentActivity context, SafeDispatchHandler handler, PkComponentPresenter presenter) {
        this.presenter = presenter;
        this.mContext = new WeakReference<FragmentActivity>(context);
        this.inflater = LayoutInflater.from((Context)context.getApplicationContext());
        this.onEventBind();
        if (context != null && this.mContext.get() != null) {
            this.updateScreenSize();
            this.mDialogManager = new DialogLinkManager((Context)this.mContext.get());
        }
        if (ScreenUtil.getInstance().getDensity() == 0.0f && this.mContext != null) {
            ScreenUtil.getInstance().init((Activity)this.mContext.get());
        }
        if (M_One.isNew()) {
            MLog.info((Object)TAG, (String)"\u65b0\u7248\u76f4\u64ad\u95f4", (Object[])new Object[0]);
        } else {
            MLog.info((Object)TAG, (String)"\u65e7\u7248\u76f4\u64ad\u95f4", (Object[])new Object[0]);
        }
    }

    private void updateScreenSize() {
        if (this.mContext != null && this.mContext.get() != null) {
            this.dm = new DisplayMetrics();
            ((FragmentActivity)this.mContext.get()).getWindowManager().getDefaultDisplay().getMetrics(this.dm);
            this.screenWith = this.dm.widthPixels;
            this.screenHight = this.dm.heightPixels;
        }
    }

    @Override
    public void addPkComponent(ViewGroup viewGroup) {
        this.pkRootView = viewGroup;
        if (this.mContext.get() != null) {
            this.updateUI();
        }
        this.presenter.updateState();
    }

    @Override
    public void updateUI() {
        if (this.pkRootView == null) {
            return;
        }
        this.mRatio = VideoUtils.getRatio();
        this.initComponent();
        this.initManager();
        this.onOrientationChanged();
    }

    private void initComponent() {
        if (this.pkComponentView == null && this.pkRootView != null) {
            this.pkRootView.removeAllViews();
            this.pkComponentView = this.generatePKComponentView();
        }
    }

    public View generatePKComponentView() {
        return this.inflater.inflate(R.layout.layout_pk_nor_pkcomponent, this.pkRootView, true);
    }

    private void initManager() {
        if (this.pkModuleManager == null) {
            this.pkModuleManager = this.generatePkModuleManager();
            this.pkModuleManager.attach((FragmentActivity)this.mContext.get());
            this.pkModuleManager.create(this.pkComponentView);
        }
        if (this.pkModelManager == null) {
            this.pkModelManager = new PKModelManager();
        }
    }

    public BasePKModuleManager generatePkModuleManager() {
        return new PkModuleManager();
    }

    @Override
    public void addModel(int model) {
        if (this.pkModuleManager != null) {
            this.pkModuleManager.addModel(model);
            this.onModelChange();
        }
    }

    @Override
    public void removeModel(int model) {
        if (this.pkModuleManager != null) {
            this.pkModuleManager.removeModel(model);
            this.onModelChange();
        }
    }

    @Override
    public void onPkStart() {
        if (this.pkModuleManager != null) {
            this.pkModuleManager.onPkStart();
            this.onModelChange();
        }
    }

    @Override
    public void onPkGoing() {
        if (this.pkModuleManager != null) {
            this.pkModuleManager.onPkGoing();
            this.onModelChange();
        }
    }

    @Override
    public void onPkEnd() {
        if (this.pkModuleManager != null) {
            this.pkModuleManager.onPkEnd();
            this.onModelChange();
        }
    }

    private void onOrientationChanged() {
        if (this.pkModuleManager != null) {
            this.pkModuleManager.onOrientationChanged(this.isLandScape());
        }
        this.onPkBarOrientationChanged();
    }

    private void onModelChange() {
        if (this.pkModelManager != null) {
            this.pkModelManager.onModelChange();
        }
    }

    public void onPkBarOrientationChanged() {
        MLog.info((Object)TAG, (String)"onPkBarOrientationChanged", (Object[])new Object[0]);
        this.pkBar = (RelativeLayout)this.pkComponentView.findViewById(R.id.pk_layout);
        RelativeLayout.LayoutParams pkBarParams = (RelativeLayout.LayoutParams)this.pkBar.getLayoutParams();
        this.changeLayoutParams(pkBarParams);
        this.pkBar.setLayoutParams((ViewGroup.LayoutParams)pkBarParams);
    }

    private void changeLayoutParams(RelativeLayout.LayoutParams params) {
        int topMargin;
        params.addRule(14);
        this.updateScreenSize();
        if (Spdt.currentFlavor() instanceof VIVO) {
            params.width = this.screenWith;
            if (M_One.isNew()) {
                if (M_One.isMvp()) {
                    if (!this.isMoveTab) {
                        this.isMoveTab = true;
                        YYStore.INSTANCE.dispatch((ReqAction)new MoveTabReqAction(PKConstants.SIZE.MVP_SEAT + PKConstants.SIZE.PKBAR));
                    }
                } else if (!this.isMoveTab) {
                    this.isMoveTab = true;
                    YYStore.INSTANCE.dispatch((ReqAction)new MoveTabReqAction(PKConstants.SIZE.PKBAR));
                }
                params.topMargin = (int)((float)this.screenWith / this.mRatio) - PKConstants.SIZE.PKBAR_HEADER;
            } else {
                int topMargin2;
                params.topMargin = topMargin2 = (int)((float)this.screenWith / this.mRatio) + PKConstants.SIZE.VIDEO_HEADER + ScreenUtil.getInstance().dip2px(16) - PKConstants.SIZE.PKBAR_HEADER - PKConstants.SIZE.PKBAR;
                if (((IPkCore)CoreFactory.getCore(IPkCore.class)).isShowChatInput()) {
                    params.topMargin = topMargin2 - PKConstants.INPUT.INPUT_OFFSET_Y;
                }
            }
            return;
        }
        if (!this.isLandScape()) {
            params.width = this.screenWith;
            if (M_One.isNew()) {
                if (M_One.isMvp()) {
                    if (!this.isMoveTab) {
                        this.isMoveTab = true;
                        YYStore.INSTANCE.dispatch((ReqAction)new MoveTabReqAction(PKConstants.SIZE.MVP_SEAT + PKConstants.SIZE.PKBAR));
                    }
                } else if (!this.isMoveTab) {
                    this.isMoveTab = true;
                    YYStore.INSTANCE.dispatch((ReqAction)new MoveTabReqAction(PKConstants.SIZE.PKBAR));
                }
                params.topMargin = (int)((float)this.screenWith / this.mRatio) - PKConstants.SIZE.PKBAR_HEADER;
            } else {
                params.topMargin = topMargin = (int)((float)this.screenWith / this.mRatio) + PKConstants.SIZE.VIDEO_HEADER + ScreenUtil.getInstance().dip2px(16) - PKConstants.SIZE.PKBAR_HEADER - PKConstants.SIZE.PKBAR;
                if (((IPkCore)CoreFactory.getCore(IPkCore.class)).isShowChatInput()) {
                    params.topMargin = topMargin - PKConstants.INPUT.INPUT_OFFSET_Y;
                }
            }
        }
        if (this.isLandScape()) {
            params.width = this.screenHight >= ScreenUtil.getInstance().dip2px(480) ? ScreenUtil.getInstance().dip2px(375) : ScreenUtil.getInstance().dip2px(320);
            if (M_One.isNew()) {
                params.topMargin = this.screenWith - PKConstants.SIZE.PKBAR_HEADER - PKConstants.SIZE.PKBAR - PKConstants.SIZE.MVP_SEAT;
            } else if (((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive()) {
                params.topMargin = this.screenWith - PKConstants.SIZE.VIDEO_FOOTER - PKConstants.SIZE.PKBAR_HEADER - PKConstants.SIZE.PKBAR;
                if (M_One.isMvp()) {
                    params.topMargin -= PKConstants.SIZE.MVP_SEAT;
                }
            } else {
                params.topMargin = topMargin = this.screenWith - PKConstants.SIZE.VIDEO_FOOTER - PKConstants.SIZE.PKBAR_HEADER - PKConstants.SIZE.PKBAR;
                if (M_One.isMvp()) {
                    params.topMargin = topMargin - PKConstants.SIZE.MVP_SEAT;
                }
            }
        }
    }

    @Override
    public boolean isHaveLoadCompnoent() {
        return this.pkComponentView != null;
    }

    @Override
    public void removePkBar() {
        if (this.pkRootView != null) {
            this.pkRootView.removeAllViews();
        }
        this.pkRootView = null;
        this.pkComponentView = null;
    }

    @Override
    public void showDialogOnStop(int leftCount, long forbidsec) {
        if (this.mDialogManager != null) {
            if (leftCount > 0) {
                this.mDialogManager.showOkCancelFollowDialog((CharSequence)("\u662f\u5426\u63d0\u524d\u7ed3\u675f\u6b22\u4e50\u6597\uff1f\u5173\u95ed\u540e\u9700" + forbidsec + "\u79d2\u540e\u624d\u80fd\u5f00\u542f\u54e6"), (CharSequence)("\u4f60\u4eca\u5929\u8fd8\u6709" + leftCount + "\u6b21\u63d0\u524d\u7ed3\u675f\u673a\u4f1a"), (CharSequence)"\u786e\u5b9a", (CharSequence)"\u53d6\u6d88", true, false, new DialogLinkManager.OkCancelDialogListener(){

                    public void onCancel() {
                        PkComponentViewProxy.this.mDialogManager.dismissDialog();
                    }

                    public void onOk() {
                        PkComponentViewProxy.this.mDialogManager.dismissDialog();
                        ((IChannelPKCore)CoreFactory.getCore(IChannelPKCore.class)).reqCrossPKstopPk(1);
                    }
                });
            } else {
                this.mDialogManager.showTitleAndMessageOkDialog((CharSequence)"\u4f60\u4eca\u5929\u7684\u63d0\u524d\u7ed3\u675f\u6b21\u6570\u5df2\u7ecf\u7528\u5b8c", (CharSequence)"", (CharSequence)"\u6211\u77e5\u9053\u4e86", false, false, new DialogLinkManager.OkDialogListener(){

                    public void onOk() {
                        PkComponentViewProxy.this.mDialogManager.dismissDialog();
                    }
                });
            }
        }
    }

    @Override
    public void clear() {
        this.onEventUnBind();
        if (this.isMoveTab) {
            this.isMoveTab = false;
            YYStore.INSTANCE.dispatch((ReqAction)new MoveTabReqAction(0));
        }
        this.pkModuleManager.destroy();
    }

    public boolean isLandScape() {
        IPkCore iPkCore = (IPkCore)CoreFactory.getCore(IPkCore.class);
        return iPkCore != null && iPkCore.isLandScapeMode();
    }

    @BusEvent
    public void onVideoCompnoentRateChange(VideoCompnoentRateChangeAction busEventArgs) {
        float rate = busEventArgs.getRate();
        if ((double)rate > 0.2 && this.mRatio != rate && !this.isLandScape()) {
            VideoUtils.setRatio(rate);
            this.updateUI();
        }
    }

    @BusEvent
    public void onVivoSplitScreen(VivoSplitScreen_EventArgs eventArgs) {
        if (!eventArgs.isSplit) {
            this.updateUI();
        }
    }

    @BusEvent
    public void onChatEmotionComponentDismiss(IChatEmotionClient_onChatEmotionComponentDismiss_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"onChatEmotionComponentDismiss", (Object[])new Object[0]);
        if (!M_One.isNew() && this.pkBar != null && !this.isLandScape()) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.pkBar.getLayoutParams();
            params.topMargin = (int)((float)this.screenWith / this.mRatio) + PKConstants.SIZE.VIDEO_HEADER + ScreenUtil.getInstance().dip2px(16) - PKConstants.SIZE.PKBAR_HEADER - PKConstants.SIZE.PKBAR;
            this.updateUI();
        }
    }

    @BusEvent
    public void onShowChatInputBroadcast(IChatEmotionClient_onShowChatInputBroadcast_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"onShowChatInputBroadcast", (Object[])new Object[0]);
        if (!M_One.isNew() && this.pkBar != null && !this.isLandScape()) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.pkBar.getLayoutParams();
            params.topMargin = ScreenUtil.getStatusBarHeight();
        }
    }

    public void onEventBind() {
        if (this.mPkComponentViewProxySniperEventBinder == null) {
            this.mPkComponentViewProxySniperEventBinder = new PkComponentViewProxy$$EventBinder();
        }
        this.mPkComponentViewProxySniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mPkComponentViewProxySniperEventBinder != null) {
            this.mPkComponentViewProxySniperEventBinder.unBindEvent();
        }
    }
}

