/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pluginstartlive.media.viewfocus;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.yy.mobile.pluginstartlive.BaseAnchorLiveViewModule;
import com.yy.mobile.pluginstartlive.R;
import com.yy.mobile.pluginstartlive.media.viewfocus.CameraClickView;
import com.yy.mobile.pluginstartlive.media.viewfocus.CameraTouchListener;
import com.yy.mobile.pluginstartlive.preview.VideoPreviewLayout;
import com.yy.mobile.pluginstartlive.startlivecore.IAnchorLiveViewModuleCore;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import mobile.yy.com.toucheventbus.TouchEventHandlerUtil;

public class FocusViewDelegate
implements CameraClickView {
    private static final String TAG = "FocusViewDelegate";
    private View mFocusView;
    private ViewGroup mRootView;
    private AnimatorSet mAnimatorSet;
    private VideoPreviewLayout mVideoPreviewLayout;
    private int mFocusViewWidth;
    private BaseAnchorLiveViewModule anchorLiveViewModule;

    public FocusViewDelegate(Activity context, ViewGroup rootView, VideoPreviewLayout previewLayout) {
        if (ICoreManagerBase.getCore(IAnchorLiveViewModuleCore.class) != null) {
            this.anchorLiveViewModule = ((IAnchorLiveViewModuleCore)ICoreManagerBase.getCore(IAnchorLiveViewModuleCore.class)).getAnchorLiveViewModule((Context)context);
        }
        ImageView focusView = new ImageView((Context)context);
        Drawable drawable2 = context.getResources().getDrawable(R.drawable.lr_video_click_focus);
        this.mFocusViewWidth = drawable2 != null ? drawable2.getIntrinsicWidth() : DimensUtils.dip2pixel((Context)context, (float)70.0f);
        focusView.setImageDrawable(drawable2);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        focusView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        rootView.addView((View)focusView);
        focusView.setVisibility(8);
        this.mRootView = rootView;
        this.mFocusView = focusView;
        this.mVideoPreviewLayout = previewLayout;
    }

    public void init() {
        this.mRootView.setOnTouchListener((View.OnTouchListener)new CameraTouchListener(this));
        this.mRootView.setClickable(true);
    }

    public void unInit() {
        this.mRootView.setOnTouchListener(null);
        this.mRootView.setClickable(false);
        if (this.mAnimatorSet != null && this.mAnimatorSet.isStarted()) {
            this.mAnimatorSet.cancel();
            this.mAnimatorSet.removeAllListeners();
        }
        this.mAnimatorSet = null;
        this.mFocusView = null;
        this.mRootView = null;
        this.mVideoPreviewLayout = null;
    }

    @Override
    public void showVideoClickFocus(float x, float y) {
        MLog.debug((Object)TAG, (String)"showVideoClickFocus: x:%f, y:%f", (Object[])new Object[]{Float.valueOf(x), Float.valueOf(y)});
        this.showFocus(x, y);
    }

    @Override
    public void onTouch(MotionEvent e) {
        if (this.mVideoPreviewLayout != null && !this.mVideoPreviewLayout.isReleased() && this.mVideoPreviewLayout.getCameraPreview().isCameraOpened()) {
            MLog.info((Object)TAG, (String)"onTouch: executed", (Object[])new Object[0]);
            TouchEventHandlerUtil.reviseToView((View)this.mVideoPreviewLayout, (MotionEvent)e);
            this.mVideoPreviewLayout.getCameraPreview().onTouch(e);
        }
    }

    private void showFocus(float x, float y) {
        if (this.anchorLiveViewModule != null) {
            this.anchorLiveViewModule.getPreviewCLicked().setValue(null);
        }
        if (this.mFocusView == null) {
            MLog.error((Object)TAG, (String)"showFocus warn: FocusView has release!", (Object[])new Object[0]);
            return;
        }
        if (this.mRootView == null) {
            MLog.error((Object)TAG, (String)"showFocus: mRootView has release!", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"showFocus start execute, x:%f, y:%f", (Object[])new Object[]{Float.valueOf(x), Float.valueOf(y)});
        int[] location = new int[2];
        this.mRootView.getLocationInWindow(location);
        if ((float)location[0] > x || y > (float)this.mRootView.getHeight()) {
            MLog.info((Object)TAG, (String)"no Click on View.", (Object[])new Object[0]);
            return;
        }
        if (this.mAnimatorSet == null) {
            this.mAnimatorSet = new AnimatorSet();
            this.mAnimatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.mFocusView, (String)"scaleX", (float[])new float[]{1.1f, 0.9f}).setDuration(300L), ObjectAnimator.ofFloat((Object)this.mFocusView, (String)"scaleY", (float[])new float[]{1.1f, 0.9f}).setDuration(300L)});
            this.mAnimatorSet.play((Animator)ObjectAnimator.ofFloat((Object)this.mFocusView, (String)"alpha", (float[])new float[]{1.0f, 1.0f}).setDuration(800L));
        }
        if (this.mFocusView.isShown()) {
            this.mFocusView.setVisibility(8);
        }
        if (this.mAnimatorSet.isStarted()) {
            this.mAnimatorSet.cancel();
        }
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mFocusView.getLayoutParams();
        this.mRootView.getX();
        layoutParams.leftMargin = (int)(x - (float)location[0]) - this.mFocusViewWidth / 2;
        layoutParams.rightMargin = this.mRootView.getWidth() - ((int)(x - (float)location[0]) + this.mFocusViewWidth / 2);
        layoutParams.topMargin = (int)y - this.mFocusView.getHeight();
        this.mFocusView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mAnimatorSet.removeAllListeners();
        this.mAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (FocusViewDelegate.this.mFocusView != null && FocusViewDelegate.this.mFocusView.isShown()) {
                    FocusViewDelegate.this.mFocusView.setVisibility(8);
                }
            }

            public void onAnimationStart(Animator animation) {
                if (FocusViewDelegate.this.mFocusView != null) {
                    FocusViewDelegate.this.mFocusView.setVisibility(0);
                }
            }
        });
        this.mAnimatorSet.start();
    }

    public void hideFocus() {
        if (this.mAnimatorSet != null && this.mAnimatorSet.isStarted()) {
            this.mAnimatorSet.cancel();
        }
    }
}

