/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pluginstartlive.media.publisher;

import android.support.annotation.NonNull;
import com.medialib.video.MediaVideoMsg;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mobile.RxBus;
import com.yy.mobile.pluginstartlive.lianmai.crosschannel.TransferInfoBuilder;
import com.yy.mobile.pluginstartlive.media.camera.ICameraPreview;
import com.yy.mobile.pluginstartlive.media.publisher.IVideoPublisher;
import com.yy.mobile.pluginstartlive.media.publisher.VideoPublishHolder;
import com.yy.mobile.pluginstartlive.media.publisher.listener.PublishEventListener;
import com.yy.mobile.pluginstartlive.media.publisher.listener.PublishResultListener;
import com.yy.mobile.pluginstartlive.media.publisher.listener.PublishStatusListener;
import com.yy.mobile.pluginstartlive.media.publisher.listener.PublishVideoParamsEventListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.BuzInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.PublishStatus;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.TransferInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoOrientation;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoQuality;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.CollectionLooper;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.AudienceManagerInternal;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoquality.StreamLineManagerInternal;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.common.RoleManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.common.YLKLiveHolder;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoLinkInfoEventArgs;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.YLKLive;
import com.yy.yylivekit.anchor.Publisher;
import com.yy.yylivekit.anchor.QosEventHandler;
import com.yy.yylivekit.anchor.VideoParams;
import com.yy.yylivekit.model.PublisherEventHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VideoPublisher
implements IVideoPublisher,
PublisherEventHandler,
QosEventHandler {
    private static final String TAG = "VideoPublisher";
    private ICameraPreview mCameraPreview;
    private Set<PublishVideoParamsEventListener> mParamsEventListenerSet;
    private Set<PublishStatusListener> mPublishStatusListenerSet;
    private Set<PublishResultListener> mPublishResultListenerSet;
    private Set<PublishEventListener> mPublishEventListenerSet;
    private CollectionLooper<PublishVideoParamsEventListener> mPublishVideoParamsListenerLooper;
    private CollectionLooper<PublishResultListener> mPublishResultListenerLooper;
    private CollectionLooper<PublishEventListener> mPublishEventListenerLooper;
    private boolean mIsPublished;
    private int mMicNo;
    private PublishStatus mPublishStatus;
    private VideoQuality mCurrentVideoQuality;
    private Boolean mIsCurrentPortrait;
    private VideoParams mCurrentVideoParams;
    private BuzInfo mBuzInfo;
    private TransferInfo mTransferInfo;

    public VideoPublisher(ICameraPreview videoPreview) {
        this.mCameraPreview = videoPreview;
        this.mIsPublished = false;
        this.mMicNo = 0;
        this.mBuzInfo = new BuzInfo(0);
        this.mPublishVideoParamsListenerLooper = new CollectionLooper();
        this.mPublishResultListenerLooper = new CollectionLooper();
        this.mPublishEventListenerLooper = new CollectionLooper();
        this.mParamsEventListenerSet = new HashSet<PublishVideoParamsEventListener>();
        this.mPublishStatusListenerSet = new HashSet<PublishStatusListener>();
        this.mPublishResultListenerSet = new HashSet<PublishResultListener>();
        this.mPublishEventListenerSet = new HashSet<PublishEventListener>();
        VideoPublishHolder.INSTANCE.set(this);
        this.updatePublishStatusChange(PublishStatus.IDLE);
    }

    @Override
    public void release() {
        MLog.info((Object)TAG, (String)"release", (Object[])new Object[0]);
        this.stopPublish();
        this.getPublisher().setEventHandler(null);
        this.getPublisher().setQosEventHandler(null);
        this.mCameraPreview = null;
        this.updatePublishStatusChange(PublishStatus.IDLE);
        this.mParamsEventListenerSet.clear();
        this.mPublishStatusListenerSet.clear();
        this.mPublishResultListenerSet.clear();
        this.mPublishEventListenerSet.clear();
        this.mIsPublished = false;
        this.mMicNo = 0;
        this.mBuzInfo.reset();
        this.clearCurrentVideoParams();
        VideoPublishHolder.INSTANCE.set(null);
    }

    @Override
    public boolean startPublish() {
        if (this.mIsPublished) {
            MLog.info((Object)TAG, (String)"startPublish: already published", (Object[])new Object[0]);
            return false;
        }
        if (!this.isCameraOpened()) {
            MLog.info((Object)TAG, (String)"startPublish: camera has not opened", (Object[])new Object[0]);
        }
        if (YLKLive.State.Joined.equals((Object)YLKLiveHolder.getYLKLive().getState())) {
            MLog.info((Object)TAG, (String)"startPublish: has joined and publish directly", (Object[])new Object[0]);
            RoleManager.getInstance().setAnchorRole();
            this.registerSelfTransferInfo();
            this.getPublisher().setEventHandler((PublisherEventHandler)this);
            this.getPublisher().setQosEventHandler((QosEventHandler)this);
            this.getPublisher().setBuzInfo(this.mBuzInfo.generateBuzInfoMap());
            this.getPublisher().startPublish();
            this.mIsPublished = true;
            this.updatePublishStatusChange(PublishStatus.START_PUBLISH);
            return true;
        }
        MLog.info((Object)TAG, (String)"startPublish: has not join so do nothing", (Object[])new Object[0]);
        return false;
    }

    @Override
    public void addPublishEventListener(PublishEventListener listener) {
        if (listener != null) {
            this.mPublishEventListenerSet.add(listener);
        } else {
            MLog.error((Object)TAG, (String)"addPublishEventListener: null listener do not add", (Object[])new Object[0]);
        }
    }

    @Override
    public void removePublishEventListener(PublishEventListener listener) {
        if (listener != null) {
            this.mPublishEventListenerSet.remove(listener);
        } else {
            MLog.error((Object)TAG, (String)"removePublishEventListener: null listener do not remove", (Object[])new Object[0]);
        }
    }

    @Override
    public void addPublishVideoParamsEventListener(PublishVideoParamsEventListener listener) {
        if (listener != null) {
            this.mParamsEventListenerSet.add(listener);
        } else {
            MLog.error((Object)TAG, (String)"addPublishVideoParamsEventListener: null listener do not add", (Object[])new Object[0]);
        }
    }

    @Override
    public void removePublishVideoParamsEventListener(PublishVideoParamsEventListener listener) {
        if (listener != null) {
            this.mParamsEventListenerSet.remove(listener);
        } else {
            MLog.error((Object)TAG, (String)"removePublishVideoParamsEventListener: null listener do not remove", (Object[])new Object[0]);
        }
    }

    @Override
    public void addPublishStatusListener(PublishStatusListener listener) {
        if (listener != null) {
            this.mPublishStatusListenerSet.add(listener);
        } else {
            MLog.error((Object)TAG, (String)"addPublishStatusListener: null listener do not add", (Object[])new Object[0]);
        }
    }

    @Override
    public void removePublishStatusListener(PublishStatusListener listener) {
        if (listener != null) {
            this.mPublishStatusListenerSet.remove(listener);
        } else {
            MLog.error((Object)TAG, (String)"removePublishStatusListener: null listener do not remove", (Object[])new Object[0]);
        }
    }

    @Override
    public void addPublishResultListener(PublishResultListener listener) {
        if (listener != null) {
            this.mPublishResultListenerSet.add(listener);
        } else {
            MLog.error((Object)TAG, (String)"addPublishResultListener: null listener do not add", (Object[])new Object[0]);
        }
    }

    @Override
    public void removePublishResultListener(PublishResultListener listener) {
        if (listener != null) {
            this.mPublishResultListenerSet.remove(listener);
        } else {
            MLog.error((Object)TAG, (String)"removePublishResultListener: null listener do not remove", (Object[])new Object[0]);
        }
    }

    @Override
    public void stopPublish() {
        if (!this.mIsPublished) {
            MLog.info((Object)TAG, (String)"stopPublish: has not publish success no need to stop publish", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"stopPublish: ", (Object[])new Object[0]);
        this.mIsPublished = false;
        this.clearCurrentVideoParams();
        this.unRegisterSelfTransferInfo();
        this.getPublisher().setEventHandler(null);
        this.getPublisher().setQosEventHandler(null);
        this.getPublisher().stopPublish();
        AudienceManagerInternal.getInstance().cancelFastAccess();
        StreamLineManagerInternal.getInstance().onStopPublish();
        this.updatePublishStatusChange(PublishStatus.STOP_PUBLISH);
        this.mBuzInfo.reset();
    }

    @Override
    public void setBuzInfo(BuzInfo buzInfo) {
        MLog.info((Object)TAG, (String)"setBuzInfo: buzInfo:%s", (Object[])new Object[]{buzInfo});
        if (buzInfo != null) {
            this.mBuzInfo = buzInfo;
        } else {
            this.mBuzInfo.reset();
        }
        this.getPublisher().setBuzInfo(this.mBuzInfo.generateBuzInfoMap());
    }

    @Override
    public void setMicNo(int micNo) {
        MLog.info((Object)TAG, (String)"setMicNo: micNo:%d", (Object[])new Object[]{micNo});
        this.mMicNo = micNo;
    }

    @Override
    public PublishStatus getPublishStatus() {
        return this.mPublishStatus;
    }

    @Override
    public void enableAudio(boolean enable) {
        MLog.info((Object)TAG, (String)"enableAudio: enable:%b", (Object[])new Object[]{enable});
        this.getPublisher().enableAudio(enable);
    }

    @Override
    public void enableVideo(boolean enable) {
        MLog.info((Object)TAG, (String)"enableVideo: enable:%b", (Object[])new Object[]{enable});
        this.getPublisher().enableVideo(enable);
    }

    @Override
    public boolean isAudioEnable() {
        return this.getPublisher().isAudioEnable();
    }

    @Override
    public boolean isVideoEnable() {
        return this.getPublisher().isVideoEnable();
    }

    @Override
    public void enableDynamicCodeRate(boolean enable) {
        MLog.info((Object)TAG, (String)"enableDynamicCodeRate: enable:%b", (Object[])new Object[]{enable});
        this.getPublisher().enableDynamicCodeRate(enable);
    }

    @Override
    public void startPublishToOtherChannel(TransferInfo transferInfo) {
        if (transferInfo == null) {
            MLog.error((Object)TAG, (String)"startPublishToOtherChannel: null transferInfo", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"startPublishToOtherChannel: transferInfo:%s", (Object[])new Object[]{transferInfo});
        this.getPublisher().registerTransferInfo(transferInfo.getTransferInfo());
    }

    @Override
    public void stopPublishToOtherChannel(TransferInfo transferInfo) {
        if (transferInfo == null) {
            MLog.error((Object)TAG, (String)"stopPublishToOtherChannel: null transferInfo", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"stopPublishToOtherChannel: transferInfo:%s", (Object[])new Object[]{transferInfo});
        this.getPublisher().unRegisterTransferInfo(transferInfo.getTransferInfo());
    }

    @Override
    public void switchQuality(VideoQuality quality) {
        MLog.info((Object)TAG, (String)"switchQuality: quality:%s", (Object[])new Object[]{quality});
        this.switchQuality(quality, false);
    }

    @Override
    public void switchQuality(VideoQuality quality, boolean force) {
        MLog.info((Object)TAG, (String)"switchQuality: force:%b, quality:%s, mCurrentVideoQuality:%s, mIsCurrentPortrait:%s", (Object[])new Object[]{force, quality, this.mCurrentVideoQuality, this.mIsCurrentPortrait});
        if (force || this.hasVideoOrientationChanged() || quality != null && !quality.equals((Object)this.mCurrentVideoQuality)) {
            this.mCurrentVideoQuality = quality;
            this.mIsCurrentPortrait = this.isCameraPreviewPortrait();
            this.mCurrentVideoParams = null;
            this.getPublisher().switchQuality(quality.getVideoQuality());
        }
    }

    @Override
    public void switchQuality(final VideoParams videoParams) {
        if (videoParams != null && !videoParams.equals(this.mCurrentVideoParams)) {
            MLog.info((Object)TAG, (String)"switchQuality: videoParams:%s, mCurrentVideoParams:%s, mIsCurrentPortrait:%s", (Object[])new Object[]{videoParams, this.mCurrentVideoParams, this.mIsCurrentPortrait});
            this.mCurrentVideoParams = videoParams;
            this.mCurrentVideoQuality = null;
            this.mIsCurrentPortrait = null;
            this.getPublisher().switchQuality(videoParams);
            this.mPublishVideoParamsListenerLooper.loop(this.getParamsEventListenerList(), (CollectionLooper.Callback)new CollectionLooper.Callback<PublishVideoParamsEventListener>(){

                public void onCallback(@NonNull PublishVideoParamsEventListener publishVideoParamsEventListener) {
                    publishVideoParamsEventListener.onSwitchQuality(videoParams);
                }
            });
        }
    }

    private boolean isCameraOpened() {
        return this.mCameraPreview != null && this.mCameraPreview.isCameraOpened();
    }

    private Publisher getPublisher() {
        return Publisher.getInstance();
    }

    public void onPublishSuccess() {
        MLog.info((Object)TAG, (String)"onPublishSuccess", (Object[])new Object[0]);
        this.updatePublishStatusChange(PublishStatus.PUBLISH_SUCCESS);
        List<PublishResultListener> resultListenerList = this.getPublishResultList();
        this.mPublishResultListenerLooper.loop(resultListenerList, (CollectionLooper.Callback)new CollectionLooper.Callback<PublishResultListener>(){

            public void onCallback(@NonNull PublishResultListener publishResultListener) {
                publishResultListener.onPublishSuccess();
            }
        });
    }

    public void onPublishFailed(final int streamType, final int code, final String message) {
        MLog.error((Object)TAG, (String)"onPublishFailed: streamType:%d, code:%d, message:%s", (Object[])new Object[]{streamType, code, message});
        this.updatePublishStatusChange(PublishStatus.PUBLISH_FAILED);
        List<PublishResultListener> resultListenerList = this.getPublishResultList();
        this.mPublishResultListenerLooper.loop(resultListenerList, (CollectionLooper.Callback)new CollectionLooper.Callback<PublishResultListener>(){

            public void onCallback(@NonNull PublishResultListener publishResultListener) {
                publishResultListener.onPublishFail(streamType, code, message);
            }
        });
    }

    public void onVideoEncodeType(final VideoEncoderType encodeType) {
        List<PublishVideoParamsEventListener> eventListenerList = this.getParamsEventListenerList();
        MLog.info((Object)TAG, (String)"onVideoEncodeType: encodeType:%s, eventListenerList:%s", (Object[])new Object[]{encodeType, eventListenerList});
        this.mPublishVideoParamsListenerLooper.loop(eventListenerList, (CollectionLooper.Callback)new CollectionLooper.Callback<PublishVideoParamsEventListener>(){

            public void onCallback(@NonNull PublishVideoParamsEventListener publishVideoParamsEventListener) {
                publishVideoParamsEventListener.onVideoEncodeType(encodeType);
            }
        });
    }

    public void onVideoEncodeResolution(final int width, final int height) {
        List<PublishVideoParamsEventListener> eventListenerList = this.getParamsEventListenerList();
        MLog.info((Object)TAG, (String)"onVideoEncodeResolution: width:%d, height:%d, eventListenerList:%s", (Object[])new Object[]{width, height, eventListenerList});
        this.mPublishVideoParamsListenerLooper.loop(eventListenerList, (CollectionLooper.Callback)new CollectionLooper.Callback<PublishVideoParamsEventListener>(){

            public void onCallback(@NonNull PublishVideoParamsEventListener publishVideoParamsEventListener) {
                publishVideoParamsEventListener.onVideoEncodeResolution(width, height);
            }
        });
    }

    public void onVideoEncodeFirstFrame() {
        List<PublishVideoParamsEventListener> eventListenerList = this.getParamsEventListenerList();
        MLog.info((Object)TAG, (String)"onVideoEncodeFirstFrame: eventListenerList:%s", (Object[])new Object[]{eventListenerList});
        this.mPublishVideoParamsListenerLooper.loop(eventListenerList, (CollectionLooper.Callback)new CollectionLooper.Callback<PublishVideoParamsEventListener>(){

            public void onCallback(@NonNull PublishVideoParamsEventListener publishVideoParamsEventListener) {
                publishVideoParamsEventListener.onVideoEncodeFirstFrame();
            }
        });
    }

    public void onEncodeEncParam(final String param) {
        List<PublishVideoParamsEventListener> eventListenerList = this.getParamsEventListenerList();
        MLog.info((Object)TAG, (String)"onEncodeEncParam: param:%s", (Object[])new Object[]{param});
        this.mPublishVideoParamsListenerLooper.loop(eventListenerList, (CollectionLooper.Callback)new CollectionLooper.Callback<PublishVideoParamsEventListener>(){

            public void onCallback(@NonNull PublishVideoParamsEventListener publishVideoParamsEventListener) {
                publishVideoParamsEventListener.onEncodeEncParam(param);
            }
        });
    }

    public void onVideoEncodeData(byte[] data, int len, long pts, long dts, int frameType, VideoEncoderType encodeType) {
        for (PublishVideoParamsEventListener handler : this.mParamsEventListenerSet) {
            handler.onVideoEncodeData(data, len, pts, dts, frameType, encodeType);
        }
    }

    public void onVideoUploadInfoEvent(int packetLossRate, int rtt) {
        MLog.debug((Object)TAG, (String)"onVideoUploadInfoEvent: packetLossRate:%d, rtt:%d", (Object[])new Object[]{packetLossRate, rtt});
        for (PublishVideoParamsEventListener handler : this.mParamsEventListenerSet) {
            handler.onVideoUploadInfoEvent(packetLossRate, rtt);
        }
    }

    public void onVideoUploadRateEvent(int bitrate, int frameRate) {
        MLog.debug((Object)TAG, (String)"onVideoUploadRateEvent: bitrate:%d, frameRate:%d", (Object[])new Object[]{bitrate, frameRate});
        for (PublishVideoParamsEventListener handler : this.mParamsEventListenerSet) {
            handler.onVideoUploadRateEvent(bitrate, frameRate);
        }
    }

    public void onSuggestDynamicBitrateEvent(int bitrate) {
        MLog.debug((Object)TAG, (String)"onSuggestDynamicBitrateEvent: bitrate:%d", (Object[])new Object[]{bitrate});
        for (PublishVideoParamsEventListener handler : this.mParamsEventListenerSet) {
            handler.onSuggestDynamicBitrateEvent(bitrate);
        }
    }

    public void onLowDelayEncodeModeInfoEvent(boolean isLowDelayMode) {
    }

    public void onAudioCaptureErrorEvent(final long uid, final int errorType) {
        MLog.info((Object)TAG, (String)"onAudioCaptureErrorEvent: uid:%d, errorType:%d", (Object[])new Object[]{uid, errorType});
        if (FP.empty(this.mPublishEventListenerSet)) {
            return;
        }
        ArrayList<PublishEventListener> list = new ArrayList<PublishEventListener>(this.mPublishEventListenerSet);
        this.mPublishEventListenerLooper.loop(list, (CollectionLooper.Callback)new CollectionLooper.Callback<PublishEventListener>(){

            public void onCallback(@NonNull PublishEventListener listener) {
                listener.onAudioCaptureErrorEvent(uid, errorType);
            }
        });
    }

    public void onVideoPublisherLossNotifyInfo(final MediaVideoMsg.VideoPulisherLossNotifyInfo info) {
        if (FP.empty(this.mPublishEventListenerSet)) {
            return;
        }
        ArrayList<PublishEventListener> list = new ArrayList<PublishEventListener>(this.mPublishEventListenerSet);
        this.mPublishEventListenerLooper.loop(list, (CollectionLooper.Callback)new CollectionLooper.Callback<PublishEventListener>(){

            public void onCallback(@NonNull PublishEventListener listener) {
                listener.onVideoPublisherLossNotifyInfo(info);
            }
        });
    }

    public void onVideoLinkInfoNotify(MediaVideoMsg.VideoLinkInfo videoLinkInfo) {
        MLog.info((Object)TAG, (String)("onVideoLinkInfoNotity called with: videoLinkInfo = [" + videoLinkInfo + "]"), (Object[])new Object[0]);
        if (videoLinkInfo != null) {
            RxBus.getDefault().post((Object)new VideoLinkInfoEventArgs(videoLinkInfo.appId, videoLinkInfo.state, videoLinkInfo.ip, videoLinkInfo.port, videoLinkInfo.channelId));
        }
    }

    public void onVideoPublisherStatInfo(final MediaVideoMsg.VideoPublisherStatInfo info) {
        MLog.info((Object)TAG, (String)"onVideoPublisherStatInfo", (Object[])new Object[0]);
        if (FP.empty(this.mPublishEventListenerSet)) {
            return;
        }
        ArrayList<PublishEventListener> list = new ArrayList<PublishEventListener>(this.mPublishEventListenerSet);
        this.mPublishEventListenerLooper.loop(list, (CollectionLooper.Callback)new CollectionLooper.Callback<PublishEventListener>(){

            public void onCallback(@NonNull PublishEventListener listener) {
                listener.onVideoPublisherStatInfo(info);
            }
        });
    }

    public void onNotifyForwardStatusInfoEvent(final MediaVideoMsg.NotifyForwardStatusInfo info) {
        MLog.info((Object)TAG, (String)"onNotifyForwardStatusInfoEvent", (Object[])new Object[0]);
        if (FP.empty(this.mPublishEventListenerSet)) {
            return;
        }
        ArrayList<PublishEventListener> list = new ArrayList<PublishEventListener>(this.mPublishEventListenerSet);
        this.mPublishEventListenerLooper.loop(list, (CollectionLooper.Callback)new CollectionLooper.Callback<PublishEventListener>(){

            public void onCallback(@NonNull PublishEventListener listener) {
                listener.onTransForwardStatusInfoEvent(info);
            }
        });
    }

    private List<PublishResultListener> getPublishResultList() {
        if (FP.empty(this.mPublishResultListenerSet)) {
            return null;
        }
        return new ArrayList<PublishResultListener>(this.mPublishResultListenerSet);
    }

    private List<PublishVideoParamsEventListener> getParamsEventListenerList() {
        if (FP.empty(this.mParamsEventListenerSet)) {
            return null;
        }
        return new ArrayList<PublishVideoParamsEventListener>(this.mParamsEventListenerSet);
    }

    private void updatePublishStatusChange(PublishStatus status) {
        if (this.mPublishStatus == status) {
            MLog.info((Object)TAG, (String)"updatePublishStatusChange: status not changed do not notify", (Object[])new Object[0]);
            return;
        }
        this.mPublishStatus = status;
        if (FP.empty(this.mPublishStatusListenerSet)) {
            MLog.info((Object)TAG, (String)"updatePublishStatusChange: no listener do not notify", (Object[])new Object[0]);
            return;
        }
        ArrayList<PublishStatusListener> publishStatusListenersCopy = new ArrayList<PublishStatusListener>(this.mPublishStatusListenerSet);
        for (PublishStatusListener listener : publishStatusListenersCopy) {
            listener.onPublishStatusChange(status);
        }
    }

    private void clearCurrentVideoParams() {
        this.mCurrentVideoParams = null;
        this.mCurrentVideoQuality = null;
        this.mIsCurrentPortrait = null;
    }

    private boolean hasVideoOrientationChanged() {
        boolean isPortrait = this.isCameraPreviewPortrait();
        boolean hasChanged = this.mIsCurrentPortrait == null || isPortrait != this.mIsCurrentPortrait;
        MLog.info((Object)TAG, (String)"hasVideoOrientationChanged: hasChanged:%b, isPortrait:%b, mIsCurrentPortrait:%s", (Object[])new Object[]{hasChanged, isPortrait, this.mIsCurrentPortrait});
        return hasChanged;
    }

    private boolean isCameraPreviewPortrait() {
        return this.mCameraPreview != null && this.mCameraPreview.getVideoOrientation() == VideoOrientation.Portrait;
    }

    private void registerSelfTransferInfo() {
        if (this.mTransferInfo != null) {
            MLog.error((Object)TAG, (String)"registerSelfTransferInfo: duplicate register", (Object[])new Object[0]);
            return;
        }
        boolean isVideoEnable = this.isVideoEnable();
        boolean isAudioEnable = this.isAudioEnable();
        TransferInfo.FilterType filterType = TransferInfo.FilterType.Nil;
        if (!isVideoEnable) {
            filterType = TransferInfo.FilterType.Video;
        } else if (!isAudioEnable) {
            filterType = TransferInfo.FilterType.Audio;
        }
        this.mTransferInfo = new TransferInfoBuilder().build(this.mMicNo, filterType);
        MLog.info((Object)TAG, (String)"registerSelfTransferInfo: isVideoEnable:%b, isAudioEnable:%b, mTransferInfo:%s", (Object[])new Object[]{isVideoEnable, isAudioEnable, this.mTransferInfo});
        if (this.mTransferInfo != null) {
            this.getPublisher().registerTransferInfo(this.mTransferInfo.getTransferInfo());
        }
    }

    private void unRegisterSelfTransferInfo() {
        if (this.mTransferInfo == null) {
            MLog.error((Object)TAG, (String)"unRegisterSelfTransferInfo: duplicate unregister", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"unRegisterSelfTransferInfo: mTransferInfo:%s", (Object[])new Object[]{this.mTransferInfo});
        this.getPublisher().unRegisterTransferInfo(this.mTransferInfo.getTransferInfo());
        this.mMicNo = 0;
        this.mTransferInfo = null;
    }
}

