/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pluginstartlive.media.camera;

import android.hardware.Camera;
import android.support.annotation.MainThread;
import android.view.MotionEvent;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.CameraUtils;
import com.yy.mediaframework.PictureInPictureDisplayInfo;
import com.yy.mobile.pluginstartlive.media.camera.CameraTask;
import com.yy.mobile.pluginstartlive.media.camera.IYYCamera;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.anchor.Publisher;
import com.yy.yylivekit.anchor.YLKCamera;
import com.yy.yylivekit.model.PreviewParams;

public class YYCamera {
    private static final String TAG = "YYCamera";
    private static YYCamera mInstance;
    private static final byte[] SYNC;
    private YLKCamera mYLKCameraDelegate = Publisher.getInstance().getCamera();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YYCamera getInstance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC;
        synchronized (SYNC) {
            if (mInstance != null) return mInstance;
            mInstance = new YYCamera();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private YYCamera() {
    }

    @MainThread
    public void changePreviewParameter(int width, int height, int fps, CameraFacing currentFacing, CameraResolutionMode resMode) {
        final PreviewParams previewParams = new PreviewParams(width, height, fps, YYCamera.convertCameraFacing(currentFacing), true, YYCamera.convertResolutionMode(resMode));
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                YYCamera.this.mYLKCameraDelegate.changePreviewpParams(previewParams);
            }
        });
    }

    @MainThread
    public void switchCamera() {
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)YYCamera.TAG, (String)"#switchCamera", (Object[])new Object[0]);
                YYCamera.this.mYLKCameraDelegate.switchCamera();
            }
        });
    }

    @MainThread
    public boolean isCameraOpen() {
        return this.mYLKCameraDelegate.isOpen();
    }

    @MainThread
    public void isCameraOpen(final IYYCamera mIYYCamera) {
        if (mIYYCamera == null) {
            return;
        }
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                boolean isOpen = YYCamera.this.mYLKCameraDelegate.isOpen();
                mIYYCamera.cameraCallback(isOpen);
            }
        });
    }

    @MainThread
    public Camera.Size getPreviewSize() {
        return this.mYLKCameraDelegate.getPreviewSize();
    }

    @MainThread
    public void getPreviewSize(final IYYCamera mIYYCamera) {
        if (mIYYCamera == null) {
            return;
        }
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                Camera.Size mSize = YYCamera.this.mYLKCameraDelegate.getPreviewSize();
                mIYYCamera.cameraCallback(mSize);
            }
        });
    }

    @MainThread
    public void setCameraFlashMode(final boolean enable) {
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                YYCamera.this.mYLKCameraDelegate.setCameraFlashMode(enable);
            }
        });
    }

    @MainThread
    public void handleFocusMetering(final MotionEvent event) {
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                YYCamera.this.mYLKCameraDelegate.handleFocusMetering(event);
            }
        });
    }

    @MainThread
    public boolean isCameraFront() {
        return this.mYLKCameraDelegate.isCameraFront();
    }

    @MainThread
    public void isCameraFront(final IYYCamera mIYYCamera) {
        if (mIYYCamera == null) {
            return;
        }
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                boolean isFront = YYCamera.this.mYLKCameraDelegate.isCameraFront();
                mIYYCamera.cameraCallback(isFront);
            }
        });
    }

    @MainThread
    public int getMaxZoom() {
        return this.mYLKCameraDelegate.getMaxZoom();
    }

    @MainThread
    public void getMaxZoom(final IYYCamera mIYYCamera) {
        if (mIYYCamera == null) {
            return;
        }
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                int maxZoom = YYCamera.this.mYLKCameraDelegate.getMaxZoom();
                mIYYCamera.cameraCallback(maxZoom);
            }
        });
    }

    @MainThread
    public boolean isZoomSupport() {
        return this.mYLKCameraDelegate.isZoomSupport();
    }

    @MainThread
    public void isZoomSupport(final IYYCamera mIYYCamera) {
        if (mIYYCamera == null) {
            return;
        }
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                boolean isZoomSupport = YYCamera.this.mYLKCameraDelegate.isZoomSupport();
                mIYYCamera.cameraCallback(isZoomSupport);
            }
        });
    }

    @MainThread
    public float setZoom(int zoom) {
        return this.mYLKCameraDelegate.setZoom(zoom);
    }

    @MainThread
    public void setZoom(final int zoom, final IYYCamera mIYYCamera) {
        if (mIYYCamera == null) {
            return;
        }
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                float setZoom = YYCamera.this.mYLKCameraDelegate.setZoom(zoom);
                mIYYCamera.cameraCallback(Float.valueOf(setZoom));
            }
        });
    }

    @MainThread
    public void releaseCamera() {
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                YYCamera.this.mYLKCameraDelegate.releaseCamera();
            }
        });
    }

    @MainThread
    public int startDualCameraLive(final int width, final int height, final int fps, final PictureInPictureDisplayInfo info) {
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                YYCamera.this.mYLKCameraDelegate.startDualCameraLive(width, height, fps, info);
            }
        });
        return 0;
    }

    @MainThread
    public void closeDualCamera() {
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                YYCamera.this.mYLKCameraDelegate.closeDualCamera();
            }
        });
    }

    @MainThread
    public CameraFacing getCameraFacing() {
        return YYCamera.fetchCameraFacing(this.mYLKCameraDelegate.getCameraFacing());
    }

    @MainThread
    public void getCameraFacing(final IYYCamera mIYYCamera) {
        if (mIYYCamera == null) {
            return;
        }
        CameraTask.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                CameraFacing getCameraFacing = YYCamera.fetchCameraFacing(YYCamera.this.mYLKCameraDelegate.getCameraFacing());
                mIYYCamera.cameraCallback(getCameraFacing);
            }
        });
    }

    public static CameraInterface.CameraResolutionMode convertResolutionMode(CameraResolutionMode mode) {
        if (mode == null) {
            MLog.error((Object)TAG, (String)"convertResolutionMode: null mode", (Object[])new Object[0]);
            return CameraInterface.CameraResolutionMode.CAMERA_RESOLUTION_RANGE_MODE;
        }
        switch (mode) {
            case CAMERA_RESOLUTION_RANGE_MODE: {
                return CameraInterface.CameraResolutionMode.CAMERA_RESOLUTION_RANGE_MODE;
            }
        }
        return CameraInterface.CameraResolutionMode.CAMERA_RESOLUTION_PRECISE_MODE;
    }

    public static CameraUtils.CameraFacing convertCameraFacing(CameraFacing mode) {
        if (mode == null) {
            MLog.error((Object)TAG, (String)"convertCameraFacing: null mode", (Object[])new Object[0]);
            return CameraUtils.CameraFacing.FacingFront;
        }
        switch (mode) {
            case Back: {
                return CameraUtils.CameraFacing.FacingBack;
            }
        }
        return CameraUtils.CameraFacing.FacingFront;
    }

    public static CameraFacing fetchCameraFacing(CameraUtils.CameraFacing mode) {
        if (mode == null) {
            MLog.error((Object)TAG, (String)"fetchCameraFacing: null mode", (Object[])new Object[0]);
            return CameraFacing.Front;
        }
        switch (mode) {
            case FacingBack: {
                return CameraFacing.Back;
            }
        }
        return CameraFacing.Front;
    }

    static {
        SYNC = new byte[1];
    }

    public static class PreviewSize
    extends CameraUtils.PreviewSize {
        private final int width;
        private final int height;

        public PreviewSize(int width, int height) {
            super(width, height);
            this.width = width;
            this.height = height;
        }

        protected static PreviewSize newInstance(CameraUtils.PreviewSize previewSize) {
            return new PreviewSize(previewSize.width, previewSize.height);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public String toString() {
            return "" + this.width + "x" + this.height;
        }
    }

    public static enum CameraFacing {
        Front,
        Back;

    }

    public static enum CameraResolutionMode {
        CAMERA_RESOLUTION_PRECISE_MODE,
        CAMERA_RESOLUTION_RANGE_MODE;

    }
}

