/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pluginstartlive.media.camera;

import android.graphics.Bitmap;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.yy.mediaframework.CameraUtils;
import com.yy.mediaframework.Constant;
import com.yy.mobile.pluginstartlive.media.camera.CameraPreviewInstance;
import com.yy.mobile.pluginstartlive.media.camera.ICameraPreview;
import com.yy.mobile.pluginstartlive.media.camera.IMobileFaceDetection;
import com.yy.mobile.pluginstartlive.media.camera.PreviewParams;
import com.yy.mobile.pluginstartlive.media.camera.ScreenShotCallback;
import com.yy.mobile.pluginstartlive.media.camera.YYCamera;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoOrientation;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.anchor.Publisher;
import com.yy.yylivekit.anchor.YLKCamera;
import com.yymobile.core.ICoreManagerBase;

public class CameraPreview
implements ICameraPreview {
    private static final String TAG = "CameraPreview";
    private boolean mPreviewStarted;
    private static int mPreviewStartCountGlobal;
    private YLKCamera mCamera = Publisher.getInstance().getCamera();
    private ViewGroup mPreviewParent;
    private PreviewParams mCurPreviewParams;
    private VideoOrientation mCurOrientation;

    private void ensureCameraViewHasNoParent() {
        ViewParent parent = this.mCamera.videoView().getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView((View)this.mCamera.videoView());
        }
    }

    public CameraPreview(ViewGroup previewParent) {
        MLog.info((Object)TAG, (String)"CameraPreview: construct", (Object[])new Object[0]);
        if (previewParent != null) {
            this.ensureCameraViewHasNoParent();
            previewParent.addView((View)this.mCamera.videoView(), -1, -1);
            this.mPreviewParent = previewParent;
            IMobileFaceDetection iMobileFaceDetection = (IMobileFaceDetection)ICoreManagerBase.getCore(IMobileFaceDetection.class);
            if (iMobileFaceDetection != null) {
                iMobileFaceDetection.setMobileFaceDetection(previewParent.getContext(), this.mCamera);
            }
        }
        CameraPreviewInstance.INSTANCE.setCurCamera(this);
    }

    public void release() {
        MLog.info((Object)TAG, (String)"CameraPreview: release", (Object[])new Object[0]);
        this.stopPreview();
        this.mCamera.reset();
        if (this.mPreviewParent != null) {
            this.mPreviewParent.removeAllViews();
        }
        CameraPreviewInstance.INSTANCE.releaseCamera();
    }

    @Override
    public void startPreview(boolean portrait, boolean front) {
        MLog.info((Object)TAG, (String)"startPreview with default params: mPreviewStarted:%b, mPreviewStartCountGlobal:%d", (Object[])new Object[]{this.mPreviewStarted, mPreviewStartCountGlobal});
        if (!this.mPreviewStarted) {
            this.startPreviewInternal(this.getDefaultPreviewParams(portrait, front));
        }
    }

    @Override
    public void startPreview(PreviewParams previewParams) {
        MLog.info((Object)TAG, (String)"startPreview: mPreviewStarted:%b, mPreviewStartCountGlobal:%d, previewParams:%s", (Object[])new Object[]{this.mPreviewStarted, mPreviewStartCountGlobal, previewParams});
        if (!this.mPreviewStarted && previewParams != null) {
            this.startPreviewInternal(previewParams);
        }
    }

    @Override
    public boolean isPreviewStarted() {
        return this.mPreviewStarted;
    }

    @Override
    public void stopPreview() {
        MLog.info((Object)TAG, (String)"stopPreview: mPreviewStarted:%b", (Object[])new Object[]{this.mPreviewStarted});
        if (this.mPreviewStarted) {
            this.mCamera.stopPreview();
            --mPreviewStartCountGlobal;
            this.mPreviewStarted = false;
            this.mCurPreviewParams = null;
            this.mCurOrientation = null;
        }
    }

    @Override
    public void setZOrderTop(boolean onTop) {
        MLog.info((Object)TAG, (String)("setZOrderTop() called with: onTop = [" + onTop + "]"), (Object[])new Object[0]);
        this.mCamera.videoView().setZOrderOnTop(onTop);
    }

    @Override
    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        MLog.info((Object)TAG, (String)("setZOrderMediaOverlay() called with: isMediaOverlay = [" + isMediaOverlay + "]"), (Object[])new Object[0]);
        this.mCamera.videoView().setZOrderMediaOverlay(isMediaOverlay);
    }

    @Override
    public void enableMirror(boolean enable) {
        MLog.info((Object)TAG, (String)("enableMirror() called with: enable = [" + enable + "]"), (Object[])new Object[0]);
        this.mCamera.enableMirror(enable);
    }

    @Override
    public void switchPreviewCamera() {
        MLog.info((Object)TAG, (String)"switchPreviewCamera, facing:%s", (Object[])new Object[]{this.mCamera.getCameraFacing()});
        this.mCamera.switchCamera();
    }

    @Override
    public boolean isCameraOpened() {
        return this.mCamera.isOpen();
    }

    @Override
    public boolean isFrontCamera() {
        CameraUtils.CameraFacing cameraFacing = this.mCamera.getCameraFacing();
        return CameraUtils.CameraFacing.FacingFront.equals((Object)cameraFacing);
    }

    @Override
    public void changeCameraPreviewParams(PreviewParams previewParams) {
        MLog.info((Object)TAG, (String)("changeCameraPreviewParams() called with: previewParams = [" + previewParams + "]"), (Object[])new Object[0]);
        if (previewParams != null && !previewParams.equals(this.mCurPreviewParams)) {
            MLog.info((Object)TAG, (String)"changeCameraPreviewParams inner: mCurPreviewParams:%s", (Object[])new Object[]{this.mCurPreviewParams});
            this.mCamera.changePreviewpParams(previewParams.getOrigPreviewParams());
            this.updateOrientation(previewParams);
        }
    }

    @Override
    public void setExtraPerformance(Constant.ExtraPerformance extraPerformance, Boolean on, int value) {
        this.mCamera.setExtraPerformance(extraPerformance, on, value);
    }

    @Override
    public void setCameraFlashMode(Boolean isOpen) {
        this.mCamera.setCameraFlashMode(isOpen.booleanValue());
    }

    @Override
    public void takeScreenShot(final ScreenShotCallback callback2) {
        this.mCamera.takeScreenShot(new com.yy.mediaframework.screenshot.ScreenShotCallback(){

            public void onTaked(Bitmap bitmap) {
                if (callback2 != null) {
                    callback2.onTaked(bitmap);
                }
            }

            public void onError(Throwable throwable) {
                if (callback2 != null) {
                    callback2.onError(throwable);
                }
            }
        });
    }

    @Override
    public void onTouch(MotionEvent event) {
        this.mCamera.videoView().onTouch(event);
    }

    @Override
    public VideoOrientation getVideoOrientation() {
        return this.mCurOrientation;
    }

    private Publisher getPublisher() {
        return Publisher.getInstance();
    }

    private PreviewParams getDefaultPreviewParams(boolean portrait, boolean front) {
        int width = portrait ? 720 : 1280;
        int height = portrait ? 1280 : 720;
        YYCamera.CameraFacing facing = front ? YYCamera.CameraFacing.Front : YYCamera.CameraFacing.Back;
        return new PreviewParams(width, height, 24, facing, portrait, YYCamera.CameraResolutionMode.CAMERA_RESOLUTION_RANGE_MODE);
    }

    private void startPreviewInternal(PreviewParams previewParams) {
        if (mPreviewStartCountGlobal > 0) {
            MLog.info((Object)TAG, (String)"startPreviewInternal: stopPreview", (Object[])new Object[0]);
            this.mCamera.stopPreview();
        }
        MLog.info((Object)TAG, (String)"startPreviewInternal", (Object[])new Object[0]);
        this.mCamera.startPreview(previewParams.getOrigPreviewParams());
        this.mCurPreviewParams = previewParams;
        ++mPreviewStartCountGlobal;
        this.mPreviewStarted = true;
        this.updateOrientation(previewParams);
    }

    private void updateOrientation(PreviewParams previewParams) {
        if (previewParams == null) {
            MLog.error((Object)TAG, (String)"updateOrientation: null previewParams", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"updateOrientation: before mCurOrientation:%s", (Object[])new Object[]{this.mCurOrientation});
        this.mCurOrientation = previewParams.displayPortrait ? VideoOrientation.Portrait : VideoOrientation.Landscape;
        MLog.info((Object)TAG, (String)"updateOrientation: after mCurOrientation:%s", (Object[])new Object[]{this.mCurOrientation});
    }
}

