/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pluginstartlive.lianmai.crosschannel;

import com.yy.mobile.pluginstartlive.lianmai.crosschannel.TransferInfoBuilder;
import com.yy.mobile.pluginstartlive.lianmai.crosschannel.TransferParams;
import com.yy.mobile.pluginstartlive.media.liveparam.LiveParam;
import com.yy.mobile.pluginstartlive.media.liveparam.LiveParamManager;
import com.yy.mobile.pluginstartlive.media.publisher.VideoPublishHolder;
import com.yy.mobile.pluginstartlive.media.publisher.VideoPublisher;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.BuzInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.TransferInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoQuality;
import com.yy.mobile.uniondif.AppIdConfig;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.YLKLive;

public class TransLianmaiHelper {
    private static final String TAG = "TransLianmaiHelper";
    private TransferParams mCurrentTransferParams = null;
    private boolean mHasStartTransLianmai = false;

    public void startTransLianmai(TransferParams transferParams) {
        this.startTransLianmai(transferParams, AppIdConfig.getAppIds().getPkLianmaiType());
    }

    public void startTransLianmai(TransferParams transferParams, int lianmaiType) {
        if (this.mHasStartTransLianmai || this.mCurrentTransferParams != null) {
            MLog.error((Object)TAG, (String)"startTransLianmai: duplicate startTransLianmai", (Object[])new Object[0]);
            return;
        }
        VideoPublisher videoPublisher = VideoPublishHolder.INSTANCE.getVideoPublisher();
        if (videoPublisher == null || transferParams == null) {
            MLog.error((Object)TAG, (String)"startTransLianmai: null object, mVideoPublisher:%s, transferParams:%s", (Object[])new Object[]{videoPublisher, transferParams});
            return;
        }
        this.mHasStartTransLianmai = true;
        this.mCurrentTransferParams = transferParams;
        TransferInfo transferInfo = new TransferInfoBuilder().build(this.mCurrentTransferParams.getUid(), this.mCurrentTransferParams.getSid(), this.mCurrentTransferParams.getSubSid(), 1L, this.getFilterType(this.mCurrentTransferParams.getTransferType()));
        MLog.info((Object)TAG, (String)"startTransLianmai: mCurrentTransferParams:%s, transferInfo:%s", (Object[])new Object[]{this.mCurrentTransferParams, transferInfo});
        videoPublisher.setBuzInfo(new BuzInfo(lianmaiType));
        LiveParam transMicParam = LiveParamManager.INSTANCE.getTransMicLiveParam();
        if (transMicParam != null) {
            videoPublisher.switchQuality(transMicParam.getVideoParams());
            YLKLive.instance().setConfigs(0, transMicParam.getMediaConfigs(true));
        }
        videoPublisher.startPublishToOtherChannel(transferInfo);
    }

    public void stopTransLianmai() {
        if (!this.mHasStartTransLianmai || this.mCurrentTransferParams == null) {
            MLog.error((Object)TAG, (String)"stopTransLianmai: duplicate stopTransLianmai", (Object[])new Object[0]);
            return;
        }
        VideoPublisher videoPublisher = VideoPublishHolder.INSTANCE.getVideoPublisher();
        if (videoPublisher == null) {
            MLog.error((Object)TAG, (String)"stopTransLianmai: null mVideoPublisher", (Object[])new Object[0]);
            return;
        }
        TransferInfo transferInfo = new TransferInfoBuilder().build(this.mCurrentTransferParams.getUid(), this.mCurrentTransferParams.getSid(), this.mCurrentTransferParams.getSubSid(), 1L, this.getFilterType(this.mCurrentTransferParams.getTransferType()));
        MLog.info((Object)TAG, (String)"stopTransLianmaiCompat: mCurrentTransferParams:%s, transferInfo:%s", (Object[])new Object[]{this.mCurrentTransferParams, transferInfo});
        videoPublisher.stopPublishToOtherChannel(transferInfo);
        videoPublisher.setBuzInfo(new BuzInfo());
        LiveParam liveParam = LiveParamManager.INSTANCE.getCurrentNormalLiveParam();
        if (liveParam != null) {
            videoPublisher.switchQuality(liveParam.getVideoParams());
            YLKLive.instance().setConfigs(0, liveParam.getMediaConfigs(false));
        } else {
            videoPublisher.switchQuality(VideoQuality.HD);
        }
        this.mCurrentTransferParams = null;
        this.mHasStartTransLianmai = false;
    }

    public boolean hasStartTransLianmai() {
        return this.mHasStartTransLianmai;
    }

    private TransferInfo.FilterType getFilterType(int transferType) {
        TransferInfo.FilterType filterType = transferType == 1 ? TransferInfo.FilterType.Video : (transferType == 2 ? TransferInfo.FilterType.Audio : TransferInfo.FilterType.Nil);
        return filterType;
    }
}

