/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pluginstartlive.lianmai.ui;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.pluginstartlive.lianmai.ui.ILianmaiVideoView;
import com.yy.mobile.pluginstartlive.lianmai.ui.VideoMixtureManager;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.AudienceVideoView;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid.AbsVideoId;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid.MicNoVideoId;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.releasemanager.ObjectReleaseBeforeInitManager;

public class LianMaiVideoViewForAnchor
implements ObjectReleaseBeforeInitManager.ReleaseBeforeInitObject,
ILianmaiVideoView {
    private static final String TAG = "LianMaiVideoViewForAnchor";
    private AudienceVideoView mAudienceVideoView;
    private ViewGroup mContainer;
    private MicNoVideoId mMicNoVideoId = new MicNoVideoId(1);

    public LianMaiVideoViewForAnchor(@NonNull AudienceVideoView audienceVideoView, @NonNull ViewGroup container) {
        ObjectReleaseBeforeInitManager.getInstance().callInit((ObjectReleaseBeforeInitManager.ReleaseBeforeInitObject)this);
        this.mContainer = container;
        this.mAudienceVideoView = audienceVideoView;
    }

    public void setNeedMixture(boolean mixture) {
        VideoMixtureManager.getInstance().setVideoNeedMixture(mixture);
    }

    @Override
    public void toLianMaiMode() {
        MLog.info((Object)TAG, (String)"toLianMaiMode: ", (Object[])new Object[0]);
        this.addToContainer();
        this.mAudienceVideoView.setVideoEnable(true);
        this.mAudienceVideoView.start((AbsVideoId)this.mMicNoVideoId);
    }

    @Override
    public void toUnLianMaiMode() {
        MLog.info((Object)TAG, (String)"toUnLianMaiMode: ", (Object[])new Object[0]);
        this.mAudienceVideoView.stop();
        this.mAudienceVideoView.setVideoEnable(false);
        this.removeFromContainer();
    }

    @Override
    public void resume() {
        MLog.info((Object)TAG, (String)"resume: ", (Object[])new Object[0]);
        this.mAudienceVideoView.setVideoEnable(true);
    }

    @Override
    public void pause() {
        MLog.info((Object)TAG, (String)"pause: ", (Object[])new Object[0]);
        this.mAudienceVideoView.setVideoEnable(false);
    }

    @Override
    public void release() {
        MLog.info((Object)TAG, (String)"release called", (Object[])new Object[0]);
        ObjectReleaseBeforeInitManager.getInstance().callRelease((ObjectReleaseBeforeInitManager.ReleaseBeforeInitObject)this);
    }

    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        MLog.info((Object)TAG, (String)"setZOrderMediaOverlay: isMediaOverlay:%b", (Object[])new Object[]{isMediaOverlay});
        this.mAudienceVideoView.setZOrderMediaOverlay(isMediaOverlay);
    }

    public void setZOrderTop(boolean onTop) {
        MLog.info((Object)TAG, (String)"setZOrderTop: onTop:%b", (Object[])new Object[]{onTop});
        this.mAudienceVideoView.setZOrderOnTop(onTop);
    }

    private void removeFromContainer() {
        if (this.mContainer != null && this.mAudienceVideoView.getParent() != null) {
            MLog.info((Object)TAG, (String)("removeFromContainer called with: container = [" + this.mContainer + "]"), (Object[])new Object[0]);
            this.mContainer.removeView((View)this.mAudienceVideoView);
        }
        this.mAudienceVideoView.setVisibility(8);
    }

    private void addToContainer() {
        if (this.mContainer != null && this.mAudienceVideoView.getParent() == null) {
            MLog.info((Object)TAG, (String)("addToContainer called with: container = [" + this.mContainer + "]"), (Object[])new Object[0]);
            this.mContainer.addView((View)this.mAudienceVideoView, 0);
        }
        this.mAudienceVideoView.setVisibility(0);
    }

    public void onInit() {
        MLog.info((Object)TAG, (String)"onInit called", (Object[])new Object[0]);
    }

    public void onRelease() {
        MLog.info((Object)TAG, (String)"onRelease called", (Object[])new Object[0]);
        this.mAudienceVideoView.release();
    }

    public String getType() {
        return "AUDIENCE_VIDEO";
    }

    @Override
    public void initVideoView() {
        this.setNeedMixture(false);
        this.setZOrderMediaOverlay(true);
        this.setZOrderTop(true);
    }
}

