/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin.pluginauthverify.verify.hwtoken;

import android.app.Dialog;
import android.content.Context;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginauthverify.R;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;

public class DynamicTokenLoginDialog
implements BaseDialog {
    private static final String TAG = "DynamicTokenLoginDialog";
    private boolean cancelable;
    private boolean outSideCancelable;
    private boolean showErrorTip;
    private DynamicTokenLoginDialogListener listener;

    public DynamicTokenLoginDialog(boolean cancelable, boolean outSideCancelable, boolean showErrorTip, DynamicTokenLoginDialogListener listener) {
        this.cancelable = cancelable;
        this.outSideCancelable = outSideCancelable;
        this.showErrorTip = showErrorTip;
        this.listener = listener;
    }

    public void init(final Dialog dialog2) {
        dialog2.setCancelable(this.cancelable);
        dialog2.setCanceledOnTouchOutside(this.outSideCancelable);
        dialog2.show();
        Window window = dialog2.getWindow();
        window.setContentView(this.getLayoutResId());
        window.clearFlags(131072);
        window.setSoftInputMode(5);
        final EditText input = (EditText)window.findViewById(R.id.dynamic_token);
        TextView errorTip = (TextView)window.findViewById(R.id.hw_token_error_tip);
        if (this.showErrorTip) {
            errorTip.setVisibility(0);
        }
        TextView cancle = (TextView)window.findViewById(R.id.btn_cancel);
        cancle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DynamicTokenLoginDialog.this.listener.onCancel();
                dialog2.dismiss();
            }
        });
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog2.setOnDismissListener(null);
                String inputCode = input.getText().toString().trim();
                if (!StringUtils.isEmptyString((String)inputCode)) {
                    dialog2.dismiss();
                    DynamicTokenLoginDialog.this.listener.onOK(inputCode);
                } else {
                    Toast.makeText((Context)dialog2.getContext(), (CharSequence)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801\uff01", (int)0).show();
                }
            }
        });
        input.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (66 == keyCode && event.getAction() == 0) {
                    String inputCode = input.getText().toString().trim();
                    DynamicTokenLoginDialog.this.listener.onOK(inputCode);
                    MLog.info((Object)DynamicTokenLoginDialog.TAG, (String)"enter to confirm", (Object[])new Object[0]);
                    return true;
                }
                return false;
            }
        });
    }

    public int getLayoutResId() {
        return R.layout.layout_dynamic_token_dialog;
    }

    public static interface DynamicTokenLoginDialogListener {
        public void onOK(String var1);

        public void onCancel();
    }
}

