package com.yy.mobile.vivo

import android.content.Context
import android.text.Editable
import android.text.TextWatcher
import android.widget.EditText

/**
 * Create by guananjie on 2019/8/29
 * E-mail: guananjie@yy.com
 * YY: 909042007
 */

fun EditText.autoSaveLastModifyRecord(defaultValue: String = "") {
    val self = this
    val sp = context.getSharedPreferences("autoSaveLastModifyRecord", Context.MODE_PRIVATE)
    this.setText(
        sp.getString(
            self.id.toString(),
            defaultValue
        )
    )
    this.addTextChangedListener(object : TextWatcher {
        override fun afterTextChanged(s: Editable?) {
            sp.edit()
                    .putString(self.id.toString(), s.toString()).apply()

        }

        override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {
        }

        override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
        }
    })
}