package com.yy.mobile.vivo

import android.Manifest
import android.annotation.SuppressLint
import android.app.Application
import android.content.Intent
import android.os.Bundle
import android.support.v4.app.FragmentActivity
import android.view.View
import com.duowan.mobile.aar.R
import com.gyf.immersionbar.ImmersionBar
import com.sembozdemir.permissionskt.askPermissions
import com.unionyy.mobile.magnet.core.state.CrossProcessLoginState
import com.unionyy.mobile.magnet.core.state.InterruptState
import com.unionyy.mobile.magnet.core.state.LoginState
import com.unionyy.mobile.magnet.core.state.LogoutState
import com.unionyy.mobile.magnet.southpole.Magnet
import com.unionyy.mobile.meipai.api.MP2YYFeedbackAction
import com.unionyy.mobile.vivo.api.VV2YYAuthAction
import com.unionyy.mobile.vivo.api.VV2YYChannelAction
import com.unionyy.opensdk.BuildConfig
import com.yy.mobile.baseapi.AuthCallback
import com.yy.mobile.baseapi.Union2YYSettingAction
import com.yy.mobile.bizmodel.login.LoginUtil
import com.yy.mobile.config.BasicConfig
import com.yy.mobile.ui.widget.toast.Toast
import kotlinx.android.synthetic.main.vivo_activity_demo.*

class DemoActivity : FragmentActivity() {

    @SuppressLint("CheckResult")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.vivo_activity_demo)

        ImmersionBar.with(this).init()
        et_channel_sid.autoSaveLastModifyRecord()

        askPermissions(
            Manifest.permission.READ_PHONE_STATE,
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
            Manifest.permission.READ_EXTERNAL_STORAGE,
            Manifest.permission.INTERNET
        ) {}

        btnLogin.setOnClickListener {
            if (LoginUtil.isLogined()) {
                Toast.makeText(this, "已登录!", Toast.LENGTH_SHORT).show()
            }
            startActivity(Intent(this, PasswordLoginActivity::class.java))
        }

        feedBack.setOnClickListener {
            VVYYSDK.obtainAction(MP2YYFeedbackAction::class.java)?.gotoFeedbackPage(this)
        }

        refreshState()
        tv_app_version.text = "YY版本号：${BuildConfig.YYSDK_VER}"
    }

    fun gotoChannel(v: View) {
        val sid = et_channel_sid.text.toString().toLongOrNull() ?: 1493896955
        val ssid = 0L
        BasicConfig.getInstance().appContext?.let {
            if (it is Application) {
                VVYYSDK.obtainAction(VV2YYChannelAction::class.java, it, this)?.run {
                    instance(sid, ssid)
                        .joinChannel(this@DemoActivity)
                }
            }
        }
    }

    fun gotoSetting(v: View) {
        VVYYSDK.obtainAction(Union2YYSettingAction::class.java)?.gotoSettingActivity(this)
    }

    fun login(v: View) {
        VVYYSDK.obtainAction(VV2YYAuthAction::class.java)
            ?.bindLogin(et_access_token.text.toString(), object : AuthCallback {
                override fun onSuccess(yyUid: Long, ticket: String, isNewUser: Boolean) {
                    Toast.makeText(
                        this@DemoActivity, "登录成功: $yyUid", Toast.LENGTH_SHORT
                    ).show()
                }

                override fun onFail(reason: String?) {
                    Toast.makeText(
                        this@DemoActivity, "登录失败 $reason", Toast.LENGTH_SHORT
                    ).show()
                }
            })
    }

    @SuppressLint("SetTextI18n")
    private fun refreshState() {
        val state = Magnet.getCurrentState()
        when (state) {
            is LoginState ->
                currentStateText.text = "登录中-当前uid:${state.currentUid}, 第三方openId:${state.thirdPartyInfo?.openId}"
            is InterruptState ->
                currentStateText.text = "匿名登录中-匿名uid:${state.anonymousUid}, 错误:${state.error?.message}"
            is LogoutState ->
                currentStateText.text = "匿名登录中-匿名uid:${state.anonymousUid}"
            is CrossProcessLoginState ->
                currentStateText.text = "跨进程登录中-当前uid:${state.currentUid}"
        }
    }
}