/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.db;

import android.database.sqlite.SQLiteDatabase;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.AbstractBaseCore;
import com.yymobile.core.db.DbCommand;
import com.yymobile.core.db.DbContext;
import com.yymobile.core.db.DbHelper;
import java.sql.SQLException;

public abstract class AbstractBaseDb
extends AbstractBaseCore {
    private static final String TAG = "AbstractBaseDb";
    protected DbContext dbContext;

    public final boolean isDbContextAttached() {
        return this.dbContext != null;
    }

    protected AbstractBaseDb() {
    }

    public void setDbContext(DbContext ctx) {
        this.dbContext = ctx;
    }

    protected <D extends Dao<T, ?>, T> D getDao(Class<T> cls) {
        Dao dao = null;
        if (this.dbContext != null) {
            DbHelper helper2 = this.dbContext.getDbHelper();
            if (cls != null && helper2 != null) {
                try {
                    dao = helper2.getDao(cls);
                }
                catch (SQLException e2) {
                    MLog.error((Object)TAG, (String)("cannot getDao for class " + cls.getName()), (Throwable)e2, (Object[])new Object[0]);
                }
            }
        }
        return (D)dao;
    }

    protected <D extends Dao<T, ?>, T> D getDaoWithConfig(DatabaseTableConfig<T> config) {
        Dao dao = null;
        if (this.dbContext != null) {
            DbHelper helper2 = this.dbContext.getDbHelper();
            if (config != null && helper2 != null) {
                try {
                    dao = DaoManager.createDao((ConnectionSource)helper2.getConnectionSource(), config);
                }
                catch (SQLException e2) {
                    MLog.error((Object)TAG, (String)("cannot getDao for class with config" + config), (Object[])new Object[0]);
                }
            }
        }
        return (D)dao;
    }

    protected SQLiteDatabase getSqliteDb() {
        return this.dbContext.getDbHelper().getWritableDatabase();
    }

    protected <T> void sendCommand(DbCommand<T> cmd) {
        if (this.dbContext != null) {
            this.dbContext.sendCommand(cmd);
        }
    }

    protected <D extends Dao<T, ?>, T> D getDaoNoCacheWithConfig(DatabaseTableConfig<T> config) {
        D dao = this.getDaoWithConfig(config);
        if (this.dbContext != null && this.dbContext.getDbHelper() != null) {
            DaoManager.unregisterDao((ConnectionSource)this.dbContext.getDbHelper().getConnectionSource(), dao);
        }
        return dao;
    }
}

