/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.RelativeLayout;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.ui.utils.ImageViewPool;
import com.yy.mobile.util.log.MLog;
import com.yymobile.baseapi.R;
import java.util.Random;

public class FavorLayout
extends RelativeLayout {
    private static final String TAG = "FavorLayout";
    private static final long UPDATE_INTERVAL_MILLIS = 300L;
    private Handler mHandler;
    private boolean isRunning = true;
    private ImageViewPool mImageViewPool;
    private long remainCount = 0L;
    private Interpolator[] interpolators;
    private int mHeight;
    private int mWidth;
    private RelativeLayout.LayoutParams lp;
    private Drawable[] drawables;
    private Drawable[] myDrawable;
    private Random random = new Random();
    private int dHeight;
    private int dWidth;
    private Runnable animationTask = new Runnable(){

        @Override
        public void run() {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)FavorLayout.TAG, (String)("remainCount = " + FavorLayout.this.remainCount + "   isRunning = " + FavorLayout.this.isRunning), (Object[])new Object[0]);
            }
            if (FavorLayout.this.remainCount > 0L && FavorLayout.this.isRunning) {
                FavorLayout.this.showAnimation(false);
                FavorLayout.this.remainCount--;
                FavorLayout.this.postAnimation();
            }
        }
    };

    public FavorLayout(Context context) {
        super(context);
    }

    public FavorLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.drawables = new Drawable[5];
        this.drawables[0] = this.getResources().getDrawable(R.drawable.icon_like_1);
        this.drawables[1] = this.getResources().getDrawable(R.drawable.icon_like_3);
        this.drawables[2] = this.getResources().getDrawable(R.drawable.icon_like_5);
        this.drawables[3] = this.getResources().getDrawable(R.drawable.icon_like_7);
        this.drawables[4] = this.getResources().getDrawable(R.drawable.icon_like_9);
        this.myDrawable = new Drawable[5];
        this.myDrawable[0] = this.getResources().getDrawable(R.drawable.icon_like_2);
        this.myDrawable[1] = this.getResources().getDrawable(R.drawable.icon_like_4);
        this.myDrawable[2] = this.getResources().getDrawable(R.drawable.icon_like_6);
        this.myDrawable[3] = this.getResources().getDrawable(R.drawable.icon_like_8);
        this.myDrawable[4] = this.getResources().getDrawable(R.drawable.icon_like_10);
        this.dHeight = this.myDrawable[0].getIntrinsicHeight();
        this.dWidth = this.myDrawable[0].getIntrinsicWidth();
        this.lp = new RelativeLayout.LayoutParams(this.dWidth, this.dHeight);
        this.lp.addRule(14, -1);
        this.lp.addRule(12, -1);
        this.interpolators = new Interpolator[1];
        this.interpolators[0] = new LinearInterpolator();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mImageViewPool = ImageViewPool.getImageViewPool(this.getContext(), 10);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.getMeasuredWidth();
        this.mHeight = this.getMeasuredHeight();
    }

    public void addFavor(long count, boolean isMyself) {
        if (count <= 0L) {
            return;
        }
        if (isMyself) {
            while (count > 0L) {
                this.showAnimation(true);
                --count;
            }
        } else {
            this.remainCount += count;
            this.postAnimation();
        }
    }

    public void addFavorImmediately(long count, boolean randomStyle) {
        if (count <= 0L) {
            return;
        }
        while (count > 0L) {
            this.showAnimation(!randomStyle);
            --count;
        }
    }

    public void onResume() {
        this.isRunning = true;
        this.mHandler.removeCallbacks(this.animationTask);
        this.mHandler.post(this.animationTask);
    }

    public void onPause() {
        this.isRunning = false;
        this.mHandler.removeCallbacks(this.animationTask);
    }

    public void onStop() {
        this.isRunning = false;
        this.remainCount = 0L;
        this.mHandler.removeCallbacksAndMessages(null);
    }

    private void postAnimation() {
        this.mHandler.removeCallbacks(this.animationTask);
        this.mHandler.postDelayed(this.animationTask, (long)(250 + this.random.nextInt(220)));
    }

    protected void showAnimation(boolean isMyself) {
        if (this.mWidth == 0 || this.mHeight == 0) {
            MLog.error((Object)TAG, (String)"not yet get measure!", (Object[])new Object[0]);
            return;
        }
        RecycleImageView imageView = this.mImageViewPool.getImageViewFromPool();
        imageView.setImageDrawable(isMyself ? this.myDrawable[this.random.nextInt(this.myDrawable.length)] : this.drawables[this.random.nextInt(this.drawables.length)]);
        imageView.setLayoutParams((ViewGroup.LayoutParams)this.lp);
        imageView.setTranslationX(0.0f);
        imageView.setLayerType(2, null);
        this.addView((View)imageView);
        Animator set = this.getAnimator((View)imageView);
        set.addListener((Animator.AnimatorListener)new AnimEndListener((View)imageView));
        set.start();
    }

    private Animator getAnimator(View target) {
        AnimatorSet set = this.getEnterAnimtor(target);
        ValueAnimator bezierValueAnimator = this.getBezierValueAnimator(target);
        AnimatorSet finalSet = new AnimatorSet();
        finalSet.playSequentially(new Animator[]{set});
        finalSet.playSequentially(new Animator[]{set, bezierValueAnimator});
        finalSet.setInterpolator((TimeInterpolator)this.interpolators[this.random.nextInt(this.interpolators.length)]);
        finalSet.setTarget((Object)target);
        return finalSet;
    }

    private AnimatorSet getEnterAnimtor(View target) {
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)target, (Property)View.ALPHA, (float[])new float[]{0.2f, 1.0f});
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)target, (Property)View.SCALE_X, (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)target, (Property)View.SCALE_Y, (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator transY = ObjectAnimator.ofFloat((Object)target, (Property)View.TRANSLATION_Y, (float[])new float[]{(float)this.dHeight / 2.0f, 0.0f});
        AnimatorSet enter = new AnimatorSet();
        enter.setDuration(300L);
        enter.setInterpolator((TimeInterpolator)new LinearInterpolator());
        enter.playTogether(new Animator[]{alpha, scaleX, scaleY, transY});
        enter.setTarget((Object)target);
        return enter;
    }

    private ValueAnimator getBezierValueAnimator(View target) {
        BezierEvaluator evaluator = new BezierEvaluator(this.getPointF(5), this.getPointF(2));
        ValueAnimator animator = ValueAnimator.ofObject((TypeEvaluator)evaluator, (Object[])new Object[]{new PointF((float)((this.mWidth - this.dWidth) / 2), (float)(this.mHeight - this.dHeight)), new PointF((float)(this.random.nextInt(this.mWidth) + this.random.nextInt(2 * this.mWidth / 3) - this.random.nextInt(2 * this.mWidth / 3)), 0.0f)});
        animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new BezierListener(target));
        animator.setTarget((Object)target);
        animator.setDuration(4000L);
        return animator;
    }

    private PointF getPointF(int scale) {
        PointF pointF = new PointF();
        pointF.x = this.random.nextInt(this.mWidth - this.dWidth / 3);
        pointF.y = this.random.nextInt(this.mHeight - this.dHeight / 2) / scale;
        return pointF;
    }

    public class BezierEvaluator
    implements TypeEvaluator<PointF> {
        private PointF pointF1;
        private PointF pointF2;

        public BezierEvaluator(PointF pointF1, PointF pointF2) {
            this.pointF1 = pointF1;
            this.pointF2 = pointF2;
        }

        public PointF evaluate(float time, PointF startValue, PointF endValue) {
            float timeLeft = 1.0f - time;
            PointF point = new PointF();
            PointF point0 = startValue;
            PointF point3 = endValue;
            point.x = timeLeft * timeLeft * timeLeft * point0.x + 3.0f * timeLeft * timeLeft * time * this.pointF1.x + 3.0f * timeLeft * time * time * this.pointF2.x + time * time * time * point3.x;
            point.y = timeLeft * timeLeft * timeLeft * point0.y + 3.0f * timeLeft * timeLeft * time * this.pointF1.y + 3.0f * timeLeft * time * time * this.pointF2.y + time * time * time * point3.y;
            return point;
        }
    }

    private class AnimEndListener
    extends AnimatorListenerAdapter {
        private View target;

        public AnimEndListener(View target) {
            this.target = target;
        }

        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
            this.target.setLayerType(0, null);
            FavorLayout.this.removeView(this.target);
        }
    }

    private class BezierListener
    implements ValueAnimator.AnimatorUpdateListener {
        private View target;

        public BezierListener(View target) {
            this.target = target;
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            PointF pointF = (PointF)animation.getAnimatedValue();
            this.target.setX(pointF.x);
            this.target.setY(pointF.y);
            if ((double)animation.getAnimatedFraction() > 0.5) {
                float alpha = 1.0f - (animation.getAnimatedFraction() - 0.5f) / 0.5f;
                this.target.setAlpha(alpha);
            }
        }
    }
}

