/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin.manager;

import com.yy.android.small.Small;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.manager.event.PluginActiveEvent;
import com.yy.mobile.plugin.manager.event.PluginDownloadEvent;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public enum CustomPluginManager {
    INSTANCE;

    private static final String TAG = "CustomPluginManager";
    private Map<String, Disposable> mActiveDisposables;
    private Map<String, Object> mActivePluginReqs;
    private Map<String, Small.OnSetupListener> mPluginActiveListeners;
    private Map<String, Disposable> mDownloadDisposables;
    private Map<String, Object> mDownloadPluginReqs;

    private String getListenerTag(@Nonnull String pluginId, @Nonnull String tag) {
        return pluginId + "_" + tag;
    }

    public boolean checkPluginIsActive(String pluginId, boolean withActive, boolean withDownload) {
        MLog.info((Object)TAG, (String)("checkPluginIsActive-> pluginId:" + pluginId + ",withActive:" + withActive + ",withload:" + withDownload), (Object[])new Object[0]);
        return true;
    }

    public void startDownloadPlugin(final String pluginId, final boolean withActive) {
        MLog.info((Object)TAG, (String)("startDownloadPlugin->pluginId:" + pluginId + ",withActive:" + withActive), (Object[])new Object[0]);
        if (this.hasSyncDownloadPluginTask(pluginId)) {
            MLog.info((Object)TAG, (String)("startDownloadPlugin->pluginId:" + pluginId + " download task has benn started"), (Object[])new Object[0]);
            return;
        }
        this.addDownloadDisposable(pluginId, this.downloadPlugin(pluginId, TAG, false).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doFinally(new Action(){

            public void run() throws Exception {
                MLog.info((Object)CustomPluginManager.TAG, (String)("startDownloadPlugin doFinally->pluginId:" + pluginId), (Object[])new Object[0]);
                CustomPluginManager.this.removeDownloadDisposable(pluginId);
            }
        }).subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(Boolean success) throws Exception {
                MLog.info((Object)CustomPluginManager.TAG, (String)("startDownloadPlugin complete->pluginId:" + pluginId + ",withActive:" + withActive + ",result:" + success), (Object[])new Object[0]);
                RxBus.getDefault().post((Object)new PluginDownloadEvent(pluginId, success));
                if (withActive) {
                    if (success.booleanValue()) {
                        CustomPluginManager.this.startActivePlugin(pluginId);
                    } else {
                        RxBus.getDefault().post((Object)new PluginActiveEvent(pluginId, false));
                    }
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)CustomPluginManager.TAG, (Throwable)throwable);
                RxBus.getDefault().post((Object)new PluginDownloadEvent(pluginId, false));
                if (withActive) {
                    RxBus.getDefault().post((Object)new PluginActiveEvent(pluginId, false));
                }
            }
        }));
    }

    private boolean hasSyncDownloadPluginTask(String pluginId) {
        return null != this.mDownloadDisposables && this.mDownloadDisposables.containsKey(pluginId);
    }

    private void addDownloadDisposable(String pluginId, Disposable disposable) {
        if (null == this.mDownloadDisposables) {
            this.mDownloadDisposables = new ConcurrentHashMap<String, Disposable>();
        }
        this.mDownloadDisposables.put(pluginId, disposable);
    }

    private void removeDownloadDisposable(String pluginId) {
        if (null == this.mDownloadDisposables) {
            return;
        }
        this.mDownloadDisposables.remove(pluginId);
    }

    public void startActivePlugin(final String pluginId) {
        MLog.info((Object)TAG, (String)("startActivePlugin->pluginId:" + pluginId), (Object[])new Object[0]);
        if (this.hasSyncActivingPluginTask(pluginId)) {
            return;
        }
        Disposable disposable = this.activePlugin(pluginId, TAG, false).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doFinally(new Action(){

            public void run() throws Exception {
                MLog.info((Object)CustomPluginManager.TAG, (String)("startActivePlugin doFinally->pluginId:" + pluginId), (Object[])new Object[0]);
                CustomPluginManager.this.removeActiveDisposable(pluginId);
            }
        }).subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(Boolean aBoolean) throws Exception {
                RxBus.getDefault().post((Object)new PluginActiveEvent(pluginId, aBoolean));
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)CustomPluginManager.TAG, (Throwable)throwable);
                RxBus.getDefault().post((Object)new PluginActiveEvent(pluginId, false));
            }
        });
        this.addActiveDisposable(pluginId, disposable);
    }

    private boolean hasSyncActivingPluginTask(String pluginId) {
        return null != this.mActiveDisposables && this.mActiveDisposables.containsKey(pluginId);
    }

    private void addActiveDisposable(@Nonnull String pluginId, Disposable disposable) {
        if (null == this.mActiveDisposables) {
            this.mActiveDisposables = new ConcurrentHashMap<String, Disposable>();
        }
        this.mActiveDisposables.put(pluginId, disposable);
    }

    private void removeActiveDisposable(@Nonnull String pluginId) {
        if (null == this.mActiveDisposables) {
            return;
        }
        this.mActiveDisposables.remove(pluginId);
    }

    public Flowable<Boolean> downloadPlugin(String pluginId, @Nonnull String tag, boolean removeDownloadWithCancel) {
        return this.downloadPlugin(pluginId, 1, tag, removeDownloadWithCancel);
    }

    public Flowable<Boolean> downloadPlugin(String pluginId, int loadMode, @Nonnull String tag, boolean removeDownloadWithCancel) {
        MLog.info((Object)TAG, (String)("downloadPlugin->pluginId:" + pluginId + ",tag:" + tag + ",removeDownloadWithCancel:" + removeDownloadWithCancel), (Object[])new Object[0]);
        return Flowable.just((Object)true);
    }

    public boolean isPluginDownloaded(String pluginId) {
        return Small.isPluginShouldRun((String)pluginId);
    }

    public boolean isPluginDownloading(String pluginId) {
        return null != this.mDownloadPluginReqs && this.mDownloadPluginReqs.containsKey(pluginId);
    }

    public boolean hasDownloadListener(String pluginId, String tag) {
        return true;
    }

    public boolean cancelDownloadPlugin(String pluginId) {
        MLog.info((Object)TAG, (String)("cancelDownloadPlugin->pluginId:" + pluginId), (Object[])new Object[0]);
        if (null == this.mDownloadPluginReqs) {
            return false;
        }
        boolean result = false;
        return result;
    }

    public Flowable<Boolean> activePluginWithDownload(String pluginId, int loadMode, String tag, boolean cancelWhenDispose) {
        MLog.info((Object)TAG, (String)("activePluginWithDownload->pluginId:" + pluginId + ",tag:" + tag + ",cancelWhenDispose:" + cancelWhenDispose), (Object[])new Object[0]);
        return Flowable.just((Object)true);
    }

    public Flowable<Boolean> activePluginWithDownload(String pluginId, String tag, boolean cancelWhenDispose) {
        return this.activePluginWithDownload(pluginId, 1, tag, cancelWhenDispose);
    }

    public Flowable<Boolean> activePlugin(String pluginId, String tag, boolean cancelActiveWhenDispose) {
        return Flowable.just((Object)true);
    }

    public boolean isPluginActive(String pluginId) {
        return true;
    }

    public boolean isPluginActiving(String pluginId) {
        return null != this.mActivePluginReqs && this.mActivePluginReqs.containsKey(pluginId);
    }

    private boolean hasActiveListener(String pluginId, String key) {
        return null != this.mPluginActiveListeners && this.mPluginActiveListeners.containsKey(this.getListenerTag(pluginId, key));
    }

    private void addActiveReq(String pluginId, Object req) {
        if (null == this.mActivePluginReqs) {
            this.mActivePluginReqs = new ConcurrentHashMap<String, Object>();
        }
        this.mActivePluginReqs.put(pluginId, req);
    }

    private void removeActiveReq(String pluginId) {
        MLog.info((Object)TAG, (String)("removeActiveReq->pluginId:" + pluginId), (Object[])new Object[0]);
        if (null == this.mActivePluginReqs) {
            return;
        }
        this.mActivePluginReqs.remove(pluginId);
    }

    private void addActiveListener(String pluginId, String key, Small.OnSetupListener listener) {
        if (null == this.mPluginActiveListeners) {
            this.mPluginActiveListeners = new ConcurrentHashMap<String, Small.OnSetupListener>();
        }
        this.mPluginActiveListeners.put(this.getListenerTag(pluginId, key), listener);
    }

    private void removeActiveListener(String pluginId, String key) {
        MLog.info((Object)TAG, (String)("removeActiveListener->pluginId:" + pluginId + ",key:" + key), (Object[])new Object[0]);
        if (null == this.mPluginActiveListeners) {
            return;
        }
        this.mPluginActiveListeners.remove(this.getListenerTag(pluginId, key));
    }

    private void onActiveComplete(String pluginId, Small.SetupResult result) {
        MLog.info((Object)TAG, (String)("onActiveComplete->pluginId:" + pluginId), (Object[])new Object[0]);
        this.removeActiveReq(pluginId);
        if (FP.empty(this.mPluginActiveListeners)) {
            return;
        }
        Iterator<String> iterator = this.mPluginActiveListeners.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!key.startsWith(pluginId + "_")) continue;
            Small.OnSetupListener listener = this.mPluginActiveListeners.get(key);
            if (null != listener) {
                listener.onSetup(result);
            }
            iterator.remove();
        }
    }

    public boolean cancelActivePlugin(String pluginId) {
        MLog.info((Object)TAG, (String)("cancelActivePlugin->pluginId:" + pluginId), (Object[])new Object[0]);
        if (null == this.mActivePluginReqs) {
            return false;
        }
        boolean result = false;
        return result;
    }
}

