/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.ent.protos;

import android.annotation.SuppressLint;
import android.content.Context;
import com.unionyy.mobile.meipai.api.YY2MPInfoAction;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.guid.GuidFactory;
import com.yy.mobile.model.store.HostState;
import com.yy.mobile.model.store.HostStore;
import com.yy.mobile.replugin.ApiBridge;
import com.yy.mobile.util.AppMetaDataUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.TelephonyUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyprotocol.core.ByteString;
import com.yy.mobile.yyprotocol.core.ByteStringable;
import com.yy.mobile.yyprotocol.core.MarshalContainer;
import com.yy.mobile.yyprotocol.core.Marshallable;
import com.yy.mobile.yyprotocol.core.Pack;
import com.yy.mobile.yyprotocol.core.Uint16;
import com.yy.mobile.yyprotocol.core.UnmarshalContainer;
import com.yy.mobile.yyprotocol.core.Unpack;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PMobcli {
    private static final String TAG = "PMobcli";
    public static final int MAX_TYPE_START = 20000;
    public static final String CONTENT_TYPE_PROTOBUF = "protobuf";

    public static class MobPacket
    implements ByteStringable {
        public MobHead head = new MobHead();
        public byte[] data = new byte[0];

        public void toString(ByteString bs) {
            Pack pack = new Pack();
            this.head.marshall(pack);
            pack.push(this.data);
            bs.setBytes(pack.toBytes());
        }

        public void unString(ByteString bs) {
            byte[] bytes = bs.getBytes();
            Unpack unpack = new Unpack(bytes);
            this.head.unmarshall(unpack);
            this.data = unpack.popBytes();
            if (this.data.length == 0 && unpack.size() > 0) {
                try {
                    this.data = unpack.popBytesUint32();
                }
                catch (Throwable e2) {
                    String msg = "popBytesUint32 error, uri=" + this.head.maxType.intValue() + "." + this.head.minType.intValue() + " ,fullPacket=" + Arrays.toString(bytes);
                    MLog.error((Object)PMobcli.TAG, (String)msg, (Object[])new Object[0]);
                    throw new RuntimeException(msg, e2);
                }
            }
        }
    }

    @SuppressLint(value={"UseSparseArrays"})
    public static class MobHead
    implements Marshallable {
        public static final String RECEIVE_TIMEOUT_FALSE_FLAG = "-T";
        public Uint16 maxType = new Uint16(0);
        public Uint16 minType = new Uint16(0);
        public Map<Uint16, String> extend = new HashMap<Uint16, String>();

        public void marshall(Pack pack) {
            pack.push(this.maxType).push(this.minType);
            MarshalContainer.marshalMapUint16String((Pack)pack, this.extend);
        }

        public void unmarshall(Unpack up) {
            this.maxType = up.popUint16();
            this.minType = up.popUint16();
            UnmarshalContainer.unmarshalMapUint16String((Unpack)up, this.extend);
        }

        public void setSubCid(long subcid) {
            this.setExtend(KeyEnum.Subcid_Key.getValue(), String.valueOf(subcid));
        }

        public long getSubCid() {
            String result = this.getExtend(KeyEnum.Subcid_Key.getValue());
            long subcid = 0L;
            try {
                subcid = Long.valueOf(result);
            }
            catch (Exception e2) {
                subcid = 0L;
            }
            return subcid;
        }

        public void setPlatformAndroid() {
            this.setExtend(KeyEnum.Platform_Key.getValue(), PlatformEnum.Android_Platform.getValue());
        }

        public void setDevicesId() {
            this.setExtend(KeyEnum.Deviceid_Key.getValue(), GuidFactory.getInstance().getGuid());
        }

        public void setPlatformIphone() {
            this.setExtend(KeyEnum.Platform_Key.getValue(), PlatformEnum.IPhone_Platform.getValue());
        }

        public void setPlatformWinphone() {
            this.setExtend(KeyEnum.Platform_Key.getValue(), PlatformEnum.WPhone_Platform.getValue());
        }

        public PlatformEnum getPlatform() {
            int pf = 0;
            String result = this.getExtend(KeyEnum.Platform_Key.getValue());
            try {
                pf = Integer.valueOf(result);
            }
            catch (Exception e2) {
                pf = 0;
            }
            return PlatformEnum.getPlatformEnum(pf);
        }

        public String getDevicesId() {
            String result = this.getExtend(KeyEnum.Deviceid_Key.getValue());
            return result;
        }

        public void setProtobufContentType() {
            this.setExtend(KeyEnum.Tag_ContentType_key.getValue(), PMobcli.CONTENT_TYPE_PROTOBUF);
        }

        public String getContentType() {
            return this.getExtend(KeyEnum.Tag_ContentType_key.getValue());
        }

        public void setTestEnvIpPort(String ip, int port) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ip);
            stringBuilder.append(":");
            stringBuilder.append(port);
            this.setExtend(KeyEnum.TestEnv_ToIpPort_Key.getValue(), stringBuilder.toString());
        }

        public void setTestEnvNameGroup(String name, int group) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(name);
            stringBuilder.append(":");
            stringBuilder.append(group);
            this.setExtend(KeyEnum.TestEnv_ToNameGroup_Key.getValue(), stringBuilder.toString());
        }

        public void setAnchorUid(long anchorU) {
            this.setExtend(KeyEnum.Tag_Anchor_uid.getValue(), String.valueOf(anchorU));
        }

        public long getAnchorUid() {
            String result = this.getExtend(KeyEnum.Tag_Anchor_uid.getValue());
            return StringUtils.safeParseLong((String)result);
        }

        public void setPTS(long pts) {
            this.setExtend(KeyEnum.Tag_Pts.getValue(), String.valueOf(pts));
        }

        public long getPTS() {
            String result = this.getExtend(KeyEnum.Tag_Pts.getValue());
            return StringUtils.safeParseLong((String)result);
        }

        public void setExtend(int key, String value) {
            this.extend.put(new Uint16(key), value);
        }

        public void setExtend(int key, int value) {
            this.setExtend(key, String.valueOf(value));
        }

        public String getExtend(int key) {
            return this.extend.get(new Uint16(key));
        }

        public void setAppData() {
            String context = UUID.randomUUID().toString();
            this.setExtend(KeyEnum.AppData_Key.getValue(), String.valueOf(context));
        }

        public void setAppData(boolean receiveTimeout) {
            StringBuilder sb = new StringBuilder(UUID.randomUUID().toString());
            if (!receiveTimeout) {
                sb.append(RECEIVE_TIMEOUT_FALSE_FLAG);
            }
            this.setExtend(KeyEnum.AppData_Key.getValue(), sb.toString());
        }

        public boolean isReceiveTimeout() {
            String appdata = this.getAppData();
            return !appdata.endsWith(RECEIVE_TIMEOUT_FALSE_FLAG);
        }

        public String getAppData() {
            return this.getExtend(KeyEnum.AppData_Key.getValue());
        }

        public long getAppDataLong() {
            try {
                return Long.parseLong(this.getExtend(KeyEnum.AppData_Key.getValue()));
            }
            catch (NumberFormatException e2) {
                return 0L;
            }
        }

        public void setVersion() {
            String version = VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext()).getVersionNameWithoutSnapshot();
            this.setExtend(KeyEnum.Version_Key.getValue(), version);
        }

        public String getVersion() {
            return this.getExtend(KeyEnum.Version_Key.getValue());
        }

        public void setChannel() {
            String channel = AppMetaDataUtil.getChannelID((Context)BasicConfig.getInstance().getAppContext());
            this.setExtend(KeyEnum.Channel_Key.getValue(), channel);
        }

        public String getChannel() {
            return this.getExtend(KeyEnum.Channel_Key.getValue());
        }

        public void setHdid() {
            IHiidoStatisticCore core = ICoreManagerBase.getCore(IHiidoStatisticCore.class);
            if (core != null) {
                this.setExtend(KeyEnum.Hdid_Key.getValue(), core.getHdid());
            }
        }

        public String getHdid() {
            return this.getExtend(KeyEnum.Hdid_Key.getValue());
        }

        public void setAppId() {
            this.setExtend(KeyEnum.AppID_Key.getValue(), ((HostState)HostStore.INSTANCE.getState()).getAppId());
        }

        public String getAppId() {
            return this.getExtend(KeyEnum.AppID_Key.getValue());
        }

        public void setMPClientId() {
            YY2MPInfoAction action2 = (YY2MPInfoAction)ApiBridge.INSTANCE.getApi(YY2MPInfoAction.class);
            if (action2 != null) {
                this.setExtend(KeyEnum.MP_ClientId.getValue(), action2.getMPInfo().getClientId());
            }
        }

        public String getMPClientId() {
            return this.getExtend(KeyEnum.MP_ClientId.getValue());
        }

        public void setMPDeviceId() {
            this.setExtend(KeyEnum.MP_DeviceId.getValue(), TelephonyUtils.getImei((Context)BasicConfig.getInstance().getAppContext()));
        }

        public String getMPDeviceId() {
            return this.getExtend(KeyEnum.MP_DeviceId.getValue());
        }

        public void setMPVersion() {
            YY2MPInfoAction action2 = (YY2MPInfoAction)ApiBridge.INSTANCE.getApi(YY2MPInfoAction.class);
            if (action2 != null) {
                this.setExtend(KeyEnum.MP_Version.getValue(), action2.getMPInfo().getMpVersion());
            }
        }

        public String getMPVersion() {
            return this.getExtend(KeyEnum.MP_Version.getValue());
        }

        public void setTraceId(String traceId) {
            this.setExtend(KeyEnum.Traceid_Key.getValue(), traceId);
        }

        public String getTraceId() {
            return this.getExtend(KeyEnum.Traceid_Key.getValue());
        }

        public static enum PlatformEnum {
            Invalid_Platform,
            Android_Platform,
            IPhone_Platform,
            WPhone_Platform;


            public int getValue() {
                return this.ordinal();
            }

            public static PlatformEnum getPlatformEnum(int value) {
                if (value < 0) {
                    value = 0;
                } else if (value >= PlatformEnum.values().length) {
                    value = PlatformEnum.values().length - 1;
                }
                return PlatformEnum.values()[value];
            }
        }

        public static enum KeyEnum {
            Invalid_Key(0),
            Subcid_Key(1),
            Platform_Key(2),
            Deviceid_Key(3),
            LoginType_Key(4),
            AppData_Key(5),
            Version_Key(6),
            Tag_MobileActName_key(7),
            Tag_MobileAct_id(8),
            Tag_MobileJsonp_key(9),
            Tag_ContentType_key(10),
            Tag_Anchor_uid(20),
            Tag_Pts(21),
            TestEnv_ToIpPort_Key(60001),
            TestEnv_ToNameGroup_Key(60003),
            Hdid_Key(65011),
            Channel_Key(65013),
            AppID_Key(65012),
            MP_ClientId(1000),
            MP_DeviceId(1001),
            MP_Version(1002),
            Traceid_Key(25);

            private int v = 0;

            private KeyEnum(int value) {
                this.v = value;
            }

            public int getValue() {
                return this.v;
            }
        }
    }
}

