/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.dialog;

import android.app.Dialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import com.yy.mobile.ui.widget.dialog.ButtonItem;
import com.yymobile.baseapi.R;
import java.util.List;

public class CommonPopupDialog
extends Dialog
implements View.OnClickListener {
    private static final int BUTTON_ITEM_ID = 135798642;
    private int mId;
    private ViewGroup mRootView;
    protected ViewGroup mContentView;
    private TextView mMessageTv;
    protected TextView mCancelBtn;

    public CommonPopupDialog(Context context, String title, List<ButtonItem> buttons, String cancelBtnText) {
        this(0, context, title, buttons, new ButtonItem(cancelBtnText, null));
    }

    public CommonPopupDialog(Context context, String title, List<ButtonItem> buttons, ButtonItem bottomButton) {
        this(0, context, title, buttons, bottomButton);
    }

    public CommonPopupDialog(int id2, Context context, String title, List<ButtonItem> buttons, final ButtonItem bottomButton) {
        super(context, R.style.Dialog_Fullscreen);
        this.mId = id2;
        this.mRootView = (ViewGroup)View.inflate((Context)this.getContext(), (int)this.getLayoutResId(), null);
        this.mContentView = (ViewGroup)this.mRootView.findViewById(R.id.ll_more);
        this.mMessageTv = (TextView)this.mRootView.findViewById(R.id.tv_message);
        this.mCancelBtn = (TextView)this.mRootView.findViewById(R.id.btn_cancel);
        this.mCancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (bottomButton != null && bottomButton.mClickListener != null) {
                    bottomButton.mClickListener.onClick();
                }
                CommonPopupDialog.this.dismiss();
            }
        });
        this.setContentView((View)this.mRootView);
        Window window = this.getWindow();
        WindowManager.LayoutParams params = window.getAttributes();
        params.height = -2;
        window.setGravity(80);
        window.setAttributes(params);
        window.setWindowAnimations(R.style.DialogAnimation);
        if (buttons != null && buttons.size() > 0) {
            if (title != null && !title.isEmpty()) {
                this.setMessage(title);
            }
            this.mContentView.setVisibility(0);
            for (int i2 = 0; i2 < buttons.size(); ++i2) {
                if (i2 == 0) {
                    if (title != null && !title.isEmpty()) {
                        this.addDivider();
                    }
                } else {
                    this.addDivider();
                }
                this.addItem(buttons.get(i2));
            }
        }
        if (bottomButton != null && bottomButton.mText != null && !bottomButton.mText.isEmpty()) {
            this.mCancelBtn.setVisibility(0);
            this.mCancelBtn.setText((CharSequence)bottomButton.mText);
        }
    }

    protected int getLayoutResId() {
        return R.layout.layout_common_popup_dialog;
    }

    public void setMessage(String text) {
        this.mMessageTv.setVisibility(0);
        this.mMessageTv.setText((CharSequence)text);
    }

    public TextView getmMessageTv() {
        return this.mMessageTv;
    }

    public void addItem(final ButtonItem buttonItem) {
        if (buttonItem == null) {
            return;
        }
        TextView item = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(buttonItem.resourceID, this.mContentView, false);
        item.setText((CharSequence)buttonItem.mText);
        item.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (buttonItem.mClickListener != null) {
                    buttonItem.mClickListener.onClick();
                }
                CommonPopupDialog.this.dismiss();
            }
        });
        item.setId(135798642 + this.mContentView.getChildCount());
        this.mContentView.addView((View)item, this.mContentView.getChildCount());
        this.initItem(item);
    }

    protected void initItem(TextView textView) {
    }

    public void addDivider() {
        View v2 = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_common_popup_dialog_divider, this.mContentView, false);
        v2.setVisibility(0);
        this.mContentView.addView(v2, this.mContentView.getChildCount());
    }

    public int getId() {
        return this.mId;
    }

    public void onClick(View v) {
    }
}

