/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.pay;

import android.content.Context;
import android.os.Looper;
import android.os.Message;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.DefaultRequestParam;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.sdkwrapper.login.LoginProtocol;
import com.yy.mobile.ui.pay.QQWalletUtils;
import com.yy.mobile.ui.pay.QqWalletPayBean;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.dialog.ProgressDialog;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.Proxy.ILivePluginProxy;
import java.lang.reflect.Type;

public class QQWalletPayManager {
    public static final String TAG = "QQWalletPayManager";
    private final int qqWalletPayMessage = 1;
    private DialogLinkManager mDialogManager;
    private String chargeInfo = "";
    private Context context;
    private SafeDispatchHandler handler = new SafeDispatchHandler(Looper.getMainLooper()){

        public void dispatchMessage(Message msg) {
            super.dispatchMessage(msg);
            if (msg.what == 1) {
                QQWalletPayManager.this.doQqWalletPay();
            }
        }
    };
    ResponseListener successListener = new ResponseListener<String>(){

        public void onResponse(String response) {
            MLog.info((Object)QQWalletPayManager.TAG, (String)("yyRechargeCenter:" + response), (Object[])new Object[0]);
            QQWalletPayManager.this.parserQwalletPayInfo.setPayInfo(response);
            QQWalletPayManager.this.parserQwalletPayInfo.run();
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    QQWalletPayManager.this.mDialogManager.dismissDialog();
                }
            });
        }
    };
    ResponseErrorListener errorListener = new ResponseErrorListener(){

        public void onErrorResponse(RequestError error) {
            QQWalletPayManager.this.mDialogManager.dismissDialog();
            MLog.info((Object)QQWalletPayManager.TAG, (String)"yyRechargeCenter: qwallet pay error\uff01", (Object[])new Object[0]);
        }
    };
    ParserQwalletPayInfo parserQwalletPayInfo = new ParserQwalletPayInfo("");
    Gson gson = new Gson();
    Type type = new TypeToken<QqWalletPayBean>(){}.getType();
    private QqWalletPayBean qqWalletPayBean;

    public QQWalletPayManager(Context context) {
        this.context = context;
        this.mDialogManager = new DialogLinkManager(context);
    }

    public void onDisponse() {
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
        if (this.parserQwalletPayInfo != null) {
            YYTaskExecutor.removeTask((Runnable)this.parserQwalletPayInfo);
        }
    }

    public void qqWalletPay(int amount) {
        String ret = "false";
        if (ICoreManagerBase.getCore(ILivePluginProxy.class) != null && FP.empty((CharSequence)(ret = ICoreManagerBase.getCore(ILivePluginProxy.class).object2string("cmdIsParentsMode", new Object[0])))) {
            ret = "false";
        }
        if (StringUtils.safeParseBoolean((String)ret)) {
            Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)"\u4f60\u5df2\u5904\u4e8e\u5bb6\u957f\u6a21\u5f0f\uff0c\u65e0\u6cd5\u8fdb\u884c\u5145\u503c", (int)0).show();
            return;
        }
        boolean isSupport = false;
        if (!isSupport) {
            Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)"qq\u4e0d\u652f\u6301\u94b1\u5305\u652f\u4ed8", (int)0).show();
            return;
        }
        this.mDialogManager.showDialog(new ProgressDialog("\u6b63\u5728\u751f\u6210\u652f\u4ed8\u8ba2\u5355\uff0c\u8bf7\u7a0d\u5019", false, false, 0, null));
        StringBuilder qqWalletPayUri = new StringBuilder();
        qqWalletPayUri.append(QQWalletUtils.getQQWalletPayUrl());
        qqWalletPayUri.append("?");
        qqWalletPayUri.append("amount=");
        qqWalletPayUri.append(amount);
        qqWalletPayUri.append("&");
        qqWalletPayUri.append("payMethod=Qq");
        String ticket = "";
        if (LoginUtil.isLogined()) {
            ticket = LoginProtocol.Factory.get().getWebToken();
        }
        qqWalletPayUri.append("&ticket=").append(ticket);
        DefaultRequestParam param = new DefaultRequestParam();
        if (!FP.empty((CharSequence)this.chargeInfo)) {
            param.put("chargeInfo", this.chargeInfo);
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"qqWalletPayUri: %s", (Object[])new Object[]{qqWalletPayUri.toString()});
        }
        RequestManager.instance().submitStringQueryRequest(qqWalletPayUri.toString(), (RequestParam)param, this.successListener, this.errorListener);
    }

    public void setChargeInfo(String chargeInfo) {
        this.chargeInfo = chargeInfo;
    }

    private void doQqWalletPay() {
        if (this.qqWalletPayBean == null) {
            return;
        }
        if (this.qqWalletPayBean.result != 0) {
            Toast.makeText((Context)this.context, (CharSequence)"\u652f\u4ed8\u5f02\u5e38", (int)0).show();
            return;
        }
    }

    private class ParserQwalletPayInfo
    implements Runnable {
        private String payInfo;

        ParserQwalletPayInfo(String payInfo) {
            this.payInfo = payInfo;
        }

        public void setPayInfo(String payInfo) {
            this.payInfo = payInfo;
        }

        @Override
        public void run() {
            try {
                QQWalletPayManager.this.qqWalletPayBean = (QqWalletPayBean)QQWalletPayManager.this.gson.fromJson(this.payInfo, QQWalletPayManager.this.type);
                QQWalletPayManager.this.handler.sendEmptyMessage(1);
            }
            catch (Exception e2) {
                MLog.info((Object)QQWalletPayManager.TAG, (String)"yyRechargeCenter gson parser error!", (Object[])new Object[0]);
            }
        }
    }
}

