/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.subscribe;

import android.support.annotation.Nullable;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.subscribe.ISubscribeClient;
import com.yymobile.core.subscribe.SubscribeClientProxy;
import com.yymobile.core.subscribe.SubscribeInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SubscribeClients {
    private static final String TAG = "SubscribeClient";
    private List<ISubscribeClient> mSubscibeClients = new ArrayList<ISubscribeClient>();
    private Map<ISubscribeClient, SubscribeClientProxy> mProxyMap = new HashMap<ISubscribeClient, SubscribeClientProxy>();

    private SubscribeClients() {
    }

    private static SubscribeClients instance() {
        return SingletonHolder.instance;
    }

    public static void addCallBack(ISubscribeClient subscribeClient) {
        SubscribeClients.addCallBack(subscribeClient, SubscribeClientProxy.class);
    }

    public static void addCallBack(ISubscribeClient subscribeClient, @Nullable Class<SubscribeClientProxy> proxy2) {
        if (subscribeClient == null) {
            return;
        }
        if (proxy2 != null) {
            try {
                Constructor<SubscribeClientProxy> constructor = proxy2.getConstructor(ISubscribeClient.class);
                SubscribeClientProxy p = constructor.newInstance(subscribeClient);
                SubscribeClients.instance().mProxyMap.put(subscribeClient, p);
                SubscribeClients.instance().mSubscibeClients.add(p);
            }
            catch (IllegalAccessException e2) {
                MLog.error((Object)TAG, (Throwable)e2);
            }
            catch (InstantiationException e3) {
                MLog.error((Object)TAG, (Throwable)e3);
            }
            catch (InvocationTargetException e4) {
                MLog.error((Object)TAG, (Throwable)e4);
            }
            catch (NoSuchMethodException e5) {
                MLog.error((Object)TAG, (Throwable)e5);
            }
        } else {
            SubscribeClients.instance().mSubscibeClients.add(subscribeClient);
        }
        MLog.debug((Object)TAG, (String)("add proxyMap(" + SubscribeClients.instance().mProxyMap.size() + ") = " + SubscribeClients.instance().mProxyMap), (Object[])new Object[0]);
        MLog.debug((Object)TAG, (String)("add clientList(" + SubscribeClients.instance().mSubscibeClients.size() + ") = " + SubscribeClients.instance().mSubscibeClients), (Object[])new Object[0]);
    }

    public static void removeCallBack(ISubscribeClient subscribeClient) {
        if (subscribeClient == null) {
            return;
        }
        SubscribeClientProxy proxy2 = SubscribeClients.instance().mProxyMap.get(subscribeClient);
        if (proxy2 != null) {
            SubscribeClients.instance().mProxyMap.remove(subscribeClient);
            SubscribeClients.instance().mSubscibeClients.remove(proxy2);
        } else {
            SubscribeClients.instance().mSubscibeClients.remove(subscribeClient);
        }
        MLog.debug((Object)TAG, (String)("remove proxyMap(" + SubscribeClients.instance().mProxyMap.size() + ") = " + SubscribeClients.instance().mProxyMap), (Object[])new Object[0]);
        MLog.debug((Object)TAG, (String)("remove clientList(" + SubscribeClients.instance().mSubscibeClients.size() + ") = " + SubscribeClients.instance().mSubscibeClients), (Object[])new Object[0]);
    }

    static void onGetSubscribeList(long uid, List<SubscribeInfo> list, boolean isLastPage) {
        MLog.info((Object)TAG, (String)("onGetSubscribeList uid = " + uid + " list = " + list + " isLastPage = " + isLastPage), (Object[])new Object[0]);
        for (ISubscribeClient client : SubscribeClients.instance().mSubscibeClients) {
            client.onGetSubscribeList(uid, list, isLastPage);
        }
    }

    public static void onSubscribeResult(long anchorUid, boolean success, String errorMsg) {
        MLog.info((Object)TAG, (String)("onSubscribeResult anchorUid = " + anchorUid + " success = " + success + " errorMsg = " + errorMsg), (Object[])new Object[0]);
        for (ISubscribeClient client : SubscribeClients.instance().mSubscibeClients) {
            client.onSubscribeResult(anchorUid, success, errorMsg);
        }
    }

    static void onUnSubscribeResult(long anchorUid, boolean success) {
        MLog.info((Object)TAG, (String)("onUnSubscribeResult anchorUid = " + anchorUid + " success = " + success), (Object[])new Object[0]);
        for (ISubscribeClient client : SubscribeClients.instance().mSubscibeClients) {
            client.onUnSubscribeResult(anchorUid, success);
        }
    }

    static void onQuerySubscribeNumResult(long uid, long count) {
        MLog.info((Object)TAG, (String)("onQuerySubscribeNumResult uid = " + uid + " count = " + count), (Object[])new Object[0]);
        for (ISubscribeClient client : SubscribeClients.instance().mSubscibeClients) {
            client.onQuerySubscribeNumResult(uid, count);
        }
    }

    private static class SingletonHolder {
        private static final SubscribeClients instance = new SubscribeClients();

        private SingletonHolder() {
        }
    }
}

