/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.commonweb;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.mobile.spdt.annotation.VIVO;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.activity.MultiWindowViewModel;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.util.DeepColorUtils;
import com.yy.mobile.util.commonweb.WebViewListener;
import com.yy.mobile.util.javascript.ResultData;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.IWebViewEventListener;
import com.yy.mobile.ylink.bridge.coreapi.WebViewFragmentApi;
import com.yymobile.baseapi.R;
import com.yyproto.utils.FP;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class WebPopComponent
extends PopupComponent {
    private static final String TAG = "WebPopComponent";
    private String title;
    private String smallTitle;
    private int titleColor;
    private int smallTitleColor;
    private String url;
    private int width;
    private int height;
    private int gravity;
    private int layoutId;
    private boolean isEnableCloseOutside = true;
    private int titleBarVisibility = 0;
    private boolean isInterceptBackKey;
    private boolean isSupportLandScapeAnim;
    private Map<String, Integer> lpLayoutMap;
    private int iconRes;
    private int helpIconRes;
    private int backIconRes;
    private int refreshIconRes;
    private String backIconWithText;
    private int backIconWithTextColor;
    private int rootViewBackgroundColor = -16777216;
    private float rootViewBackgroundAlpha = -1.0f;
    private int rootViewBackgroundRes;
    private int titleBarColor;
    private int titleBarBgRes;
    private float dimAmount = 0.5f;
    private boolean isLand = false;
    private boolean isShowStatusBar = false;
    private Disposable multiWindowDisposable;
    private static final String LANDSCAPE_WIDTH = "LANDSCAPE_WIDTH";
    private static final String LANDSCAPE_HEIGHT = "LANDSCAPE_HEIGHT";
    private static final String LANDSCAPE_GRAVITY = "LANDSCAPE_GRAVITY";
    private static final String PORTRAIT_WIDTH = "PORTRAIT_WIDTH";
    private static final String PORTRAIT_HEIGHT = "PORTRAIT_HEIGHT";
    private static final String PORTRAIT_GRAVITY = "PORTRAIT_GRAVITY";
    private static final String BUNDLE_TITLE = "BUNDLE_TITLE";
    private static final String BUNDLE_URL = "BUNDLE_URL";
    private static final String BUNDLE_WIDTH = "BUNDLE_WIDTH";
    private static final String BUNDLE_HEIGHT = "BUNDLE_HEIGHT";
    private static final String BUNDLE_GRAVITY = "BUNDLE_GRAVITY";
    private static final String BUNDLE_LAYOUTID = "BUNDLE_LAYOUTID";
    private static final String BUNDLE_ISENABLECLOSEOUTSIDE = "BUNDLE_ISENABLECLOSEOUTSIDE";
    private static final String BUNDLE_TITLEBARVISIBILITY = "BUNDLE_TITLEBARVISIBILITY";
    private static final String BUNDLE_ISINTERCEPTBACKKEY = "BUNDLE_ISINTERCEPTBACKKEY";
    private static final String BUNDLE_ISSUPPORTLANDSCAPEANIM = "BUNDLE_ISSUPPORTLANDSCAPEANIM";
    private IWebViewEventListener webViewEventListener;
    private BaseLinkFragment mFragment;
    private View rootView;
    private RelativeLayout webContent;
    private RelativeLayout titleComponent;
    private LinearLayout backRootView;
    private ImageView backView;
    private ImageView refreshView;
    private ImageView helpView;
    private TextView titleView;
    private TextView smallTitleView;
    private TextView backViewWithTextView;
    private ImageView iconView;
    private CompositeDisposable mCompositeDisposable;
    OnBackClickListener onBackClickListener;
    OnRefreshClickListener onRefreshClickListener;
    OnHelpClickListener onHelpClickListener;
    OnSmallTitleClickListener onSmallTitleClickListener;

    public WebPopComponent setIcon(int iconRes) {
        this.iconRes = iconRes;
        return this;
    }

    public WebPopComponent setBackIconRes(int backIconRes) {
        this.backIconRes = backIconRes;
        return this;
    }

    public WebPopComponent setBackIconWithText(String backIconWithText, int backIconWithTextColor) {
        this.backIconWithText = backIconWithText;
        this.backIconWithTextColor = backIconWithTextColor;
        return this;
    }

    public WebPopComponent setHelpIconRes(int helpIconRes) {
        this.helpIconRes = helpIconRes;
        return this;
    }

    public WebPopComponent setRefreshIconRes(int refreshIconRes) {
        this.refreshIconRes = refreshIconRes;
        return this;
    }

    public WebPopComponent setTitle(String title) {
        this.title = title;
        return this;
    }

    public WebPopComponent setTitleColor(int titleColor) {
        this.titleColor = titleColor;
        return this;
    }

    public WebPopComponent setTitleBarColor(int titleBarColor) {
        this.titleBarColor = titleBarColor;
        return this;
    }

    public WebPopComponent setTitleBarBgRes(int titleBarBgRes) {
        this.titleBarBgRes = titleBarBgRes;
        return this;
    }

    public WebPopComponent setRootViewBackgroundColor(int rootViewBackgroundColor) {
        this.rootViewBackgroundColor = rootViewBackgroundColor;
        return this;
    }

    public WebPopComponent setRootViewBackgroundColor(int webBackgroundColor, @FloatRange(from=0.0, to=1.0) float webBackgroundAlpha) {
        this.rootViewBackgroundColor = webBackgroundColor;
        this.rootViewBackgroundAlpha = webBackgroundAlpha;
        return this;
    }

    public WebPopComponent setRootViewBackgroundRes(int rootViewBackgroundRes) {
        this.rootViewBackgroundRes = rootViewBackgroundRes;
        return this;
    }

    public WebPopComponent setUrl(String url) {
        this.url = url;
        return this;
    }

    public WebPopComponent setCanceledOnTouchOutside(boolean enabled) {
        this.isEnableCloseOutside = enabled;
        return this;
    }

    public WebPopComponent setTitleBarVisibility(int visibility) {
        this.titleBarVisibility = visibility;
        return this;
    }

    public WebPopComponent setInterceptBackKey(boolean intercept) {
        this.isInterceptBackKey = intercept;
        return this;
    }

    public WebPopComponent isSupportLandScapeAnim() {
        this.isSupportLandScapeAnim = true;
        return this;
    }

    public WebPopComponent setDimAmount(@FloatRange(from=0.0, to=1.0) float dimAmount) {
        this.dimAmount = dimAmount;
        return this;
    }

    public WebPopComponent setLandscapeLayout(int width, int height, int gravity) {
        if (this.lpLayoutMap == null) {
            this.lpLayoutMap = new HashMap<String, Integer>();
        }
        this.lpLayoutMap.put(LANDSCAPE_WIDTH, width);
        this.lpLayoutMap.put(LANDSCAPE_HEIGHT, height);
        this.lpLayoutMap.put(LANDSCAPE_GRAVITY, gravity);
        return this;
    }

    public WebPopComponent setPortraitLayout(int width, int height, int gravity) {
        if (this.lpLayoutMap == null) {
            this.lpLayoutMap = new HashMap<String, Integer>();
        }
        this.lpLayoutMap.put(PORTRAIT_WIDTH, width);
        this.lpLayoutMap.put(PORTRAIT_HEIGHT, height);
        this.lpLayoutMap.put(PORTRAIT_GRAVITY, gravity);
        return this;
    }

    public WebPopComponent setShowStatusBar(boolean isShowStatusBar) {
        this.isShowStatusBar = isShowStatusBar;
        return this;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16974065);
        this.mCompositeDisposable = new CompositeDisposable();
        if (savedInstanceState != null) {
            this.title = savedInstanceState.getString(BUNDLE_TITLE);
            this.url = savedInstanceState.getString(BUNDLE_URL);
            this.width = savedInstanceState.getInt(BUNDLE_WIDTH);
            this.height = savedInstanceState.getInt(BUNDLE_HEIGHT);
            this.gravity = savedInstanceState.getInt(BUNDLE_GRAVITY);
            this.layoutId = savedInstanceState.getInt(BUNDLE_LAYOUTID);
            this.isEnableCloseOutside = savedInstanceState.getBoolean(BUNDLE_ISENABLECLOSEOUTSIDE, true);
            this.titleBarVisibility = savedInstanceState.getInt(BUNDLE_TITLEBARVISIBILITY, 0);
            this.isInterceptBackKey = savedInstanceState.getBoolean(BUNDLE_ISINTERCEPTBACKKEY, false);
            this.isSupportLandScapeAnim = savedInstanceState.getBoolean(BUNDLE_ISSUPPORTLANDSCAPEANIM, false);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Bundle bundle = new Bundle();
        bundle.putString(BUNDLE_TITLE, this.title);
        bundle.putString(BUNDLE_URL, this.url);
        bundle.putInt(BUNDLE_WIDTH, this.width);
        bundle.putInt(BUNDLE_HEIGHT, this.height);
        bundle.putInt(BUNDLE_GRAVITY, this.gravity);
        bundle.putInt(BUNDLE_LAYOUTID, this.layoutId);
        bundle.putBoolean(BUNDLE_ISENABLECLOSEOUTSIDE, this.isEnableCloseOutside);
        bundle.putInt(BUNDLE_TITLEBARVISIBILITY, this.titleBarVisibility);
        bundle.putBoolean(BUNDLE_ISINTERCEPTBACKKEY, this.isInterceptBackKey);
        bundle.putBoolean(BUNDLE_ISSUPPORTLANDSCAPEANIM, this.isSupportLandScapeAnim);
        outState.putAll(bundle);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setBackgroundDrawableResource(17170445);
        dialog.setCanceledOnTouchOutside(this.isEnableCloseOutside);
        dialog.getWindow().setWindowAnimations(R.style.DialogAnimation);
        this.isLand = this.isLandScape();
        if (this.lpLayoutMap != null) {
            if (this.isLandScape()) {
                if (this.lpLayoutMap.containsKey(LANDSCAPE_WIDTH)) {
                    this.width = this.lpLayoutMap.get(LANDSCAPE_WIDTH);
                }
                if (this.lpLayoutMap.containsKey(LANDSCAPE_HEIGHT)) {
                    this.height = this.lpLayoutMap.get(LANDSCAPE_HEIGHT);
                }
                if (this.lpLayoutMap.containsKey(LANDSCAPE_GRAVITY)) {
                    this.gravity = this.lpLayoutMap.get(LANDSCAPE_GRAVITY);
                }
            } else {
                if (this.lpLayoutMap.containsKey(PORTRAIT_WIDTH)) {
                    this.width = this.lpLayoutMap.get(PORTRAIT_WIDTH);
                }
                if (this.lpLayoutMap.containsKey(PORTRAIT_HEIGHT)) {
                    this.height = this.lpLayoutMap.get(PORTRAIT_HEIGHT);
                }
                if (this.lpLayoutMap.containsKey(PORTRAIT_GRAVITY)) {
                    this.gravity = this.lpLayoutMap.get(PORTRAIT_GRAVITY);
                }
            }
        }
        if (this.width == 0) {
            this.width = -1;
        }
        if (this.height == 0) {
            this.height = -1;
        }
        dialog.getWindow().setGravity(this.gravity != 0 ? this.gravity : 81);
        dialog.getWindow().setLayout(this.width, this.height);
        dialog.getWindow().getDecorView().setPadding(0, 0, 0, 0);
        if (this.dimAmount == 0.0f) {
            dialog.getWindow().clearFlags(2);
        } else {
            WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
            lp.dimAmount = this.dimAmount;
            dialog.getWindow().setAttributes(lp);
            dialog.getWindow().addFlags(2);
        }
        if (this.isShowStatusBar) {
            dialog.getWindow().clearFlags(1280);
        } else {
            dialog.getWindow().addFlags(1280);
        }
        dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    WebView webView = CoreApiManager.getInstance().getApi(WebViewFragmentApi.class).getWebView(WebPopComponent.this.mFragment);
                    if (webView != null && webView.canGoBack()) {
                        webView.goBack();
                        return true;
                    }
                    return WebPopComponent.this.isInterceptBackKey;
                }
                return false;
            }
        });
        return dialog;
    }

    @Override
    public void onOrientationChanged(boolean isLandscape) {
        if (!FP.empty((CharSequence)this.url) && this.url.startsWith("https://web.yy.com/team_battle/") && this.isLand != isLandscape) {
            try {
                this.dismissAllowingStateLoss();
            }
            catch (Exception e2) {
                MLog.error((Object)TAG, (String)("dismiss error:" + e2), (Object[])new Object[0]);
            }
        }
        this.isLand = isLandscape;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.web_popup_component, container, false);
        DeepColorUtils.setNightMode(this.rootView, 0);
        this.backRootView = (LinearLayout)this.rootView.findViewById(R.id.root_back);
        this.backView = (ImageView)this.rootView.findViewById(R.id.back);
        this.backViewWithTextView = (TextView)this.rootView.findViewById(R.id.back_with_text);
        this.refreshView = (ImageView)this.rootView.findViewById(R.id.refresh);
        this.helpView = (ImageView)this.rootView.findViewById(R.id.help);
        this.titleView = (TextView)this.rootView.findViewById(R.id.title);
        this.smallTitleView = (TextView)this.rootView.findViewById(R.id.small_title);
        this.webContent = (RelativeLayout)this.rootView.findViewById(R.id.web_content);
        this.titleComponent = (RelativeLayout)this.rootView.findViewById(R.id.title_component);
        this.iconView = (ImageView)this.rootView.findViewById(R.id.icon);
        if (this.iconRes != 0) {
            this.iconView.setVisibility(0);
            this.iconView.setImageResource(this.iconRes);
        }
        if (!FP.empty((CharSequence)this.backIconWithText)) {
            this.backViewWithTextView.setText((CharSequence)this.backIconWithText);
            this.backViewWithTextView.setTextColor(this.backIconWithTextColor);
        }
        if (this.backIconRes != 0) {
            this.backView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            this.backView.setImageResource(this.backIconRes);
        }
        if (this.titleBarColor != 0) {
            this.titleComponent.setBackgroundColor(this.titleBarColor);
        }
        if (this.titleBarBgRes != 0) {
            this.titleComponent.setBackgroundResource(this.titleBarBgRes);
        }
        if (this.rootViewBackgroundColor != 0) {
            this.rootView.setBackgroundColor(this.rootViewBackgroundColor);
        }
        if (this.rootViewBackgroundAlpha != -1.0f) {
            this.rootView.getBackground().setAlpha((int)(255.0f * this.rootViewBackgroundAlpha));
        }
        if (this.rootViewBackgroundRes != 0) {
            this.rootView.setBackgroundResource(this.rootViewBackgroundRes);
        }
        if (this.helpIconRes != 0) {
            this.helpView.setImageResource(this.helpIconRes);
        }
        if (this.refreshIconRes != 0) {
            this.refreshView.setImageResource(this.refreshIconRes);
        }
        this.mFragment = this.getOrCreatWebViewFragment(this.url);
        FragmentTransaction ft = this.getContent().getChildFragmentManager().beginTransaction();
        if (this.mFragment.isDetached()) {
            ft.attach((Fragment)this.mFragment);
            ft.commitAllowingStateLoss();
        } else if (!this.mFragment.isAdded()) {
            ft.add(R.id.web_content, (Fragment)this.mFragment);
            ft.commitAllowingStateLoss();
        }
        if (this.titleColor != 0) {
            this.titleView.setTextColor(this.titleColor);
        }
        this.titleComponent.setVisibility(this.titleBarVisibility);
        this.titleView.setText((CharSequence)this.title);
        this.initBackListener();
        this.initRefreshListener();
        this.initHelpListener();
        this.initSmallTitleListener();
        return this.rootView;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (Spdt.currentFlavor() instanceof VIVO && this.getActivity() != null) {
            MultiWindowViewModel multiWindowViewModel = MultiWindowViewModel.get(this.getActivity());
            this.multiWindowDisposable = multiWindowViewModel.registerV2().subscribe((Consumer)new Consumer<MultiWindowViewModel.MultiWindowChangeInfo>(){

                public void accept(MultiWindowViewModel.MultiWindowChangeInfo multiWindowChangeInfo) throws Exception {
                    if (multiWindowChangeInfo.getMultiWindowStatus()) {
                        WebPopComponent.this.hideSelf();
                    }
                }
            });
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mCompositeDisposable.clear();
        if (this.multiWindowDisposable != null) {
            this.multiWindowDisposable.dispose();
        }
    }

    private void initBackListener() {
        if (this.onBackClickListener != null) {
            this.backRootView.setVisibility(0);
            this.mCompositeDisposable.add(WebPopComponent.clicks((View)this.backRootView, 500L).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    if (WebPopComponent.this.onBackClickListener != null && WebPopComponent.this.getActivity() != null) {
                        WebPopComponent.this.onBackClickListener.onBackClick();
                        WebPopComponent.this.dismissAllowingStateLoss();
                    }
                }
            }));
        }
    }

    private void initRefreshListener() {
        if (this.onRefreshClickListener != null) {
            this.refreshView.setVisibility(0);
            this.mCompositeDisposable.add(WebPopComponent.clicks((View)this.refreshView, 500L).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object view) throws Exception {
                    if (WebPopComponent.this.onRefreshClickListener != null && WebPopComponent.this.getActivity() != null) {
                        WebPopComponent.this.onRefreshClickListener.onRefreshClick();
                        WebPopComponent.this.getWebView().reload();
                    }
                }
            }));
        }
    }

    private void initHelpListener() {
        if (this.onHelpClickListener != null) {
            this.helpView.setVisibility(0);
            this.mCompositeDisposable.add(WebPopComponent.clicks((View)this.helpView, 500L).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    if (WebPopComponent.this.onHelpClickListener != null && WebPopComponent.this.getActivity() != null) {
                        WebPopComponent.this.onHelpClickListener.onHelpClick();
                    }
                }
            }));
        }
    }

    private void initSmallTitleListener() {
        if (this.onSmallTitleClickListener != null) {
            this.smallTitleView.setVisibility(0);
            this.smallTitleView.setText((CharSequence)this.smallTitle);
            this.smallTitleView.setTextColor(this.smallTitleColor);
            this.mCompositeDisposable.add(WebPopComponent.clicks((View)this.smallTitleView, 500L).subscribe((Consumer)new Consumer<Object>(){

                public void accept(Object o) throws Exception {
                    if (WebPopComponent.this.onSmallTitleClickListener != null && WebPopComponent.this.getActivity() != null) {
                        WebPopComponent.this.onSmallTitleClickListener.onSmallTitleClick();
                    }
                }
            }));
        }
    }

    private BaseLinkFragment getOrCreatWebViewFragment(String url) {
        if (this.webViewEventListener == null) {
            this.webViewEventListener = new WebViewListener(){

                @Override
                public void onReceivedTitle(WebView view, String title) {
                    super.onReceivedTitle(view, title);
                    if (title != null && !title.contains("http")) {
                        WebPopComponent.this.setTitleTextView(title);
                    }
                }

                @Override
                public String invokeFromWebPage(String moduleName, String methodName, String param, final IApiModule.IJSCallback ijsCallback, Context context) {
                    MLog.info((Object)WebPopComponent.TAG, (String)(moduleName + "," + methodName + "," + param), (Object[])new Object[0]);
                    if (moduleName.equals("ui") && methodName.equals("closeHalfWindow")) {
                        final ResultData resultData = new ResultData();
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                WebPopComponent.this.hide();
                                if (ijsCallback != null) {
                                    ijsCallback.invokeCallback("'" + JsonParser.toJson((Object)resultData) + "'");
                                }
                            }
                        });
                        return JsonParser.toJson((Object)resultData);
                    }
                    return "";
                }
            };
        }
        BaseLinkFragment wvFragment = CoreApiManager.getInstance().getApi(WebViewFragmentApi.class).createWebViewFragment(url, true, this.webViewEventListener, false);
        return wvFragment;
    }

    private void setTitleTextView(String title) {
        if (this.titleView != null && FP.empty((CharSequence)this.title)) {
            this.titleView.setText((CharSequence)title);
        }
    }

    private WebView getWebView() {
        if (this.mFragment != null) {
            return CoreApiManager.getInstance().getApi(WebViewFragmentApi.class).getWebView(this.mFragment);
        }
        return null;
    }

    public WebPopComponent setOnRefreshClickListener(OnRefreshClickListener onRefreshClickListener) {
        this.onRefreshClickListener = onRefreshClickListener;
        return this;
    }

    public WebPopComponent setOnBackClickListener(OnBackClickListener rootViewFinish) {
        this.onBackClickListener = rootViewFinish;
        return this;
    }

    public WebPopComponent setOnHelpClickListener(OnHelpClickListener onHelpClickListener) {
        this.onHelpClickListener = onHelpClickListener;
        return this;
    }

    public WebPopComponent setOnSmallTitleClickListener(String smallTitle, OnSmallTitleClickListener onSmallTitleClickListener) {
        this.setOnSmallTitleClickListener(smallTitle, Color.parseColor((String)"#FFDD00"), onSmallTitleClickListener);
        return this;
    }

    public WebPopComponent setOnSmallTitleClickListener(String smallTitle, int smallTitleColor, OnSmallTitleClickListener onSmallTitleClickListener) {
        this.smallTitle = smallTitle;
        this.smallTitleColor = smallTitleColor;
        this.onSmallTitleClickListener = onSmallTitleClickListener;
        return this;
    }

    private boolean isLandScape() {
        if (this.getActivity() != null) {
            return this.getActivity().getResources().getConfiguration().orientation == 2;
        }
        return false;
    }

    private static Observable<Object> clicks(final View view, long millseconds) {
        final ViewClicksObservableOnSubscrib viewClicksObservable = new ViewClicksObservableOnSubscrib();
        if (view != null) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ObservableEmitter<Object> emitter = viewClicksObservable.getEmitter();
                    if (emitter != null && !emitter.isDisposed()) {
                        emitter.onNext((Object)1);
                    }
                }
            });
        }
        return Observable.create((ObservableOnSubscribe)viewClicksObservable).doOnDispose(new Action(){

            public void run() throws Exception {
                if (view != null) {
                    view.setOnClickListener(null);
                }
            }
        }).throttleFirst(millseconds, TimeUnit.MILLISECONDS);
    }

    static class ViewClicksObservableOnSubscrib
    implements ObservableOnSubscribe<Object> {
        ObservableEmitter<Object> emitter;

        ViewClicksObservableOnSubscrib() {
        }

        public ObservableEmitter<Object> getEmitter() {
            return this.emitter;
        }

        public void subscribe(ObservableEmitter<Object> e2) throws Exception {
            this.emitter = e2;
        }
    }

    public static interface OnSmallTitleClickListener {
        public void onSmallTitleClick();
    }

    public static interface OnHelpClickListener {
        public void onHelpClick();
    }

    public static interface OnRefreshClickListener {
        public void onRefreshClick();
    }

    public static interface OnBackClickListener {
        public void onBackClick();
    }
}

