/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.engine.cache.DiskLruCacheWrapper;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.signature.EmptySignature;
import java.io.File;
import java.security.MessageDigest;
import java.util.concurrent.ExecutionException;

public final class GlideUtil {
    public static <T> void loadImage(T context, String url, ImageView imageView) {
        GlideUtil.loadImage(context, url, imageView, 0, null);
    }

    public static <T> void loadCircleImage(Context context, ImageView imageView, T imagePath) {
        if (context == null || imagePath == null) {
            return;
        }
        Glide.with((Context)context).load(imagePath).apply((BaseRequestOptions)RequestOptions.circleCropTransform()).transition((TransitionOptions)new DrawableTransitionOptions().crossFade(200)).into(imageView);
    }

    public static <T> void loadImage(T context, String url, ImageView imageView, int defaultResId) {
        GlideUtil.loadImage(context, url, imageView, defaultResId, null);
    }

    public static <T> void loadImage(T context, String url, ImageView imageView, RequestListener<Drawable> loadingListener) {
        GlideUtil.loadImage(context, url, imageView, 0, loadingListener);
    }

    public static <T> void loadImage(T context, String url, ImageView imageView, int defaultResId, RequestListener<Drawable> loadingListener) {
        GlideUtil.loadImage(context, url, imageView, 0, defaultResId, loadingListener);
    }

    public static <T> void loadImage(T context, String url, SimpleTarget<Drawable> loadingListener) {
        GlideUtil.loadImage(context, url, null, loadingListener);
    }

    public static <T> void loadImage(T context, String url, RequestOptions options, SimpleTarget<Drawable> loadingListener) {
        RequestManager requestManager = GlideUtil.getRequestManager(context);
        if (requestManager == null) {
            return;
        }
        RequestBuilder requestBuilder = requestManager.load(url);
        if (options != null) {
            requestBuilder = requestBuilder.apply((BaseRequestOptions)options);
        }
        requestBuilder.into(loadingListener);
    }

    public static <T> Drawable synLoadSdCardImage(T context, String url) {
        RequestManager requestManager = GlideUtil.getRequestManager(context);
        if (requestManager == null) {
            return null;
        }
        try {
            return (Drawable)requestManager.load(new File(url)).apply((BaseRequestOptions)RequestOptions.diskCacheStrategyOf((DiskCacheStrategy)DiskCacheStrategy.NONE)).submit().get();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        catch (ExecutionException e3) {
            e3.printStackTrace();
        }
        return null;
    }

    public static <T> void loadImageWithCorner(T context, String url, ImageView imageView, int corner, int defaultResId) {
        GlideUtil.loadImageWithCorner(context, url, imageView, corner, defaultResId, null);
    }

    public static <T> void loadImageWithCorner(T context, String url, ImageView imageView, int corner, int defaultResId, RequestListener<Drawable> loadingListener) {
        GlideUtil.loadImage(context, url, imageView, corner, defaultResId, loadingListener);
    }

    public static <T> void loadImage(T context, String url, ImageView imageView, RequestOptions options) {
        GlideUtil.getRequestManager(context).load(url).apply((BaseRequestOptions)options).into(imageView);
    }

    private static <T> void loadImage(T context, String url, ImageView imageView, int corner, int defaultResId, RequestListener<Drawable> loadingListener) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        RequestManager requestManager = GlideUtil.getRequestManager(context);
        if (requestManager == null) {
            return;
        }
        RequestBuilder requestBuilder = requestManager.load(url);
        RequestOptions options = defaultResId > 0 ? (RequestOptions)RequestOptions.errorOf((int)defaultResId).placeholder(defaultResId) : new RequestOptions();
        if (corner > 0) {
            options = (RequestOptions)((RequestOptions)options.format(DecodeFormat.PREFER_RGB_565)).optionalTransform((Transformation)new RoundedCorners(corner));
        }
        requestBuilder = requestBuilder.apply((BaseRequestOptions)options);
        if (loadingListener != null) {
            requestBuilder = requestBuilder.listener(loadingListener);
        }
        requestBuilder.into(imageView);
    }

    private static <T> RequestManager getRequestManager(T context) {
        try {
            if (context instanceof android.support.v4.app.Fragment) {
                return Glide.with((android.support.v4.app.Fragment)((android.support.v4.app.Fragment)context));
            }
            if (context instanceof Fragment) {
                return Glide.with((Fragment)((Fragment)context));
            }
            if (context instanceof FragmentActivity) {
                return Glide.with((FragmentActivity)((FragmentActivity)context));
            }
            if (context instanceof Activity) {
                return Glide.with((Activity)((Activity)context));
            }
            if (context instanceof View) {
                return Glide.with((View)((View)context));
            }
            if (context instanceof Context) {
                return Glide.with((Context)((Context)context));
            }
            throw new IllegalArgumentException("context must be instanceof Fragment/Activity/view/context");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static <T> void loadGifImage(T context, String uri, ImageView imageView, int defaultResId, boolean isCrossFade) {
        GlideUtil.loadGifImage(context, uri, imageView, defaultResId, isCrossFade, null);
    }

    public static <T> void loadGifImage(T context, String uri, ImageView imageView, int defaultResId, boolean isCrossFade, RequestListener<Drawable> loadingListener) {
        RequestManager requestManager = GlideUtil.getRequestManager(context);
        if (requestManager == null) {
            return;
        }
        RequestBuilder requestBuilder = requestManager.load(uri);
        RequestOptions options = defaultResId > 0 ? (RequestOptions)RequestOptions.errorOf((int)defaultResId).placeholder(defaultResId) : new RequestOptions();
        options = (RequestOptions)options.format(isCrossFade ? DecodeFormat.PREFER_RGB_565 : DecodeFormat.PREFER_ARGB_8888);
        requestBuilder = requestBuilder.apply((BaseRequestOptions)options);
        if (isCrossFade) {
            requestBuilder = requestBuilder.transition((TransitionOptions)DrawableTransitionOptions.withCrossFade());
        }
        if (loadingListener != null) {
            requestBuilder = requestBuilder.listener(loadingListener);
        }
        requestBuilder.into(imageView);
    }

    public static void clearMemoryCache(Context context) {
        Glide.get((Context)context).clearMemory();
    }

    public static <T> void cancelLoadDisplayTask(T context, ImageView imageView) {
        RequestManager requestManager = GlideUtil.getRequestManager(context);
        if (requestManager == null) {
            return;
        }
        requestManager.clear((View)imageView);
    }

    public static <T> void getCacheImageFile(T context, String url, SimpleTarget<File> simpleTarget) {
        RequestManager requestManager = GlideUtil.getRequestManager(context);
        if (requestManager == null) {
            return;
        }
        requestManager.asFile().load(url).apply(new RequestOptions().onlyRetrieveFromCache(true)).into(simpleTarget);
    }

    public static File getCacheImageFile(String url) {
        DataCacheKey dataCacheKey = new DataCacheKey((Key)new GlideUrl(url), (Key)EmptySignature.obtain());
        DiskCache diskCache = DiskLruCacheWrapper.get(null, (long)0L);
        return diskCache.get((Key)dataCacheKey);
    }

    public static <T> void resume(T context) {
        RequestManager requestManager = GlideUtil.getRequestManager(context);
        if (requestManager == null) {
            return;
        }
        requestManager.pauseRequests();
    }

    public static <T> void pause(T context) {
        RequestManager requestManager = GlideUtil.getRequestManager(context);
        if (requestManager == null) {
            return;
        }
        requestManager.pauseRequests();
    }

    static class DataCacheKey
    implements Key {
        private final Key sourceKey;
        private final Key signature;

        public DataCacheKey(Key sourceKey, Key signature) {
            this.sourceKey = sourceKey;
            this.signature = signature;
        }

        public Key getSourceKey() {
            return this.sourceKey;
        }

        public boolean equals(Object o) {
            if (o instanceof DataCacheKey) {
                DataCacheKey other = (DataCacheKey)o;
                return this.sourceKey.equals((Object)other.sourceKey) && this.signature.equals((Object)other.signature);
            }
            return false;
        }

        public int hashCode() {
            int result = this.sourceKey.hashCode();
            result = 31 * result + this.signature.hashCode();
            return result;
        }

        public String toString() {
            return "DataCacheKey{sourceKey=" + this.sourceKey + ", signature=" + this.signature + '}';
        }

        public void updateDiskCacheKey(MessageDigest messageDigest) {
            this.sourceKey.updateDiskCacheKey(messageDigest);
            this.signature.updateDiskCacheKey(messageDigest);
        }
    }
}

