/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmuopengl.gunpower;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.basicgunview.danmuopengl.util.MatrixUtils;
import com.yy.mobile.ui.basicgunview.danmuopengl.util.ShaderUtils;
import com.yy.mobile.ui.basicgunview.danmuopengl.util.TexturePool;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class DanmuItem {
    private int mTextureId = -1;
    private int mProgram;
    private int muMVPMatrixHandle;
    private int maPositionHandle;
    private int maTexCoorHandle;
    private int mAlphaHandle;
    private String mVertexShader;
    private String mFragmentShader;
    private FloatBuffer mVertexBuffer;
    private ShortBuffer mTexCoorBuffer;
    private Bitmap mBitmap;
    private float mAlpha = 1.0f;
    public float offsetX;
    public float offsetY;
    private int mViewWidth;
    private int mViewHeight;
    private int mVertexCount = 4;
    private boolean isInited = false;
    public int bitmapWidth = 0;
    public int bitmapHeight = 0;
    public String content = "";
    public long gunId;
    public String pureText = "";
    public long senderUid;

    public DanmuItem(long gunId, long senderUid, Bitmap bitmap, String content) {
        this.gunId = gunId;
        this.mBitmap = bitmap;
        this.senderUid = senderUid;
        if (this.mBitmap != null) {
            this.bitmapWidth = bitmap.getWidth();
            this.bitmapHeight = bitmap.getHeight();
        }
        if (content != null) {
            this.content = content;
        }
    }

    public boolean init() {
        if (this.mBitmap == null) {
            return false;
        }
        this.initVertexData();
        this.initShader();
        if (!this.initTexture()) {
            return false;
        }
        this.isInited = true;
        return this.isInited;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setShader(String vertexShader, String fragmentShader) {
        this.mVertexShader = vertexShader;
        this.mFragmentShader = fragmentShader;
    }

    public void setViewSize(int width, int height) {
        this.mViewWidth = width;
        this.mViewHeight = height;
    }

    public void setAlpha(float alpha) {
        if (this.mAlphaHandle != -1 && this.mAlpha != alpha) {
            this.mAlpha = alpha;
        }
    }

    public void setOffsetY(float offsety) {
        this.offsetY = offsety;
    }

    public void setOffsetX(float offsetx) {
        this.offsetX = offsetx;
    }

    public float getCurrentOffsetX() {
        return this.offsetX;
    }

    public synchronized void recyle() {
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
        this.gunId = 0L;
        this.uninit();
        this.mVertexShader = null;
        this.mFragmentShader = null;
        if (this.mVertexBuffer != null) {
            this.mVertexBuffer.clear();
        }
        if (this.mTexCoorBuffer != null) {
            this.mTexCoorBuffer.clear();
        }
    }

    public int getmViewHeight() {
        if (this.mBitmap == null) {
            return 0;
        }
        return this.mBitmap.getHeight();
    }

    public int getmViewWidth() {
        return this.mViewWidth;
    }

    public void setmViewWidth(int mViewWidth) {
        this.mViewWidth = mViewWidth;
    }

    public void initVertexData() {
        float danmakuHeight = (float)this.bitmapHeight / (float)this.mViewHeight * 2.0f;
        float danmakuWidth = (float)this.bitmapWidth / (float)this.mViewWidth * 2.0f;
        float[] vertices = new float[]{-1.0f, 1.0f, 0.0f, -(1.0f - danmakuWidth), 1.0f, 0.0f, -1.0f, 1.0f - danmakuHeight, 0.0f, -(1.0f - danmakuWidth), 1.0f - danmakuHeight, 0.0f};
        ByteBuffer vbb = ByteBuffer.allocateDirect(vertices.length * 4);
        vbb.order(ByteOrder.nativeOrder());
        this.mVertexBuffer = vbb.asFloatBuffer();
        this.mVertexBuffer.put(vertices);
        this.mVertexBuffer.position(0);
        short[] texCoor = new short[]{0, 0, 1, 0, 0, 1, 1, 1};
        ByteBuffer cbb = ByteBuffer.allocateDirect(texCoor.length * 2);
        cbb.order(ByteOrder.nativeOrder());
        this.mTexCoorBuffer = cbb.asShortBuffer();
        this.mTexCoorBuffer.put(texCoor);
        this.mTexCoorBuffer.position(0);
    }

    public void initShader() {
        if (FP.empty((CharSequence)this.mVertexShader)) {
            this.mVertexShader = ShaderUtils.loadFromAssetsFile("vertex.sh", BasicConfig.getInstance().getAppContext().getResources());
        }
        if (FP.empty((CharSequence)this.mFragmentShader)) {
            this.mFragmentShader = ShaderUtils.loadFromAssetsFile("frag.sh", BasicConfig.getInstance().getAppContext().getResources());
        }
        this.mProgram = TexturePool.getProgram(this.mVertexShader, this.mFragmentShader);
        this.maPositionHandle = TexturePool.getMaPositionHandle();
        this.maTexCoorHandle = TexturePool.getMaTexCoorHandle();
        this.muMVPMatrixHandle = TexturePool.getMuMVPMatrixHandle();
        this.mAlphaHandle = TexturePool.getAlphaHandle();
    }

    private boolean initTexture() {
        this.mTextureId = TexturePool.pollTextureId();
        if (this.mTextureId < 0) {
            return false;
        }
        GLES20.glBindTexture((int)3553, (int)this.mTextureId);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        if (this.mBitmap != null && !this.mBitmap.isRecycled()) {
            try {
                ByteBuffer pixels = ByteBuffer.allocateDirect(this.mBitmap.getByteCount());
                pixels.order(ByteOrder.nativeOrder());
                if (this.mBitmap != null && !this.mBitmap.isRecycled()) {
                    this.mBitmap.copyPixelsToBuffer((Buffer)pixels);
                    pixels.position(0);
                    GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.mBitmap.getWidth(), (int)this.mBitmap.getHeight(), (int)0, (int)6408, (int)5121, (Buffer)pixels);
                }
                if (this.mBitmap != null && !this.mBitmap.isRecycled()) {
                    this.mBitmap.recycle();
                    this.mBitmap = null;
                }
                if (pixels != null) {
                    pixels.clear();
                }
            }
            catch (OutOfMemoryError e2) {
                MLog.error((Object)e2, (String)"DanmuItem ByteBuffer.allocateDirect OOM", (Object[])new Object[0]);
                System.gc();
            }
            catch (Throwable e3) {
                MLog.error((Object)e3, (String)"DanmuItem bitmap is null object reference", (Object[])new Object[0]);
            }
        }
        return true;
    }

    private void uninit() {
        TexturePool.offerTextureId(this.mTextureId);
        this.mTextureId = -1;
    }

    public void drawDanmaku() {
        if (!this.isInited && !this.init() || this.mTextureId < 0) {
            return;
        }
        GLES20.glUseProgram((int)this.mProgram);
        MatrixUtils.setInitStack();
        MatrixUtils.transtate(2.0f, 0.0f, 0.0f);
        float unitY = -this.offsetY / (float)this.mViewHeight * 2.0f;
        float unitX = -this.offsetX / (float)this.mViewWidth * 2.0f;
        MatrixUtils.transtate(unitX, unitY, 0.0f);
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixHandle, (int)1, (boolean)false, (float[])MatrixUtils.getFinalMatrix(), (int)0);
        GLES20.glUniform1f((int)this.mAlphaHandle, (float)this.mAlpha);
        GLES20.glVertexAttribPointer((int)this.maPositionHandle, (int)3, (int)5126, (boolean)false, (int)0, (Buffer)this.mVertexBuffer);
        GLES20.glVertexAttribPointer((int)this.maTexCoorHandle, (int)2, (int)5122, (boolean)false, (int)0, (Buffer)this.mTexCoorBuffer);
        GLES20.glEnableVertexAttribArray((int)this.maPositionHandle);
        GLES20.glEnableVertexAttribArray((int)this.maTexCoorHandle);
        GLES20.glBindTexture((int)3553, (int)this.mTextureId);
        GLES20.glDrawArrays((int)5, (int)0, (int)this.mVertexCount);
    }
}

