/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.yy.mobile.ui.BaseLinkFragment;
import com.yy.mobile.ui.widget.BaseFragment;
import com.yy.mobile.util.FP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class NativeActivityFragment
extends BaseLinkFragment {
    private static HashMap<String, INativeViewLifyCycleListener> mListeners = new HashMap();

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        ArrayList<INativeViewLifyCycleListener> listeners = new ArrayList<INativeViewLifyCycleListener>();
        listeners.addAll(mListeners.values());
        if (!FP.empty(listeners)) {
            for (INativeViewLifyCycleListener listener : listeners) {
                listener.onViewCreated(this);
            }
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        ArrayList<INativeViewLifyCycleListener> listeners = new ArrayList<INativeViewLifyCycleListener>();
        listeners.addAll(mListeners.values());
        if (!FP.empty(listeners)) {
            for (INativeViewLifyCycleListener listener : listeners) {
                listener.onDestroyView(this);
            }
        }
    }

    public static void addNativeViewListener(@NonNull String tag, @NonNull INativeViewLifyCycleListener listener) {
        if (!mListeners.containsKey(tag)) {
            mListeners.put(tag, listener);
        }
    }

    public static void removeNativeViewListener(@NonNull INativeViewLifyCycleListener listener) {
        String removeKey = "";
        for (Map.Entry<String, INativeViewLifyCycleListener> entry : mListeners.entrySet()) {
            if (!listener.equals(entry.getValue())) continue;
            removeKey = entry.getKey();
            break;
        }
        if (!FP.empty((CharSequence)removeKey)) {
            mListeners.remove(removeKey);
        }
    }

    public static void removeNativeViewListenerByTag(@NonNull String tag) {
        if (mListeners.containsKey(tag)) {
            mListeners.remove(tag);
        }
    }

    public static interface INativeViewLifyCycleListener {
        public void onViewCreated(BaseFragment var1);

        public void onDestroyView(BaseFragment var1);
    }
}

