/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import com.yy.mobile.BaseAPPPackageUtil;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.Properties;

public class OpenPushPermissionUtil {
    private static final String TAG = "OpenPushPermissionUtil";

    public static void startSamsungNotificationManager() {
        OpenPushPermissionUtil.startAppDetailPage();
    }

    public static void startNotificationManager() {
        switch (Build.MANUFACTURER) {
            case "OPPO": {
                OpenPushPermissionUtil.startColorOSNotificationManager();
                break;
            }
            case "vivo": {
                OpenPushPermissionUtil.startFuntouchOSNotificationManager();
                break;
            }
            case "Xiaomi": {
                OpenPushPermissionUtil.startAppDetailPage();
                break;
            }
            case "HUAWEI": {
                OpenPushPermissionUtil.startHuaweiNotificationManager();
                break;
            }
            case "Meizu": {
                OpenPushPermissionUtil.startAppDetailPage();
                break;
            }
            case "samsung": {
                OpenPushPermissionUtil.startSamsungNotificationManager();
                break;
            }
            default: {
                OpenPushPermissionUtil.startAppDetailPage();
            }
        }
    }

    public static void startMiuiNotificationManager() {
        String buildVersion = OpenPushPermissionUtil.getPropValues("ro.miui.ui.version.name");
        if (TextUtils.isEmpty((CharSequence)buildVersion)) {
            OpenPushPermissionUtil.startAppDetailPage();
            return;
        }
        String packageName = null;
        String activityName = null;
        if (!buildVersion.matches("^(v9).+") && !"v9".equals(buildVersion)) {
            OpenPushPermissionUtil.startAppDetailPage();
            return;
        }
        packageName = "com.miui.securitycenter";
        activityName = "com.miui.appmanager.ApplicationsDetailsActivity";
        Activity currentActivity = YYActivityManager.INSTANCE.getCurrentActivity();
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(packageName, activityName));
        intent.putExtra("extra_pkgname", "com.duowan.mobile");
        intent.setFlags(0x10000000);
        try {
            currentActivity.startActivity(intent);
        }
        catch (Exception e2) {
            OpenPushPermissionUtil.startAppDetailPage();
            e2.printStackTrace();
        }
    }

    public static void startHuaweiNotificationManager() {
        String buildVersion = OpenPushPermissionUtil.getPropValues("ro.build.version.emui");
        if (TextUtils.isEmpty((CharSequence)buildVersion)) {
            OpenPushPermissionUtil.startAppDetailPage();
            return;
        }
        String packageName = "com.huawei.systemmanager";
        String activityName = "com.huawei.notificationmanager.ui.NotificationSettingsActivity";
        Activity currentActivity = YYActivityManager.INSTANCE.getCurrentActivity();
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(packageName, activityName));
        intent.putExtra("extra_pkgname", "com.duowan.mobile");
        intent.setFlags(0x10000000);
        try {
            currentActivity.startActivity(intent);
        }
        catch (Exception e2) {
            OpenPushPermissionUtil.startAppDetailPage();
            e2.printStackTrace();
        }
    }

    public static void startColorOSNotificationManager() {
        String colorOSVersion = OpenPushPermissionUtil.getPropValues("ro.build.version.opporom");
        if (TextUtils.isEmpty((CharSequence)colorOSVersion)) {
            OpenPushPermissionUtil.startAppDetailPage();
            return;
        }
        String packageName = null;
        String activityName = null;
        if ("v2.1".equals(colorOSVersion)) {
            packageName = "com.oppo.notification.center";
            activityName = "com.oppo.notification.center.AppDetailActivity";
        } else if ("v3.0".equals(colorOSVersion) || "v3.0.0".equals(colorOSVersion)) {
            packageName = "com.coloros.notificationmanager";
            activityName = "com.coloros.notificationmanager.AppDetailPreferenceActivity";
        } else if (colorOSVersion.matches("^(v[4-9]).+")) {
            packageName = "com.coloros.notificationmanager";
            activityName = "com.coloros.notificationmanager.AppDetailPreferenceActivity";
        } else {
            OpenPushPermissionUtil.startAppDetailPage();
            return;
        }
        Activity currentActivity = YYActivityManager.INSTANCE.getCurrentActivity();
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(packageName, activityName));
        intent.putExtra("pkg_name", "com.duowan.mobile");
        intent.putExtra("app_name", BaseAPPPackageUtil.getAppName((Context)YYActivityManager.INSTANCE.getCurrentActivity().getApplicationContext()));
        intent.setFlags(0x10000000);
        try {
            currentActivity.startActivity(intent);
        }
        catch (Exception e2) {
            OpenPushPermissionUtil.startAppDetailPage();
            e2.printStackTrace();
        }
    }

    public static void startFuntouchOSNotificationManager() {
        String funtouchOSVersion = OpenPushPermissionUtil.getPropValues("ro.vivo.os.version");
        if (TextUtils.isEmpty((CharSequence)funtouchOSVersion)) {
            OpenPushPermissionUtil.startAppDetailPage();
            return;
        }
        String packageName = null;
        String activityName = null;
        if ("2.5".equals(funtouchOSVersion)) {
            packageName = "com.android.systemui";
            activityName = "com.android.systemui.vivo.common.notification.StatusbarSettingActivity";
        } else if ("3.1".equals(funtouchOSVersion)) {
            packageName = "com.android.systemui";
            activityName = "com.vivo.systemui.statusbar.notification.settings.StatusbarSettingActivity";
        } else if (funtouchOSVersion.matches("^4.+")) {
            packageName = "com.android.systemui";
            activityName = "com.vivo.systemui.statusbar.notification.settings.channels.NotificationSettingsActivity";
        } else {
            OpenPushPermissionUtil.startAppDetailPage();
            return;
        }
        Activity currentActivity = YYActivityManager.INSTANCE.getCurrentActivity();
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(packageName, activityName));
        intent.putExtra("extra_pkgname", "com.duowan.mobile");
        intent.setFlags(0x10000000);
        try {
            currentActivity.startActivity(intent);
        }
        catch (Exception e2) {
            OpenPushPermissionUtil.startAppDetailPage();
            e2.printStackTrace();
        }
    }

    public static String getPropValues(String prop) {
        if (Build.VERSION.SDK_INT >= 26) {
            return OpenPushPermissionUtil.getBuildProperty(prop);
        }
        return OpenPushPermissionUtil.getBuildPropFileProperty(prop);
    }

    public static String getBuildPropFileProperty(String property) {
        FileInputStream fileInputStream = null;
        String value = null;
        try {
            fileInputStream = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Class<?> clzSystemProperties = Class.forName("android.os.SystemProperties");
            Method getMethod = clzSystemProperties.getDeclaredMethod("get", String.class);
            value = OpenPushPermissionUtil.getLowerCaseName(properties, getMethod, property);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return value;
    }

    public static String getBuildProperty(String property) {
        String value = null;
        try {
            ClassLoader classLoader = YYActivityManager.INSTANCE.getCurrentActivity().getApplicationContext().getClassLoader();
            Class<?> systemProperties = classLoader.loadClass("android.os.SystemProperties");
            Method methodGet = systemProperties.getMethod("get", String.class);
            return (String)methodGet.invoke(systemProperties, property);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return value;
        }
    }

    public static String getLowerCaseName(Properties p, Method get, String key) {
        String name = p.getProperty(key);
        if (name == null) {
            try {
                name = (String)get.invoke(null, key);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        if (name != null) {
            name = name.toLowerCase();
        }
        return name;
    }

    public static void startSettingPage() {
        Intent intent = new Intent("android.settings.SETTINGS");
        YYActivityManager.INSTANCE.getCurrentActivity().startActivity(intent);
    }

    public static void startAppDetailPage() {
        MLog.info((Object)TAG, (String)"startAppDetailPage", (Object[])new Object[0]);
        try {
            Intent intent = new Intent();
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.fromParts((String)"package", (String)YYActivityManager.INSTANCE.getCurrentActivity().getPackageName(), null));
            YYActivityManager.INSTANCE.getCurrentActivity().startActivity(intent);
        }
        catch (Exception e2) {
            OpenPushPermissionUtil.startSettingPage();
            e2.printStackTrace();
        }
    }
}

