/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.horizontallist;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.util.SparseArrayCompat;
import android.util.AttributeSet;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.SoundEffectConstants;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ArrayAdapter;
import android.widget.Checkable;
import android.widget.ListAdapter;
import android.widget.RemoteViews;
import com.handmark.pulltorefresh.library.extras_view.HeaderViewListAdapter;
import com.yy.mobile.ui.widget.horizontallist.AbsHListView;
import com.yy.mobile.util.log.MLog;
import com.yymobile.baseapi.R;
import java.util.ArrayList;

@RemoteViews.RemoteView
public class HListView
extends AbsHListView {
    private static final String TAG = "HListView";
    static final int NO_POSITION = -1;
    private static final float MAX_SCROLL_FACTOR = 0.33f;
    private static final int MIN_SCROLL_PREVIEW_PIXELS = 2;
    private static final String LOG_TAG = "HListView";
    private ArrayList<HeaderViewListAdapter.FixedViewInfo> mHeaderViewInfos = new ArrayList();
    private ArrayList<HeaderViewListAdapter.FixedViewInfo> mFooterViewInfos = new ArrayList();
    Drawable mDivider;
    int mDividerWidth;
    int mMeasureWithChild;
    Drawable mOverScrollHeader;
    Drawable mOverScrollFooter;
    private boolean mIsCacheColorOpaque;
    private boolean mDividerIsOpaque;
    private boolean mHeaderDividersEnabled;
    private boolean mFooterDividersEnabled;
    private boolean mAreAllItemsSelectable = true;
    private boolean mItemsCanFocus = false;
    private final Rect mTempRect = new Rect();
    private Paint mDividerPaint;
    private final ArrowScrollFocusResult mArrowScrollFocusResult = new ArrowScrollFocusResult();
    private FocusSelector mFocusSelector;

    public HListView(Context context) {
        this(context, null);
    }

    public HListView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.hlv_listViewStyle);
    }

    public HListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        Resources.Theme theme = context.getTheme();
        TypedArray array = theme.obtainStyledAttributes(attrs, R.styleable.HListView, defStyle, 0);
        Object[] entries = null;
        Drawable dividerDrawable = null;
        Drawable overscrollHeader = null;
        Drawable overscrollFooter = null;
        int dividerWidth = 0;
        boolean headerDividersEnabled = true;
        boolean footerDividersEnabled = true;
        int measureWithChild = -1;
        if (null != array) {
            entries = array.getTextArray(R.styleable.HListView_android_entries);
            dividerDrawable = array.getDrawable(R.styleable.HListView_android_divider);
            overscrollHeader = array.getDrawable(R.styleable.HListView_hlv_overScrollHeader);
            overscrollFooter = array.getDrawable(R.styleable.HListView_hlv_overScrollFooter);
            dividerWidth = array.getDimensionPixelSize(R.styleable.HListView_hlv_dividerWidth, 0);
            headerDividersEnabled = array.getBoolean(R.styleable.HListView_hlv_headerDividersEnabled, true);
            footerDividersEnabled = array.getBoolean(R.styleable.HListView_hlv_footerDividersEnabled, true);
            measureWithChild = array.getInteger(R.styleable.HListView_hlv_measureWithChild, -1);
            array.recycle();
        }
        if (entries != null) {
            this.setAdapter((ListAdapter)new ArrayAdapter(context, 17367043, entries));
        }
        if (dividerDrawable != null) {
            this.setDivider(dividerDrawable);
        }
        if (overscrollHeader != null) {
            this.setOverscrollHeader(overscrollHeader);
        }
        if (overscrollFooter != null) {
            this.setOverscrollFooter(overscrollFooter);
        }
        if (dividerWidth != 0) {
            this.setDividerWidth(dividerWidth);
        }
        this.mHeaderDividersEnabled = headerDividersEnabled;
        this.mFooterDividersEnabled = footerDividersEnabled;
        this.mMeasureWithChild = measureWithChild;
    }

    public int getMaxScrollAmount() {
        return (int)(0.33f * (float)(this.getRight() - this.getLeft()));
    }

    private void adjustViewsLeftOrRight() {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            int delta;
            if (!this.mStackFromRight) {
                View child = this.getChildAt(0);
                delta = child.getLeft() - this.mListPadding.left;
                if (this.mFirstPosition != 0) {
                    delta -= this.mDividerWidth;
                }
                if (delta < 0) {
                    delta = 0;
                }
            } else {
                View child = this.getChildAt(childCount - 1);
                delta = child.getRight() - (this.getWidth() - this.mListPadding.right);
                if (this.mFirstPosition + childCount < this.mItemCount) {
                    delta += this.mDividerWidth;
                }
                if (delta > 0) {
                    delta = 0;
                }
            }
            if (delta != 0) {
                this.offsetChildrenLeftAndRight(-delta);
            }
        }
    }

    public void addHeaderView(View v, Object data, boolean isSelectable) {
        if (this.mAdapter != null && !(this.mAdapter instanceof HeaderViewListAdapter)) {
            throw new IllegalStateException("Cannot add header view to list -- setAdapter has already been called.");
        }
        HeaderViewListAdapter.FixedViewInfo info = new HeaderViewListAdapter.FixedViewInfo();
        info.view = v;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mHeaderViewInfos.add(info);
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mDataSetObserver.onChanged();
        }
    }

    public void addHeaderView(View v) {
        this.addHeaderView(v, null, true);
    }

    @Override
    public int getHeaderViewsCount() {
        return this.mHeaderViewInfos.size();
    }

    public boolean removeHeaderView(View v) {
        if (this.mHeaderViewInfos.size() > 0) {
            boolean result = false;
            if (this.mAdapter != null && ((HeaderViewListAdapter)this.mAdapter).removeHeader(v)) {
                if (this.mDataSetObserver != null) {
                    this.mDataSetObserver.onChanged();
                }
                result = true;
            }
            this.removeFixedViewInfo(v, this.mHeaderViewInfos);
            return result;
        }
        return false;
    }

    private void removeFixedViewInfo(View v, ArrayList<HeaderViewListAdapter.FixedViewInfo> where) {
        int len = where.size();
        for (int i2 = 0; i2 < len; ++i2) {
            HeaderViewListAdapter.FixedViewInfo info = where.get(i2);
            if (info.view != v) continue;
            where.remove(i2);
            break;
        }
    }

    public void addFooterView(View v, Object data, boolean isSelectable) {
        HeaderViewListAdapter.FixedViewInfo info = new HeaderViewListAdapter.FixedViewInfo();
        info.view = v;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mFooterViewInfos.add(info);
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mDataSetObserver.onChanged();
        }
    }

    public void addFooterView(View v) {
        this.addFooterView(v, null, true);
    }

    @Override
    public int getFooterViewsCount() {
        return this.mFooterViewInfos.size();
    }

    public boolean removeFooterView(View v) {
        if (this.mFooterViewInfos.size() > 0) {
            boolean result = false;
            if (this.mAdapter != null && ((HeaderViewListAdapter)this.mAdapter).removeFooter(v)) {
                if (this.mDataSetObserver != null) {
                    this.mDataSetObserver.onChanged();
                }
                result = true;
            }
            this.removeFixedViewInfo(v, this.mFooterViewInfos);
            return result;
        }
        return false;
    }

    @Override
    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    @Override
    public void setAdapter(ListAdapter adapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver((DataSetObserver)this.mDataSetObserver);
        }
        this.resetList();
        this.mRecycler.clear();
        this.mAdapter = this.mHeaderViewInfos.size() > 0 || this.mFooterViewInfos.size() > 0 ? new HeaderViewListAdapter(this.mHeaderViewInfos, this.mFooterViewInfos, adapter) : adapter;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedColId = Long.MIN_VALUE;
        super.setAdapter(adapter);
        if (this.mAdapter != null) {
            this.mAreAllItemsSelectable = this.mAdapter.areAllItemsEnabled();
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.checkFocus();
            this.mDataSetObserver = new AbsHListView.AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver((DataSetObserver)this.mDataSetObserver);
            this.mRecycler.setViewTypeCount(this.mAdapter.getViewTypeCount());
            int position = this.mStackFromRight ? this.lookForSelectablePosition(this.mItemCount - 1, false) : this.lookForSelectablePosition(0, true);
            this.setSelectedPositionInt(position);
            this.setNextSelectedPositionInt(position);
            if (this.mItemCount == 0) {
                this.checkSelectionChanged();
            }
        } else {
            this.mAreAllItemsSelectable = true;
            this.checkFocus();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    @Override
    protected void resetList() {
        this.clearRecycledState(this.mHeaderViewInfos);
        this.clearRecycledState(this.mFooterViewInfos);
        super.resetList();
        this.mLayoutMode = 0;
    }

    private void clearRecycledState(ArrayList<HeaderViewListAdapter.FixedViewInfo> infos) {
        if (infos != null) {
            int count = infos.size();
            for (int i2 = 0; i2 < count; ++i2) {
                View child = infos.get((int)i2).view;
                AbsHListView.LayoutParams p = (AbsHListView.LayoutParams)child.getLayoutParams();
                if (p == null) continue;
                p.recycledHeaderFooter = false;
            }
        }
    }

    private boolean showingLeftFadingEdge() {
        int listLeft = this.getScrollX() + this.mListPadding.left;
        return this.mFirstPosition > 0 || this.getChildAt(0).getLeft() > listLeft;
    }

    private boolean showingRightFadingEdge() {
        int childCount = this.getChildCount();
        int rightOfRightChild = this.getChildAt(childCount - 1).getRight();
        int lastVisiblePosition = this.mFirstPosition + childCount - 1;
        int listRight = this.getScrollX() + this.getWidth() - this.mListPadding.right;
        return lastVisiblePosition < this.mItemCount - 1 || rightOfRightChild < listRight;
    }

    public boolean requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        boolean scroll;
        int rectLeftWithinChild = rect.left;
        rect.offset(child.getLeft(), child.getTop());
        rect.offset(-child.getScrollX(), -child.getScrollY());
        int width = this.getWidth();
        int listUnfadedLeft = this.getScrollX();
        int listUnfadedRight = listUnfadedLeft + width;
        int fadingEdge = this.getHorizontalFadingEdgeLength();
        if (this.showingLeftFadingEdge() && (this.mSelectedPosition > 0 || rectLeftWithinChild > fadingEdge)) {
            listUnfadedLeft += fadingEdge;
        }
        int childCount = this.getChildCount();
        int rightOfRightChild = this.getChildAt(childCount - 1).getRight();
        if (this.showingRightFadingEdge() && (this.mSelectedPosition < this.mItemCount - 1 || rect.right < rightOfRightChild - fadingEdge)) {
            listUnfadedRight -= fadingEdge;
        }
        int scrollXDelta = 0;
        if (rect.right > listUnfadedRight && rect.left > listUnfadedLeft) {
            scrollXDelta = rect.width() > width ? (scrollXDelta += rect.left - listUnfadedLeft) : (scrollXDelta += rect.right - listUnfadedRight);
            int distanceToRight = rightOfRightChild - listUnfadedRight;
            scrollXDelta = Math.min(scrollXDelta, distanceToRight);
        } else if (rect.left < listUnfadedLeft && rect.right < listUnfadedRight) {
            scrollXDelta = rect.width() > width ? (scrollXDelta -= listUnfadedRight - rect.right) : (scrollXDelta -= listUnfadedLeft - rect.left);
            int left = this.getChildAt(0).getLeft();
            int deltaToLeft = left - listUnfadedLeft;
            scrollXDelta = Math.max(scrollXDelta, deltaToLeft);
        }
        boolean bl = scroll = scrollXDelta != 0;
        if (scroll) {
            this.scrollListItemsBy(-scrollXDelta);
            this.positionSelector(-1, child);
            this.mSelectedLeft = child.getTop();
            this.invalidate();
        }
        return scroll;
    }

    @Override
    protected void fillGap(boolean down) {
        try {
            int count = this.getChildCount();
            if (down) {
                int paddingLeft = 0;
                int startOffset = count > 0 ? this.getChildAt(count - 1).getRight() + this.mDividerWidth : paddingLeft;
                this.fillRight(this.mFirstPosition + count, startOffset);
                this.correctTooWide(this.getChildCount());
            } else {
                int paddingRight = 0;
                int startOffset = count > 0 ? this.getChildAt(0).getLeft() - this.mDividerWidth : this.getWidth() - paddingRight;
                this.fillLeft(this.mFirstPosition - 1, startOffset);
                this.correctTooSmall(this.getChildCount());
            }
        }
        catch (Exception e2) {
            MLog.error((Object)"HListView", (String)("err:" + e2), (Object[])new Object[0]);
        }
    }

    private View fillRight(int pos, int nextLeft) {
        View selectedView = null;
        int end = this.getRight() - this.getLeft();
        while (nextLeft < end && pos < this.mItemCount) {
            boolean selected = pos == this.mSelectedPosition;
            View child = this.makeAndAddView(pos, nextLeft, true, this.mListPadding.top, selected);
            nextLeft = child.getRight() + this.mDividerWidth;
            if (selected) {
                selectedView = child;
            }
            ++pos;
        }
        this.setVisibleRangeHint(this.mFirstPosition, this.mFirstPosition + this.getChildCount() - 1);
        return selectedView;
    }

    private View fillLeft(int pos, int nextRight) {
        View selectedView = null;
        int end = 0;
        while (nextRight > end && pos >= 0) {
            boolean selected = pos == this.mSelectedPosition;
            View child = this.makeAndAddView(pos, nextRight, false, this.mListPadding.top, selected);
            nextRight = child.getLeft() - this.mDividerWidth;
            if (selected) {
                selectedView = child;
            }
            --pos;
        }
        this.mFirstPosition = pos + 1;
        this.setVisibleRangeHint(this.mFirstPosition, this.mFirstPosition + this.getChildCount() - 1);
        return selectedView;
    }

    private View fillFromLeft(int nextLeft) {
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mSelectedPosition);
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mItemCount - 1);
        if (this.mFirstPosition < 0) {
            this.mFirstPosition = 0;
        }
        return this.fillRight(this.mFirstPosition, nextLeft);
    }

    private View fillFromMiddle(int childrenLeft, int childrenRight) {
        int width = childrenRight - childrenLeft;
        int position = this.reconcileSelectedPosition();
        View sel = this.makeAndAddView(position, childrenLeft, true, this.mListPadding.top, true);
        this.mFirstPosition = position;
        int selWidth = sel.getMeasuredWidth();
        if (selWidth <= width) {
            sel.offsetLeftAndRight((width - selWidth) / 2);
        }
        this.fillBeforeAndAfter(sel, position);
        if (!this.mStackFromRight) {
            this.correctTooWide(this.getChildCount());
        } else {
            this.correctTooSmall(this.getChildCount());
        }
        return sel;
    }

    private void fillBeforeAndAfter(View sel, int position) {
        int dividerWidth = this.mDividerWidth;
        if (!this.mStackFromRight) {
            this.fillLeft(position - 1, sel.getLeft() - dividerWidth);
            this.adjustViewsLeftOrRight();
            this.fillRight(position + 1, sel.getRight() + dividerWidth);
        } else {
            this.fillRight(position + 1, sel.getRight() + dividerWidth);
            this.adjustViewsLeftOrRight();
            this.fillLeft(position - 1, sel.getLeft() - dividerWidth);
        }
    }

    private View fillFromSelection(int selectedLeft, int childrenLeft, int childrenRight) {
        int fadingEdgeLength = this.getHorizontalFadingEdgeLength();
        int selectedPosition = this.mSelectedPosition;
        int leftSelectionPixel = this.getLeftSelectionPixel(childrenLeft, fadingEdgeLength, selectedPosition);
        int rightSelectionPixel = this.getRightSelectionPixel(childrenRight, fadingEdgeLength, selectedPosition);
        View sel = this.makeAndAddView(selectedPosition, selectedLeft, true, this.mListPadding.top, true);
        if (sel.getRight() > rightSelectionPixel) {
            int spaceBefore = sel.getLeft() - leftSelectionPixel;
            int spaceAfter = sel.getRight() - rightSelectionPixel;
            int offset = Math.min(spaceBefore, spaceAfter);
            sel.offsetLeftAndRight(-offset);
        } else if (sel.getLeft() < leftSelectionPixel) {
            int spaceBefore = leftSelectionPixel - sel.getLeft();
            int spaceAfter = rightSelectionPixel - sel.getRight();
            int offset = Math.min(spaceBefore, spaceAfter);
            sel.offsetLeftAndRight(offset);
        }
        this.fillBeforeAndAfter(sel, selectedPosition);
        if (!this.mStackFromRight) {
            this.correctTooWide(this.getChildCount());
        } else {
            this.correctTooSmall(this.getChildCount());
        }
        return sel;
    }

    private int getRightSelectionPixel(int childrenRight, int fadingEdgeLength, int selectedPosition) {
        int rightSelectionPixel = childrenRight;
        if (selectedPosition != this.mItemCount - 1) {
            rightSelectionPixel -= fadingEdgeLength;
        }
        return rightSelectionPixel;
    }

    private int getLeftSelectionPixel(int childrenLeft, int fadingEdgeLength, int selectedPosition) {
        int leftSelectionPixel = childrenLeft;
        if (selectedPosition > 0) {
            leftSelectionPixel += fadingEdgeLength;
        }
        return leftSelectionPixel;
    }

    @Override
    public void smoothScrollByOffset(int offset) {
        super.smoothScrollByOffset(offset);
    }

    private View moveSelection(View oldSel, View newSel, int delta, int childrenLeft, int childrenRight) {
        View sel;
        int fadingEdgeLength = this.getHorizontalFadingEdgeLength();
        int selectedPosition = this.mSelectedPosition;
        int leftSelectionPixel = this.getLeftSelectionPixel(childrenLeft, fadingEdgeLength, selectedPosition);
        int rightSelectionPixel = this.getRightSelectionPixel(childrenLeft, fadingEdgeLength, selectedPosition);
        if (delta > 0) {
            oldSel = this.makeAndAddView(selectedPosition - 1, oldSel.getLeft(), true, this.mListPadding.top, false);
            int dividerWidth = this.mDividerWidth;
            sel = this.makeAndAddView(selectedPosition, oldSel.getRight() + dividerWidth, true, this.mListPadding.top, true);
            if (sel.getRight() > rightSelectionPixel) {
                int spaceBefore = sel.getLeft() - leftSelectionPixel;
                int spaceAfter = sel.getRight() - rightSelectionPixel;
                int halfHorizontalSpace = (childrenRight - childrenLeft) / 2;
                int offset = Math.min(spaceBefore, spaceAfter);
                offset = Math.min(offset, halfHorizontalSpace);
                oldSel.offsetLeftAndRight(-offset);
                sel.offsetLeftAndRight(-offset);
            }
            if (!this.mStackFromRight) {
                this.fillLeft(this.mSelectedPosition - 2, sel.getLeft() - dividerWidth);
                this.adjustViewsLeftOrRight();
                this.fillRight(this.mSelectedPosition + 1, sel.getRight() + dividerWidth);
            } else {
                this.fillRight(this.mSelectedPosition + 1, sel.getRight() + dividerWidth);
                this.adjustViewsLeftOrRight();
                this.fillLeft(this.mSelectedPosition - 2, sel.getLeft() - dividerWidth);
            }
        } else if (delta < 0) {
            sel = newSel != null ? this.makeAndAddView(selectedPosition, newSel.getLeft(), true, this.mListPadding.top, true) : this.makeAndAddView(selectedPosition, oldSel.getLeft(), false, this.mListPadding.top, true);
            if (sel.getLeft() < leftSelectionPixel) {
                int spaceBefore = leftSelectionPixel - sel.getLeft();
                int spaceAfter = rightSelectionPixel - sel.getRight();
                int halfHorizontalSpace = (childrenRight - childrenLeft) / 2;
                int offset = Math.min(spaceBefore, spaceAfter);
                offset = Math.min(offset, halfHorizontalSpace);
                sel.offsetLeftAndRight(offset);
            }
            this.fillBeforeAndAfter(sel, selectedPosition);
        } else {
            int newRight;
            int oldLeft = oldSel.getLeft();
            sel = this.makeAndAddView(selectedPosition, oldLeft, true, this.mListPadding.top, true);
            if (oldLeft < childrenLeft && (newRight = sel.getRight()) < childrenLeft + 20) {
                sel.offsetLeftAndRight(childrenLeft - sel.getLeft());
            }
            this.fillBeforeAndAfter(sel, selectedPosition);
        }
        return sel;
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        View focusedChild;
        if (this.getChildCount() > 0 && (focusedChild = this.getFocusedChild()) != null) {
            int childPosition = this.mFirstPosition + this.indexOfChild(focusedChild);
            int childRight = focusedChild.getRight();
            int offset = Math.max(0, childRight - (w - this.getPaddingLeft()));
            int left = focusedChild.getLeft() - offset;
            if (this.mFocusSelector == null) {
                this.mFocusSelector = new FocusSelector();
            }
            this.post(this.mFocusSelector.setup(childPosition, left));
        }
        super.onSizeChanged(w, h, oldw, oldh);
    }

    @Override
    @TargetApi(value=11)
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childWidth = 0;
        int childHeight = 0;
        int childState = 0;
        int n = this.mItemCount = this.mAdapter == null ? 0 : this.mAdapter.getCount();
        if (this.mItemCount > 0 && (widthMode == 0 || heightMode == 0)) {
            View child = this.obtainView(0, this.mIsScrap);
            this.measureScrapChildWidth(child, 0, heightMeasureSpec);
            childWidth = child.getMeasuredWidth();
            childHeight = child.getMeasuredHeight();
            if (Build.VERSION.SDK_INT >= 11) {
                childState = HListView.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
            }
            if (this.recycleOnMeasure() && this.mRecycler.shouldRecycleViewType(((AbsHListView.LayoutParams)child.getLayoutParams()).viewType)) {
                this.mRecycler.addScrapView(child, -1);
            }
        }
        if (heightMode == 0) {
            heightSize = this.mListPadding.top + this.mListPadding.bottom + childHeight + this.getHorizontalScrollbarHeight();
        } else if (heightMode == Integer.MIN_VALUE && this.mItemCount > 0 && this.mMeasureWithChild > -1) {
            int[] result = this.measureWithLargeChildren(heightMeasureSpec, this.mMeasureWithChild, this.mMeasureWithChild, widthSize, heightSize, -1);
            heightSize = result[1];
        } else if (Build.VERSION.SDK_INT >= 11) {
            heightSize |= childState & 0xFF000000;
        }
        if (widthMode == 0) {
            widthSize = this.mListPadding.left + this.mListPadding.right + childWidth + this.getHorizontalFadingEdgeLength() * 2;
        }
        if (widthMode == Integer.MIN_VALUE) {
            widthSize = this.measureWidthOfChildren(heightMeasureSpec, 0, -1, widthSize, -1);
        }
        this.setMeasuredDimension(widthSize, heightSize);
        this.mHeightMeasureSpec = heightMeasureSpec;
    }

    private void measureScrapChildWidth(View child, int position, int heightMeasureSpec) {
        AbsHListView.LayoutParams p = (AbsHListView.LayoutParams)child.getLayoutParams();
        if (p == null) {
            p = (AbsHListView.LayoutParams)this.generateDefaultLayoutParams();
            child.setLayoutParams((ViewGroup.LayoutParams)p);
        }
        p.viewType = this.mAdapter.getItemViewType(position);
        p.forceAdd = true;
        int childHeightSpec = ViewGroup.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.mListPadding.top + this.mListPadding.bottom), (int)p.height);
        int lpWidth = p.width;
        int childWidthSpec = lpWidth > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpWidth, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    public int[] measureChild(View child) {
        this.measureItem(child);
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        return new int[]{w, h};
    }

    @ViewDebug.ExportedProperty(category="list")
    protected boolean recycleOnMeasure() {
        return true;
    }

    final int measureWidthOfChildren(int heightMeasureSpec, int startPosition, int endPosition, int maxWidth, int disallowPartialChildPosition) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null) {
            return this.mListPadding.left + this.mListPadding.right;
        }
        int returnedWidth = this.mListPadding.left + this.mListPadding.right;
        int dividerWidth = this.mDividerWidth > 0 && this.mDivider != null ? this.mDividerWidth : 0;
        int prevWidthWithoutPartialChild = 0;
        endPosition = endPosition == -1 ? adapter.getCount() - 1 : endPosition;
        AbsHListView.RecycleBin recycleBin = this.mRecycler;
        boolean recyle = this.recycleOnMeasure();
        boolean[] isScrap = this.mIsScrap;
        for (int i2 = startPosition; i2 <= endPosition; ++i2) {
            View child = this.obtainView(i2, isScrap);
            this.measureScrapChildWidth(child, i2, heightMeasureSpec);
            if (i2 > 0) {
                returnedWidth += dividerWidth;
            }
            if (recyle && recycleBin.shouldRecycleViewType(((AbsHListView.LayoutParams)child.getLayoutParams()).viewType)) {
                recycleBin.addScrapView(child, -1);
            }
            if ((returnedWidth += child.getMeasuredWidth()) >= maxWidth) {
                return disallowPartialChildPosition >= 0 && i2 > disallowPartialChildPosition && prevWidthWithoutPartialChild > 0 && returnedWidth != maxWidth ? prevWidthWithoutPartialChild : maxWidth;
            }
            if (disallowPartialChildPosition < 0 || i2 < disallowPartialChildPosition) continue;
            prevWidthWithoutPartialChild = returnedWidth;
        }
        return returnedWidth;
    }

    final int[] measureWithLargeChildren(int heightMeasureSpec, int startPosition, int endPosition, int maxWidth, int maxHeight, int disallowPartialChildPosition) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null) {
            return new int[]{this.mListPadding.left + this.mListPadding.right, this.mListPadding.top + this.mListPadding.bottom};
        }
        int returnedWidth = this.mListPadding.left + this.mListPadding.right;
        int returnedHeight = this.mListPadding.top + this.mListPadding.bottom;
        int dividerWidth = this.mDividerWidth > 0 && this.mDivider != null ? this.mDividerWidth : 0;
        int childWidth = 0;
        int childHeight = 0;
        endPosition = endPosition == -1 ? adapter.getCount() - 1 : endPosition;
        AbsHListView.RecycleBin recycleBin = this.mRecycler;
        boolean recyle = this.recycleOnMeasure();
        boolean[] isScrap = this.mIsScrap;
        for (int i2 = startPosition; i2 <= endPosition; ++i2) {
            View child = this.obtainView(i2, isScrap);
            this.measureScrapChildWidth(child, i2, heightMeasureSpec);
            if (recyle && recycleBin.shouldRecycleViewType(((AbsHListView.LayoutParams)child.getLayoutParams()).viewType)) {
                recycleBin.addScrapView(child, -1);
            }
            childWidth = Math.max(childWidth, child.getMeasuredWidth() + dividerWidth);
            childHeight = Math.max(childHeight, child.getMeasuredHeight());
        }
        return new int[]{Math.min(returnedWidth += childWidth, maxWidth), Math.min(returnedHeight += childHeight, maxHeight)};
    }

    @Override
    protected int findMotionCol(int x) {
        block4: {
            int childCount = this.getChildCount();
            if (childCount <= 0) break block4;
            if (!this.mStackFromRight) {
                for (int i2 = 0; i2 < childCount; ++i2) {
                    View v = this.getChildAt(i2);
                    if (x > v.getRight()) continue;
                    return this.mFirstPosition + i2;
                }
            } else {
                for (int i3 = childCount - 1; i3 >= 0; --i3) {
                    View v = this.getChildAt(i3);
                    if (x < v.getLeft()) continue;
                    return this.mFirstPosition + i3;
                }
            }
        }
        return -1;
    }

    private View fillSpecific(int position, int left) {
        View after;
        View before;
        boolean tempIsSelected = position == this.mSelectedPosition;
        View temp = this.makeAndAddView(position, left, true, this.mListPadding.top, tempIsSelected);
        this.mFirstPosition = position;
        int dividerWidth = this.mDividerWidth;
        if (!this.mStackFromRight) {
            before = this.fillLeft(position - 1, temp.getLeft() - dividerWidth);
            this.adjustViewsLeftOrRight();
            after = this.fillRight(position + 1, temp.getRight() + dividerWidth);
            int childCount = this.getChildCount();
            if (childCount > 0) {
                this.correctTooWide(childCount);
            }
        } else {
            after = this.fillRight(position + 1, temp.getRight() + dividerWidth);
            this.adjustViewsLeftOrRight();
            before = this.fillLeft(position - 1, temp.getLeft() - dividerWidth);
            int childCount = this.getChildCount();
            if (childCount > 0) {
                this.correctTooSmall(childCount);
            }
        }
        if (tempIsSelected) {
            return temp;
        }
        if (before != null) {
            return before;
        }
        return after;
    }

    private void correctTooWide(int childCount) {
        int lastPosition = this.mFirstPosition + childCount - 1;
        if (lastPosition == this.mItemCount - 1 && childCount > 0) {
            View lastChild = this.getChildAt(childCount - 1);
            int lastRight = lastChild.getRight();
            int end = this.getRight() - this.getLeft() - this.mListPadding.right;
            int rightOffset = end - lastRight;
            View firstChild = this.getChildAt(0);
            int firstLeft = firstChild.getLeft();
            if (rightOffset > 0 && (this.mFirstPosition > 0 || firstLeft < this.mListPadding.top)) {
                if (this.mFirstPosition == 0) {
                    rightOffset = Math.min(rightOffset, this.mListPadding.top - firstLeft);
                }
                this.offsetChildrenLeftAndRight(rightOffset);
                if (this.mFirstPosition > 0) {
                    this.fillLeft(this.mFirstPosition - 1, firstChild.getLeft() - this.mDividerWidth);
                    this.adjustViewsLeftOrRight();
                }
            }
        }
    }

    private void correctTooSmall(int childCount) {
        if (this.mFirstPosition == 0 && childCount > 0) {
            View firstChild = this.getChildAt(0);
            int firstLeft = firstChild.getLeft();
            int start = this.mListPadding.left;
            int end = this.getRight() - this.getLeft() - this.mListPadding.right;
            int leftOffset = firstLeft - start;
            View lastChild = this.getChildAt(childCount - 1);
            int lastRight = lastChild.getRight();
            int lastPosition = this.mFirstPosition + childCount - 1;
            if (leftOffset > 0) {
                if (lastPosition < this.mItemCount - 1 || lastRight > end) {
                    if (lastPosition == this.mItemCount - 1) {
                        leftOffset = Math.min(leftOffset, lastRight - end);
                    }
                    this.offsetChildrenLeftAndRight(-leftOffset);
                    if (lastPosition < this.mItemCount - 1) {
                        this.fillRight(lastPosition + 1, lastChild.getRight() + this.mDividerWidth);
                        this.adjustViewsLeftOrRight();
                    }
                } else if (lastPosition == this.mItemCount - 1) {
                    this.adjustViewsLeftOrRight();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void layoutChildren() {
        boolean blockLayoutRequests = this.mBlockLayoutRequests;
        if (blockLayoutRequests) {
            return;
        }
        this.mBlockLayoutRequests = true;
        try {
            View sel;
            boolean dataChanged;
            super.layoutChildren();
            this.invalidate();
            if (this.mAdapter == null) {
                this.resetList();
                this.invokeOnItemScrollListener();
                return;
            }
            int childrenLeft = this.mListPadding.left;
            int childrenRight = this.getRight() - this.getLeft() - this.mListPadding.right;
            int childCount = this.getChildCount();
            int index = 0;
            int delta = 0;
            View oldSel = null;
            View oldFirst = null;
            View newSel = null;
            View focusLayoutRestoreView = null;
            switch (this.mLayoutMode) {
                case 2: {
                    index = this.mNextSelectedPosition - this.mFirstPosition;
                    if (index < 0 || index >= childCount) break;
                    newSel = this.getChildAt(index);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    index = this.mSelectedPosition - this.mFirstPosition;
                    if (index >= 0 && index < childCount) {
                        oldSel = this.getChildAt(index);
                    }
                    oldFirst = this.getChildAt(0);
                    if (this.mNextSelectedPosition >= 0) {
                        delta = this.mNextSelectedPosition - this.mSelectedPosition;
                    }
                    newSel = this.getChildAt(index + delta);
                }
            }
            if (dataChanged = this.mDataChanged) {
                this.handleDataChanged();
            }
            if (this.mItemCount == 0) {
                this.resetList();
                this.invokeOnItemScrollListener();
                return;
            }
            if (this.mItemCount != this.mAdapter.getCount()) {
                throw new IllegalStateException("The content of the adapter has changed but ListView did not receive a notification. Make sure the content of your adapter is not modified from a background thread, but only from the UI thread. [in ListView(" + this.getId() + ", " + ((Object)((Object)this)).getClass() + ") with Adapter(" + this.mAdapter.getClass() + ")]");
            }
            this.setSelectedPositionInt(this.mNextSelectedPosition);
            int firstPosition = this.mFirstPosition;
            AbsHListView.RecycleBin recycleBin = this.mRecycler;
            View focusLayoutRestoreDirectChild = null;
            if (dataChanged) {
                for (int i2 = 0; i2 < childCount; ++i2) {
                    recycleBin.addScrapView(this.getChildAt(i2), firstPosition + i2);
                }
            } else {
                recycleBin.fillActiveViews(childCount, firstPosition);
            }
            View focusedChild = this.getFocusedChild();
            if (focusedChild != null) {
                if (!dataChanged || this.isDirectChildHeaderOrFooter(focusedChild)) {
                    focusLayoutRestoreDirectChild = focusedChild;
                    focusLayoutRestoreView = this.findFocus();
                    if (focusLayoutRestoreView != null) {
                        focusLayoutRestoreView.onStartTemporaryDetach();
                    }
                }
                this.requestFocus();
            }
            this.detachAllViewsFromParent();
            recycleBin.removeSkippedScrap();
            switch (this.mLayoutMode) {
                case 2: {
                    if (newSel != null) {
                        sel = this.fillFromSelection(newSel.getLeft(), childrenLeft, childrenRight);
                        break;
                    }
                    sel = this.fillFromMiddle(childrenLeft, childrenRight);
                    break;
                }
                case 5: {
                    sel = this.fillSpecific(this.mSyncPosition, this.mSpecificLeft);
                    break;
                }
                case 3: {
                    sel = this.fillLeft(this.mItemCount - 1, childrenRight);
                    this.adjustViewsLeftOrRight();
                    break;
                }
                case 1: {
                    this.mFirstPosition = 0;
                    sel = this.fillFromLeft(childrenLeft);
                    this.adjustViewsLeftOrRight();
                    break;
                }
                case 4: {
                    sel = this.fillSpecific(this.reconcileSelectedPosition(), this.mSpecificLeft);
                    break;
                }
                case 6: {
                    sel = this.moveSelection(oldSel, newSel, delta, childrenLeft, childrenRight);
                    break;
                }
                default: {
                    if (childCount == 0) {
                        int position;
                        if (!this.mStackFromRight) {
                            position = this.lookForSelectablePosition(0, true);
                            this.setSelectedPositionInt(position);
                            sel = this.fillFromLeft(childrenLeft);
                            break;
                        }
                        position = this.lookForSelectablePosition(this.mItemCount - 1, false);
                        this.setSelectedPositionInt(position);
                        sel = this.fillLeft(this.mItemCount - 1, childrenRight);
                        break;
                    }
                    sel = this.mSelectedPosition >= 0 && this.mSelectedPosition < this.mItemCount ? this.fillSpecific(this.mSelectedPosition, oldSel == null ? childrenLeft : oldSel.getLeft()) : (this.mFirstPosition < this.mItemCount ? this.fillSpecific(this.mFirstPosition, oldFirst == null ? childrenLeft : oldFirst.getLeft()) : this.fillSpecific(0, childrenLeft));
                }
            }
            recycleBin.scrapActiveViews();
            if (sel != null) {
                if (this.mItemsCanFocus && this.hasFocus() && !sel.hasFocus()) {
                    boolean focusWasTaken;
                    boolean bl = focusWasTaken = sel == focusLayoutRestoreDirectChild && focusLayoutRestoreView != null && focusLayoutRestoreView.requestFocus() || sel.requestFocus();
                    if (!focusWasTaken) {
                        View focused = this.getFocusedChild();
                        if (focused != null) {
                            focused.clearFocus();
                        }
                        this.positionSelector(-1, sel);
                    } else {
                        sel.setSelected(false);
                        this.mSelectorRect.setEmpty();
                    }
                } else {
                    this.positionSelector(-1, sel);
                }
                this.mSelectedLeft = sel.getLeft();
            } else {
                if (this.mTouchMode > 0 && this.mTouchMode < 3) {
                    View child = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                    if (child != null) {
                        this.positionSelector(this.mMotionPosition, child);
                    }
                } else {
                    this.mSelectedLeft = 0;
                    this.mSelectorRect.setEmpty();
                }
                if (this.hasFocus() && focusLayoutRestoreView != null) {
                    focusLayoutRestoreView.requestFocus();
                }
            }
            if (focusLayoutRestoreView != null && focusLayoutRestoreView.getWindowToken() != null) {
                focusLayoutRestoreView.onFinishTemporaryDetach();
            }
            this.mLayoutMode = 0;
            this.mDataChanged = false;
            if (this.mPositionScrollAfterLayout != null) {
                this.post(this.mPositionScrollAfterLayout);
                this.mPositionScrollAfterLayout = null;
            }
            this.mNeedSync = false;
            this.setNextSelectedPositionInt(this.mSelectedPosition);
            this.updateScrollIndicators();
            if (this.mItemCount > 0) {
                this.checkSelectionChanged();
            }
            this.invokeOnItemScrollListener();
        }
        catch (Throwable throwable) {
            MLog.error((Object)"HListView", (String)("layoutChildren error! " + throwable), (Object[])new Object[0]);
        }
        finally {
            if (!blockLayoutRequests) {
                this.mBlockLayoutRequests = false;
            }
        }
    }

    private View findAccessibilityFocusedChild(View focusedView) {
        ViewParent viewParent;
        for (viewParent = focusedView.getParent(); viewParent instanceof View && viewParent != this; viewParent = viewParent.getParent()) {
            focusedView = (View)viewParent;
        }
        if (!(viewParent instanceof View)) {
            return null;
        }
        return focusedView;
    }

    private boolean isDirectChildHeaderOrFooter(View child) {
        ArrayList<HeaderViewListAdapter.FixedViewInfo> headers = this.mHeaderViewInfos;
        int numHeaders = headers.size();
        for (int i2 = 0; i2 < numHeaders; ++i2) {
            if (child != headers.get((int)i2).view) continue;
            return true;
        }
        ArrayList<HeaderViewListAdapter.FixedViewInfo> footers = this.mFooterViewInfos;
        int numFooters = footers.size();
        for (int i3 = 0; i3 < numFooters; ++i3) {
            if (child != footers.get((int)i3).view) continue;
            return true;
        }
        return false;
    }

    private View makeAndAddView(int position, int x, boolean flow, int childrenTop, boolean selected) {
        View child;
        if (!this.mDataChanged && (child = this.mRecycler.getActiveView(position)) != null) {
            this.setupChild(child, position, x, flow, childrenTop, selected, true);
            return child;
        }
        child = this.obtainView(position, this.mIsScrap);
        this.setupChild(child, position, x, flow, childrenTop, selected, this.mIsScrap[0]);
        return child;
    }

    @TargetApi(value=11)
    private void setupChild(View child, int position, int x, boolean flowDown, int childrenTop, boolean selected, boolean recycled) {
        int childLeft;
        boolean isSelected = selected && this.shouldShowSelector();
        boolean updateChildSelected = isSelected != child.isSelected();
        int mode = this.mTouchMode;
        boolean isPressed = mode > 0 && mode < 3 && this.mMotionPosition == position;
        boolean updateChildPressed = isPressed != child.isPressed();
        boolean needToMeasure = !recycled || updateChildSelected || child.isLayoutRequested();
        AbsHListView.LayoutParams p = (AbsHListView.LayoutParams)child.getLayoutParams();
        if (p == null) {
            p = (AbsHListView.LayoutParams)this.generateDefaultLayoutParams();
        }
        p.viewType = this.mAdapter.getItemViewType(position);
        if (recycled && !p.forceAdd || p.recycledHeaderFooter && p.viewType == -2) {
            this.attachViewToParent(child, flowDown ? -1 : 0, p);
        } else {
            p.forceAdd = false;
            if (p.viewType == -2) {
                p.recycledHeaderFooter = true;
            }
            this.addViewInLayout(child, flowDown ? -1 : 0, p, true);
        }
        if (updateChildSelected) {
            child.setSelected(isSelected);
        }
        if (updateChildPressed) {
            child.setPressed(isPressed);
        }
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            if (child instanceof Checkable) {
                ((Checkable)child).setChecked(((Boolean)this.mCheckStates.get(position, (Object)false)).booleanValue());
            } else if (Build.VERSION.SDK_INT >= 11) {
                child.setActivated(((Boolean)this.mCheckStates.get(position, (Object)false)).booleanValue());
            }
        }
        if (needToMeasure) {
            int childHeightSpec = ViewGroup.getChildMeasureSpec((int)this.mHeightMeasureSpec, (int)(this.mListPadding.top + this.mListPadding.bottom), (int)p.height);
            int lpWidth = p.width;
            int childWidthSpec = lpWidth > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpWidth, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            child.measure(childWidthSpec, childHeightSpec);
        } else {
            this.cleanupLayoutState(child);
        }
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        int n = childLeft = flowDown ? x : x - w;
        if (needToMeasure) {
            int childBottom = childrenTop + h;
            int childRight = childLeft + w;
            child.layout(childLeft, childrenTop, childRight, childBottom);
        } else {
            child.offsetLeftAndRight(childLeft - child.getLeft());
            child.offsetTopAndBottom(childrenTop - child.getTop());
        }
        if (this.mCachingStarted && !child.isDrawingCacheEnabled()) {
            child.setDrawingCacheEnabled(true);
        }
        if (Build.VERSION.SDK_INT >= 11 && recycled && ((AbsHListView.LayoutParams)child.getLayoutParams()).scrappedFromPosition != position) {
            child.jumpDrawablesToCurrentState();
        }
    }

    @Override
    protected boolean canAnimate() {
        return super.canAnimate() && this.mItemCount > 0;
    }

    @Override
    public void setSelection(int position) {
        this.setSelectionFromLeft(position, 0);
    }

    public void setSelectionFromLeft(int position, int x) {
        if (this.mAdapter == null) {
            return;
        }
        if (!this.isInTouchMode()) {
            if ((position = this.lookForSelectablePosition(position, true)) >= 0) {
                this.setNextSelectedPositionInt(position);
            }
        } else {
            this.mResurrectToPosition = position;
        }
        if (position >= 0) {
            this.mLayoutMode = 4;
            this.mSpecificLeft = this.mListPadding.left + x;
            if (this.mNeedSync) {
                this.mSyncPosition = position;
                this.mSyncColId = this.mAdapter.getItemId(position);
            }
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
            this.requestLayout();
        }
    }

    @Override
    public void setSelectionInt(int position) {
        this.setNextSelectedPositionInt(position);
        boolean awakeScrollbars = false;
        int selectedPosition = this.mSelectedPosition;
        if (selectedPosition >= 0) {
            if (position == selectedPosition - 1) {
                awakeScrollbars = true;
            } else if (position == selectedPosition + 1) {
                awakeScrollbars = true;
            }
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.layoutChildren();
        if (awakeScrollbars) {
            this.awakenScrollBars();
        }
    }

    @Override
    protected int lookForSelectablePosition(int position, boolean lookDown) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null || this.isInTouchMode()) {
            return -1;
        }
        int count = adapter.getCount();
        if (!this.mAreAllItemsSelectable) {
            if (lookDown) {
                for (position = Math.max(0, position); position < count && !adapter.isEnabled(position); ++position) {
                }
            } else {
                for (position = Math.min(position, count - 1); position >= 0 && !adapter.isEnabled(position); --position) {
                }
            }
            if (position < 0 || position >= count) {
                return -1;
            }
            return position;
        }
        if (position < 0 || position >= count) {
            return -1;
        }
        return position;
    }

    public void setSelectionAfterHeaderView() {
        int count = this.mHeaderViewInfos.size();
        if (count > 0) {
            this.mNextSelectedPosition = 0;
            return;
        }
        if (this.mAdapter != null) {
            this.setSelection(count);
        } else {
            this.mNextSelectedPosition = count;
            this.mLayoutMode = 2;
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        View focused;
        boolean handled = super.dispatchKeyEvent(event);
        if (!handled && (focused = this.getFocusedChild()) != null && event.getAction() == 0) {
            handled = this.onKeyDown(event.getKeyCode(), event);
        }
        return handled;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return this.commonKey(keyCode, 1, event);
    }

    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return this.commonKey(keyCode, repeatCount, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.commonKey(keyCode, 1, event);
    }

    @TargetApi(value=11)
    private boolean commonKey(int keyCode, int count, KeyEvent event) {
        if (this.mAdapter == null || !this.mIsAttached) {
            return false;
        }
        if (this.mDataChanged) {
            this.layoutChildren();
        }
        if (Build.VERSION.SDK_INT < 11) {
            return false;
        }
        boolean handled = false;
        int action2 = event.getAction();
        if (action2 != 1) {
            switch (keyCode) {
                case 21: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded();
                        if (handled) break;
                        while (count-- > 0 && this.arrowScroll(33)) {
                            handled = true;
                        }
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(33);
                    break;
                }
                case 22: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded();
                        if (handled) break;
                        while (count-- > 0 && this.arrowScroll(130)) {
                            handled = true;
                        }
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(130);
                    break;
                }
                case 19: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.handleHorizontalFocusWithinListItem(33);
                    break;
                }
                case 20: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.handleHorizontalFocusWithinListItem(130);
                    break;
                }
                case 23: 
                case 66: {
                    if (!event.hasNoModifiers() || (handled = this.resurrectSelectionIfNeeded()) || event.getRepeatCount() != 0 || this.getChildCount() <= 0) break;
                    this.keyPressed();
                    handled = true;
                    break;
                }
                case 62: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.pageScroll(130);
                    } else if (event.hasModifiers(1)) {
                        handled = this.resurrectSelectionIfNeeded() || this.pageScroll(33);
                    }
                    handled = true;
                    break;
                }
                case 92: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.pageScroll(33);
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(33);
                    break;
                }
                case 93: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.pageScroll(130);
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(130);
                    break;
                }
                case 122: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(33);
                    break;
                }
                case 123: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(130);
                    break;
                }
                case 61: {
                    break;
                }
            }
        }
        if (handled) {
            return true;
        }
        switch (action2) {
            case 0: {
                return super.onKeyDown(keyCode, event);
            }
            case 1: {
                return super.onKeyUp(keyCode, event);
            }
            case 2: {
                return super.onKeyMultiple(keyCode, count, event);
            }
        }
        return false;
    }

    boolean pageScroll(int direction) {
        int position;
        int nextPage = -1;
        boolean down = false;
        if (direction == 33) {
            nextPage = Math.max(0, this.mSelectedPosition - this.getChildCount() - 1);
        } else if (direction == 130) {
            nextPage = Math.min(this.mItemCount - 1, this.mSelectedPosition + this.getChildCount() - 1);
            down = true;
        }
        if (nextPage >= 0 && (position = this.lookForSelectablePosition(nextPage, down)) >= 0) {
            this.mLayoutMode = 4;
            this.mSpecificLeft = this.getPaddingLeft() + this.getHorizontalFadingEdgeLength();
            if (down && position > this.mItemCount - this.getChildCount()) {
                this.mLayoutMode = 3;
            }
            if (!down && position < this.getChildCount()) {
                this.mLayoutMode = 1;
            }
            this.setSelectionInt(position);
            this.invokeOnItemScrollListener();
            if (!this.awakenScrollBars()) {
                this.invalidate();
            }
            return true;
        }
        return false;
    }

    boolean fullScroll(int direction) {
        boolean moved = false;
        if (direction == 33) {
            if (this.mSelectedPosition != 0) {
                int position = this.lookForSelectablePosition(0, true);
                if (position >= 0) {
                    this.mLayoutMode = 1;
                    this.setSelectionInt(position);
                    this.invokeOnItemScrollListener();
                }
                moved = true;
            }
        } else if (direction == 130 && this.mSelectedPosition < this.mItemCount - 1) {
            int position = this.lookForSelectablePosition(this.mItemCount - 1, true);
            if (position >= 0) {
                this.mLayoutMode = 3;
                this.setSelectionInt(position);
                this.invokeOnItemScrollListener();
            }
            moved = true;
        }
        if (moved && !this.awakenScrollBars()) {
            this.awakenScrollBars();
            this.invalidate();
        }
        return moved;
    }

    private boolean handleHorizontalFocusWithinListItem(int direction) {
        View selectedView;
        if (direction != 33 && direction != 130) {
            throw new IllegalArgumentException("direction must be one of {View.FOCUS_UP, View.FOCUS_DOWN}");
        }
        int numChildren = this.getChildCount();
        if (this.mItemsCanFocus && numChildren > 0 && this.mSelectedPosition != -1 && (selectedView = this.getSelectedView()) != null && selectedView.hasFocus() && selectedView instanceof ViewGroup) {
            View globalNextFocus;
            View currentFocus = selectedView.findFocus();
            View nextFocus = FocusFinder.getInstance().findNextFocus((ViewGroup)selectedView, currentFocus, direction);
            if (nextFocus != null) {
                currentFocus.getFocusedRect(this.mTempRect);
                this.offsetDescendantRectToMyCoords(currentFocus, this.mTempRect);
                this.offsetRectIntoDescendantCoords(nextFocus, this.mTempRect);
                if (nextFocus.requestFocus(direction, this.mTempRect)) {
                    return true;
                }
            }
            if ((globalNextFocus = FocusFinder.getInstance().findNextFocus((ViewGroup)this.getRootView(), currentFocus, direction)) != null) {
                return this.isViewAncestorOf(globalNextFocus, (View)this);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean arrowScroll(int direction) {
        try {
            this.mInLayout = true;
            boolean handled = this.arrowScrollImpl(direction);
            if (handled) {
                this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)direction));
            }
            boolean bl = handled;
            return bl;
        }
        finally {
            this.mInLayout = false;
        }
    }

    private boolean arrowScrollImpl(int direction) {
        View focused;
        boolean needToRedraw;
        ArrowScrollFocusResult focusResult;
        if (this.getChildCount() <= 0) {
            return false;
        }
        View selectedView = this.getSelectedView();
        int selectedPos = this.mSelectedPosition;
        int nextSelectedPosition = this.lookForSelectablePositionOnScreen(direction);
        int amountToScroll = this.amountToScroll(direction, nextSelectedPosition);
        ArrowScrollFocusResult arrowScrollFocusResult = focusResult = this.mItemsCanFocus ? this.arrowScrollFocused(direction) : null;
        if (focusResult != null) {
            nextSelectedPosition = focusResult.getSelectedPosition();
            amountToScroll = focusResult.getAmountToScroll();
        }
        boolean bl = needToRedraw = focusResult != null;
        if (nextSelectedPosition != -1) {
            this.handleNewSelectionChange(selectedView, direction, nextSelectedPosition, focusResult != null);
            this.setSelectedPositionInt(nextSelectedPosition);
            this.setNextSelectedPositionInt(nextSelectedPosition);
            selectedView = this.getSelectedView();
            selectedPos = nextSelectedPosition;
            if (this.mItemsCanFocus && focusResult == null && (focused = this.getFocusedChild()) != null) {
                focused.clearFocus();
            }
            needToRedraw = true;
            this.checkSelectionChanged();
        }
        if (amountToScroll > 0) {
            this.scrollListItemsBy(direction == 33 ? amountToScroll : -amountToScroll);
            needToRedraw = true;
        }
        if (this.mItemsCanFocus && focusResult == null && selectedView != null && selectedView.hasFocus() && (!this.isViewAncestorOf(focused = selectedView.findFocus(), (View)this) || this.distanceToView(focused) > 0)) {
            focused.clearFocus();
        }
        if (nextSelectedPosition == -1 && selectedView != null && !this.isViewAncestorOf(selectedView, (View)this)) {
            selectedView = null;
            this.hideSelector();
            this.mResurrectToPosition = -1;
        }
        if (needToRedraw) {
            if (selectedView != null) {
                this.positionSelector(selectedPos, selectedView);
                this.mSelectedLeft = selectedView.getLeft();
            }
            if (!this.awakenScrollBars()) {
                this.invalidate();
            }
            this.invokeOnItemScrollListener();
            return true;
        }
        return false;
    }

    private void handleNewSelectionChange(View selectedView, int direction, int newSelectedPosition, boolean newFocusAssigned) {
        View rightView;
        View leftView;
        int rightViewIndex;
        int leftViewIndex;
        if (newSelectedPosition == -1) {
            throw new IllegalArgumentException("newSelectedPosition needs to be valid");
        }
        boolean leftSelected = false;
        int selectedIndex = this.mSelectedPosition - this.mFirstPosition;
        int nextSelectedIndex = newSelectedPosition - this.mFirstPosition;
        if (direction == 33) {
            leftViewIndex = nextSelectedIndex;
            rightViewIndex = selectedIndex;
            leftView = this.getChildAt(leftViewIndex);
            rightView = selectedView;
            leftSelected = true;
        } else {
            leftViewIndex = selectedIndex;
            rightViewIndex = nextSelectedIndex;
            leftView = selectedView;
            rightView = this.getChildAt(rightViewIndex);
        }
        int numChildren = this.getChildCount();
        if (leftView != null) {
            leftView.setSelected(!newFocusAssigned && leftSelected);
            this.measureAndAdjustRight(leftView, leftViewIndex, numChildren);
        }
        if (rightView != null) {
            rightView.setSelected(!newFocusAssigned && !leftSelected);
            this.measureAndAdjustRight(rightView, rightViewIndex, numChildren);
        }
    }

    private void measureAndAdjustRight(View child, int childIndex, int numChildren) {
        int oldWidth = child.getWidth();
        this.measureItem(child);
        if (child.getMeasuredWidth() != oldWidth) {
            this.relayoutMeasuredItem(child);
            int widthDelta = child.getMeasuredWidth() - oldWidth;
            for (int i2 = childIndex + 1; i2 < numChildren; ++i2) {
                this.getChildAt(i2).offsetLeftAndRight(widthDelta);
            }
        }
    }

    private void measureItem(View child) {
        ViewGroup.LayoutParams p = child.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-2, -1);
        }
        int childHeightSpec = ViewGroup.getChildMeasureSpec((int)this.mHeightMeasureSpec, (int)(this.mListPadding.top + this.mListPadding.bottom), (int)p.height);
        int lpWidth = p.width;
        int childWidthSpec = lpWidth > 0 ? View.MeasureSpec.makeMeasureSpec((int)lpWidth, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    private void relayoutMeasuredItem(View child) {
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        int childTop = this.mListPadding.top;
        int childBottom = childTop + h;
        int childLeft = child.getLeft();
        int childRight = childLeft + w;
        child.layout(childLeft, childTop, childRight, childBottom);
    }

    private int getArrowScrollPreviewLength() {
        return Math.max(2, this.getHorizontalFadingEdgeLength());
    }

    private int amountToScroll(int direction, int nextSelectedPosition) {
        int listRight = this.getWidth() - this.mListPadding.right;
        int listLeft = this.mListPadding.left;
        int numChildren = this.getChildCount();
        if (direction == 130) {
            int indexToMakeVisible = numChildren - 1;
            if (nextSelectedPosition != -1) {
                indexToMakeVisible = nextSelectedPosition - this.mFirstPosition;
            }
            int positionToMakeVisible = this.mFirstPosition + indexToMakeVisible;
            View viewToMakeVisible = this.getChildAt(indexToMakeVisible);
            int goalRight = listRight;
            if (positionToMakeVisible < this.mItemCount - 1) {
                goalRight -= this.getArrowScrollPreviewLength();
            }
            if (viewToMakeVisible.getRight() <= goalRight) {
                return 0;
            }
            if (nextSelectedPosition != -1 && goalRight - viewToMakeVisible.getLeft() >= this.getMaxScrollAmount()) {
                return 0;
            }
            int amountToScroll = viewToMakeVisible.getRight() - goalRight;
            if (this.mFirstPosition + numChildren == this.mItemCount) {
                int max = this.getChildAt(numChildren - 1).getRight() - listRight;
                amountToScroll = Math.min(amountToScroll, max);
            }
            return Math.min(amountToScroll, this.getMaxScrollAmount());
        }
        int indexToMakeVisible = 0;
        if (nextSelectedPosition != -1) {
            indexToMakeVisible = nextSelectedPosition - this.mFirstPosition;
        }
        int positionToMakeVisible = this.mFirstPosition + indexToMakeVisible;
        View viewToMakeVisible = this.getChildAt(indexToMakeVisible);
        int goalLeft = listLeft;
        if (positionToMakeVisible > 0) {
            goalLeft += this.getArrowScrollPreviewLength();
        }
        if (viewToMakeVisible.getLeft() >= goalLeft) {
            return 0;
        }
        if (nextSelectedPosition != -1 && viewToMakeVisible.getRight() - goalLeft >= this.getMaxScrollAmount()) {
            return 0;
        }
        int amountToScroll = goalLeft - viewToMakeVisible.getLeft();
        if (this.mFirstPosition == 0) {
            int max = listLeft - this.getChildAt(0).getLeft();
            amountToScroll = Math.min(amountToScroll, max);
        }
        return Math.min(amountToScroll, this.getMaxScrollAmount());
    }

    private int lookForSelectablePositionOnScreen(int direction) {
        int firstPosition = this.mFirstPosition;
        if (direction == 130) {
            int startPos;
            int n = startPos = this.mSelectedPosition != -1 ? this.mSelectedPosition + 1 : firstPosition;
            if (startPos >= this.mAdapter.getCount()) {
                return -1;
            }
            if (startPos < firstPosition) {
                startPos = firstPosition;
            }
            int lastVisiblePos = this.getLastVisiblePosition();
            ListAdapter adapter = this.getAdapter();
            for (int pos = startPos; pos <= lastVisiblePos; ++pos) {
                if (!adapter.isEnabled(pos) || this.getChildAt(pos - firstPosition).getVisibility() != 0) continue;
                return pos;
            }
        } else {
            int startPos;
            int last = firstPosition + this.getChildCount() - 1;
            int n = startPos = this.mSelectedPosition != -1 ? this.mSelectedPosition - 1 : firstPosition + this.getChildCount() - 1;
            if (startPos < 0 || startPos >= this.mAdapter.getCount()) {
                return -1;
            }
            if (startPos > last) {
                startPos = last;
            }
            ListAdapter adapter = this.getAdapter();
            for (int pos = startPos; pos >= firstPosition; --pos) {
                if (!adapter.isEnabled(pos) || this.getChildAt(pos - firstPosition).getVisibility() != 0) continue;
                return pos;
            }
        }
        return -1;
    }

    private ArrowScrollFocusResult arrowScrollFocused(int direction) {
        View newFocus;
        View selectedView = this.getSelectedView();
        if (selectedView != null && selectedView.hasFocus()) {
            View oldFocus = selectedView.findFocus();
            newFocus = FocusFinder.getInstance().findNextFocus((ViewGroup)this, oldFocus, direction);
        } else {
            int xSearchPoint;
            if (direction == 130) {
                boolean leftFadingEdgeShowing = this.mFirstPosition > 0;
                int listLeft = this.mListPadding.left + (leftFadingEdgeShowing ? this.getArrowScrollPreviewLength() : 0);
                xSearchPoint = selectedView != null && selectedView.getLeft() > listLeft ? selectedView.getLeft() : listLeft;
                this.mTempRect.set(xSearchPoint, 0, xSearchPoint, 0);
            } else {
                boolean rightFadingEdgeShowing = this.mFirstPosition + this.getChildCount() - 1 < this.mItemCount;
                int listRight = this.getWidth() - this.mListPadding.right - (rightFadingEdgeShowing ? this.getArrowScrollPreviewLength() : 0);
                xSearchPoint = selectedView != null && selectedView.getRight() < listRight ? selectedView.getRight() : listRight;
                this.mTempRect.set(xSearchPoint, 0, xSearchPoint, 0);
            }
            newFocus = FocusFinder.getInstance().findNextFocusFromRect((ViewGroup)this, this.mTempRect, direction);
        }
        if (newFocus != null) {
            int maxScrollAmount;
            int selectablePosition;
            int positionOfNewFocus = this.positionOfNewFocus(newFocus);
            if (this.mSelectedPosition != -1 && positionOfNewFocus != this.mSelectedPosition && (selectablePosition = this.lookForSelectablePositionOnScreen(direction)) != -1 && (direction == 130 && selectablePosition < positionOfNewFocus || direction == 33 && selectablePosition > positionOfNewFocus)) {
                return null;
            }
            int focusScroll = this.amountToScrollToNewFocus(direction, newFocus, positionOfNewFocus);
            if (focusScroll < (maxScrollAmount = this.getMaxScrollAmount())) {
                newFocus.requestFocus(direction);
                this.mArrowScrollFocusResult.populate(positionOfNewFocus, focusScroll);
                return this.mArrowScrollFocusResult;
            }
            if (this.distanceToView(newFocus) < maxScrollAmount) {
                newFocus.requestFocus(direction);
                this.mArrowScrollFocusResult.populate(positionOfNewFocus, maxScrollAmount);
                return this.mArrowScrollFocusResult;
            }
        }
        return null;
    }

    private int positionOfNewFocus(View newFocus) {
        int numChildren = this.getChildCount();
        for (int i2 = 0; i2 < numChildren; ++i2) {
            View child = this.getChildAt(i2);
            if (!this.isViewAncestorOf(newFocus, child)) continue;
            return this.mFirstPosition + i2;
        }
        throw new IllegalArgumentException("newFocus is not a child of any of the children of the list!");
    }

    private boolean isViewAncestorOf(View child, View parent) {
        if (child == parent) {
            return true;
        }
        ViewParent theParent = child.getParent();
        return theParent instanceof ViewGroup && this.isViewAncestorOf((View)theParent, parent);
    }

    private int amountToScrollToNewFocus(int direction, View newFocus, int positionOfNewFocus) {
        int amountToScroll = 0;
        newFocus.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(newFocus, this.mTempRect);
        if (direction == 33) {
            if (this.mTempRect.left < this.mListPadding.left) {
                amountToScroll = this.mListPadding.left - this.mTempRect.left;
                if (positionOfNewFocus > 0) {
                    amountToScroll += this.getArrowScrollPreviewLength();
                }
            }
        } else {
            int listRight = this.getWidth() - this.mListPadding.right;
            if (this.mTempRect.bottom > listRight) {
                amountToScroll = this.mTempRect.right - listRight;
                if (positionOfNewFocus < this.mItemCount - 1) {
                    amountToScroll += this.getArrowScrollPreviewLength();
                }
            }
        }
        return amountToScroll;
    }

    private int distanceToView(View descendant) {
        int distance = 0;
        descendant.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(descendant, this.mTempRect);
        int listRight = this.getRight() - this.getLeft() - this.mListPadding.right;
        if (this.mTempRect.right < this.mListPadding.left) {
            distance = this.mListPadding.left - this.mTempRect.right;
        } else if (this.mTempRect.left > listRight) {
            distance = this.mTempRect.left - listRight;
        }
        return distance;
    }

    private void scrollListItemsBy(int amount) {
        this.offsetChildrenLeftAndRight(amount);
        int listRight = this.getWidth() - this.mListPadding.right;
        int listLeft = this.mListPadding.left;
        AbsHListView.RecycleBin recycleBin = this.mRecycler;
        if (amount < 0) {
            int lastVisiblePosition;
            int numChildren = this.getChildCount();
            View last = this.getChildAt(numChildren - 1);
            while (last.getRight() < listRight && (lastVisiblePosition = this.mFirstPosition + numChildren - 1) < this.mItemCount - 1) {
                last = this.addViewAfter(last, lastVisiblePosition);
                ++numChildren;
            }
            if (last.getBottom() < listRight) {
                this.offsetChildrenLeftAndRight(listRight - last.getRight());
            }
            View first = this.getChildAt(0);
            while (first.getRight() < listLeft) {
                AbsHListView.LayoutParams layoutParams = (AbsHListView.LayoutParams)first.getLayoutParams();
                if (recycleBin.shouldRecycleViewType(layoutParams.viewType)) {
                    this.detachViewFromParent(first);
                    recycleBin.addScrapView(first, this.mFirstPosition);
                } else {
                    this.removeViewInLayout(first);
                }
                first = this.getChildAt(0);
                ++this.mFirstPosition;
            }
        } else {
            View first = this.getChildAt(0);
            while (first.getLeft() > listLeft && this.mFirstPosition > 0) {
                first = this.addViewBefore(first, this.mFirstPosition);
                --this.mFirstPosition;
            }
            if (first.getLeft() > listLeft) {
                this.offsetChildrenLeftAndRight(listLeft - first.getLeft());
            }
            int lastIndex = this.getChildCount() - 1;
            View last = this.getChildAt(lastIndex);
            while (last.getLeft() > listRight) {
                AbsHListView.LayoutParams layoutParams = (AbsHListView.LayoutParams)last.getLayoutParams();
                if (recycleBin.shouldRecycleViewType(layoutParams.viewType)) {
                    this.detachViewFromParent(last);
                    recycleBin.addScrapView(last, this.mFirstPosition + lastIndex);
                } else {
                    this.removeViewInLayout(last);
                }
                last = this.getChildAt(--lastIndex);
            }
        }
    }

    private View addViewBefore(View theView, int position) {
        int abovePosition = position - 1;
        View view = this.obtainView(abovePosition, this.mIsScrap);
        int edgeOfNewChild = theView.getLeft() - this.mDividerWidth;
        this.setupChild(view, abovePosition, edgeOfNewChild, false, this.mListPadding.top, false, this.mIsScrap[0]);
        return view;
    }

    private View addViewAfter(View theView, int position) {
        int belowPosition = position + 1;
        View view = this.obtainView(belowPosition, this.mIsScrap);
        int edgeOfNewChild = theView.getRight() + this.mDividerWidth;
        this.setupChild(view, belowPosition, edgeOfNewChild, true, this.mListPadding.top, false, this.mIsScrap[0]);
        return view;
    }

    public void setItemsCanFocus(boolean itemsCanFocus) {
        this.mItemsCanFocus = itemsCanFocus;
        if (!itemsCanFocus) {
            this.setDescendantFocusability(393216);
        }
    }

    public boolean getItemsCanFocus() {
        return this.mItemsCanFocus;
    }

    public boolean isOpaque() {
        boolean retValue;
        boolean bl = retValue = this.mCachingActive && this.mIsCacheColorOpaque && this.mDividerIsOpaque || super.isOpaque();
        if (retValue) {
            int listLeft = this.mListPadding != null ? this.mListPadding.left : this.getPaddingLeft();
            View first = this.getChildAt(0);
            if (first == null || first.getLeft() > listLeft) {
                return false;
            }
            int listRight = this.getWidth() - (this.mListPadding != null ? this.mListPadding.right : this.getPaddingRight());
            View last = this.getChildAt(this.getChildCount() - 1);
            if (last == null || last.getRight() < listRight) {
                return false;
            }
        }
        return retValue;
    }

    @Override
    public void setCacheColorHint(int color2) {
        boolean opaque;
        this.mIsCacheColorOpaque = opaque = color2 >>> 24 == 255;
        if (opaque) {
            if (this.mDividerPaint == null) {
                this.mDividerPaint = new Paint();
            }
            this.mDividerPaint.setColor(color2);
        }
        super.setCacheColorHint(color2);
    }

    void drawOverscrollHeader(Canvas canvas, Drawable drawable2, Rect bounds) {
        int width = drawable2.getMinimumWidth();
        canvas.save();
        canvas.clipRect(bounds);
        int span = bounds.right - bounds.left;
        if (span < width) {
            bounds.left = bounds.right - width;
        }
        drawable2.setBounds(bounds);
        drawable2.draw(canvas);
        canvas.restore();
    }

    void drawOverscrollFooter(Canvas canvas, Drawable drawable2, Rect bounds) {
        int width = drawable2.getMinimumWidth();
        canvas.save();
        canvas.clipRect(bounds);
        int span = bounds.right - bounds.left;
        if (span < width) {
            bounds.right = bounds.left + width;
        }
        drawable2.setBounds(bounds);
        drawable2.draw(canvas);
        canvas.restore();
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        boolean drawDividers;
        if (this.mCachingStarted) {
            this.mCachingActive = true;
        }
        int dividerWidth = this.mDividerWidth;
        Drawable overscrollHeader = this.mOverScrollHeader;
        Drawable overscrollFooter = this.mOverScrollFooter;
        boolean drawOverscrollHeader = overscrollHeader != null;
        boolean drawOverscrollFooter = overscrollFooter != null;
        boolean bl = drawDividers = dividerWidth > 0 && this.mDivider != null;
        if (drawDividers || drawOverscrollHeader || drawOverscrollFooter) {
            boolean fillForMissingDividers;
            Rect bounds = this.mTempRect;
            bounds.top = this.getPaddingTop();
            bounds.bottom = this.getBottom() - this.getTop() - this.getPaddingBottom();
            int count = this.getChildCount();
            int headerCount = this.mHeaderViewInfos.size();
            int itemCount = this.mItemCount;
            int footerLimit = itemCount - this.mFooterViewInfos.size() - 1;
            boolean headerDividers = this.mHeaderDividersEnabled;
            boolean footerDividers = this.mFooterDividersEnabled;
            int first = this.mFirstPosition;
            boolean areAllItemsSelectable = this.mAreAllItemsSelectable;
            ListAdapter adapter = this.mAdapter;
            boolean bl2 = fillForMissingDividers = this.isOpaque() && !super.isOpaque();
            if (fillForMissingDividers && this.mDividerPaint == null && this.mIsCacheColorOpaque) {
                this.mDividerPaint = new Paint();
                this.mDividerPaint.setColor(this.getCacheColorHint());
            }
            Paint paint = this.mDividerPaint;
            int effectivePaddingLeft = 0;
            int effectivePaddingRight = 0;
            int listRight = this.getRight() - this.getLeft() - effectivePaddingRight + this.getScrollX();
            if (!this.mStackFromRight) {
                int right = 0;
                int scrollX = this.getScrollX();
                if (count > 0 && scrollX < 0) {
                    if (drawOverscrollHeader) {
                        bounds.right = 0;
                        bounds.left = scrollX;
                        this.drawOverscrollHeader(canvas, overscrollHeader, bounds);
                    } else if (drawDividers) {
                        bounds.right = 0;
                        bounds.left = -dividerWidth;
                        this.drawDivider(canvas, bounds, -1);
                    }
                }
                for (int i2 = 0; i2 < count; ++i2) {
                    if (!headerDividers && first + i2 < headerCount || !footerDividers && first + i2 >= footerLimit) continue;
                    View child = this.getChildAt(i2);
                    right = child.getRight();
                    if (!drawDividers || right >= listRight || drawOverscrollFooter && i2 == count - 1) continue;
                    if (areAllItemsSelectable || adapter.isEnabled(first + i2) && (i2 == count - 1 || adapter.isEnabled(first + i2 + 1))) {
                        bounds.left = right;
                        bounds.right = right + dividerWidth;
                        this.drawDivider(canvas, bounds, i2);
                        continue;
                    }
                    if (!fillForMissingDividers) continue;
                    bounds.left = right;
                    bounds.right = right + dividerWidth;
                    canvas.drawRect(bounds, paint);
                }
                int overFooterBottom = this.getRight() + this.getScrollX();
                if (drawOverscrollFooter && first + count == itemCount && overFooterBottom > right) {
                    bounds.left = right;
                    bounds.right = overFooterBottom;
                    this.drawOverscrollFooter(canvas, overscrollFooter, bounds);
                }
            } else {
                int start;
                int scrollX = this.getScrollX();
                if (count > 0 && drawOverscrollHeader) {
                    bounds.left = scrollX;
                    bounds.right = this.getChildAt(0).getLeft();
                    this.drawOverscrollHeader(canvas, overscrollHeader, bounds);
                }
                for (int i3 = start = drawOverscrollHeader ? 1 : 0; i3 < count; ++i3) {
                    View child;
                    int left;
                    if (!headerDividers && first + i3 < headerCount || !footerDividers && first + i3 >= footerLimit || (left = (child = this.getChildAt(i3)).getLeft()) <= effectivePaddingLeft) continue;
                    if (areAllItemsSelectable || adapter.isEnabled(first + i3) && (i3 == count - 1 || adapter.isEnabled(first + i3 + 1))) {
                        bounds.left = left - dividerWidth;
                        bounds.right = left;
                        this.drawDivider(canvas, bounds, i3 - 1);
                        continue;
                    }
                    if (!fillForMissingDividers) continue;
                    bounds.left = left - dividerWidth;
                    bounds.right = left;
                    canvas.drawRect(bounds, paint);
                }
                if (count > 0 && scrollX > 0) {
                    if (drawOverscrollFooter) {
                        int absListRight;
                        bounds.left = absListRight = this.getRight();
                        bounds.right = absListRight + scrollX;
                        this.drawOverscrollFooter(canvas, overscrollFooter, bounds);
                    } else if (drawDividers) {
                        bounds.left = listRight;
                        bounds.right = listRight + dividerWidth;
                        this.drawDivider(canvas, bounds, -1);
                    }
                }
            }
        }
        super.dispatchDraw(canvas);
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean more = super.drawChild(canvas, child, drawingTime);
        if (this.mCachingActive) {
            this.mCachingActive = false;
        }
        return more;
    }

    void drawDivider(Canvas canvas, Rect bounds, int childIndex) {
        Drawable divider = this.mDivider;
        divider.setBounds(bounds);
        divider.draw(canvas);
    }

    public Drawable getDivider() {
        return this.mDivider;
    }

    public void setDivider(Drawable divider) {
        this.mDividerWidth = divider != null ? divider.getIntrinsicWidth() : 0;
        this.mDivider = divider;
        this.mDividerIsOpaque = divider == null || divider.getOpacity() == -1;
        this.requestLayout();
        this.invalidate();
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    public void setDividerWidth(int width) {
        this.mDividerWidth = width;
        this.requestLayout();
        this.invalidate();
    }

    public void setHeaderDividersEnabled(boolean headerDividersEnabled) {
        this.mHeaderDividersEnabled = headerDividersEnabled;
        this.invalidate();
    }

    public void setFooterDividersEnabled(boolean footerDividersEnabled) {
        this.mFooterDividersEnabled = footerDividersEnabled;
        this.invalidate();
    }

    public void setOverscrollHeader(Drawable header) {
        this.mOverScrollHeader = header;
        if (this.getScrollX() < 0) {
            this.invalidate();
        }
    }

    public Drawable getOverscrollHeader() {
        return this.mOverScrollHeader;
    }

    public void setOverscrollFooter(Drawable footer) {
        this.mOverScrollFooter = footer;
        this.invalidate();
    }

    public Drawable getOverscrollFooter() {
        return this.mOverScrollFooter;
    }

    @Override
    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        ListAdapter adapter = this.mAdapter;
        int closetChildIndex = -1;
        int closestChildLeft = 0;
        if (adapter != null && gainFocus && previouslyFocusedRect != null) {
            previouslyFocusedRect.offset(this.getScrollX(), this.getScrollY());
            if (adapter.getCount() < this.getChildCount() + this.mFirstPosition) {
                this.mLayoutMode = 0;
                this.layoutChildren();
            }
            Rect otherRect = this.mTempRect;
            int minDistance = Integer.MAX_VALUE;
            int childCount = this.getChildCount();
            int firstPosition = this.mFirstPosition;
            for (int i2 = 0; i2 < childCount; ++i2) {
                if (!adapter.isEnabled(firstPosition + i2)) continue;
                View other = this.getChildAt(i2);
                other.getDrawingRect(otherRect);
                this.offsetDescendantRectToMyCoords(other, otherRect);
                int distance = HListView.getDistance(previouslyFocusedRect, otherRect, direction);
                if (distance >= minDistance) continue;
                minDistance = distance;
                closetChildIndex = i2;
                closestChildLeft = other.getLeft();
            }
        }
        if (closetChildIndex >= 0) {
            this.setSelectionFromLeft(closetChildIndex + this.mFirstPosition, closestChildLeft);
        } else {
            this.requestLayout();
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int count = this.getChildCount();
        if (count > 0) {
            for (int i2 = 0; i2 < count; ++i2) {
                this.addHeaderView(this.getChildAt(i2));
            }
            this.removeAllViews();
        }
    }

    @Deprecated
    public long[] getCheckItemIds() {
        if (this.mAdapter != null && this.mAdapter.hasStableIds()) {
            return this.getCheckedItemIds();
        }
        if (this.mChoiceMode != 0 && this.mCheckStates != null && this.mAdapter != null) {
            SparseArrayCompat states = this.mCheckStates;
            int count = states.size();
            long[] ids = new long[count];
            ListAdapter adapter = this.mAdapter;
            int checkedCount = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                if (!((Boolean)states.valueAt(i2)).booleanValue()) continue;
                ids[checkedCount++] = adapter.getItemId(states.keyAt(i2));
            }
            if (checkedCount == count) {
                return ids;
            }
            long[] result = new long[checkedCount];
            System.arraycopy(ids, 0, result, 0, checkedCount);
            return result;
        }
        return new long[0];
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)HListView.class.getName());
    }

    @Override
    @TargetApi(value=14)
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)HListView.class.getName());
    }

    public void onGlobalLayout() {
    }

    private static class ArrowScrollFocusResult {
        private int mSelectedPosition;
        private int mAmountToScroll;

        private ArrowScrollFocusResult() {
        }

        void populate(int selectedPosition, int amountToScroll) {
            this.mSelectedPosition = selectedPosition;
            this.mAmountToScroll = amountToScroll;
        }

        public int getSelectedPosition() {
            return this.mSelectedPosition;
        }

        public int getAmountToScroll() {
            return this.mAmountToScroll;
        }
    }

    private class FocusSelector
    implements Runnable {
        private int mPosition;
        private int mPositionLeft;

        private FocusSelector() {
        }

        public FocusSelector setup(int position, int left) {
            this.mPosition = position;
            this.mPositionLeft = left;
            return this;
        }

        @Override
        public void run() {
            HListView.this.setSelectionFromLeft(this.mPosition, this.mPositionLeft);
        }
    }
}

