/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.config.protocol;

import com.example.configcenter.CacheKey;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.yyprotocol.core.ByteString;
import com.yy.mobile.yyprotocol.core.Int64;
import com.yy.mobile.yyprotocol.core.MarshalContainer;
import com.yy.mobile.yyprotocol.core.Pack;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yy.mobile.yyprotocol.core.UnmarshalContainer;
import com.yy.mobile.yyprotocol.core.Unpack;
import com.yymobile.core.MobileServers;
import com.yymobile.core.ent.protos.IEntProtocol;
import com.yymobile.core.ent.v2.ProtosMapperV2;
import java.util.HashMap;
import java.util.Map;

public class ConfigProtocol {
    public static void registerProtocols() {
        ProtosMapperV2.getInstanceByServiceApp(MobileServers.sMobileSrv).add(MobConfigRequestMsg.class, MobConfigResponseMsg.class, MobConfigBroadcastMsg.class);
    }

    public static class MobConfigBroadcastMsg
    implements IEntProtocol {
        public String bssCode;
        public Int64 bssVersion;
        public Uint32 interval;

        @Override
        public Uint32 getMaxType() {
            return MsgMaxType.MOB_CONFIG;
        }

        @Override
        public Uint32 getMinType() {
            return MsgMinType.MOB_CONFIG_BROADCAST;
        }

        public void toString(ByteString bs) {
            Pack pack = new Pack();
            pack.push(this.bssCode);
            pack.push(this.bssVersion);
            pack.push(this.interval);
            bs.setBytes(pack.toBytes());
        }

        public void unString(ByteString bs) {
            Unpack unpack = new Unpack(bs.getBytes());
            this.bssCode = unpack.popString();
            this.bssVersion = unpack.popInt64();
            this.interval = unpack.popUint32();
        }

        public String toString() {
            return "MobConfigBroadcastMsg{bssCode='" + this.bssCode + '\'' + ", bssVersion=" + this.bssVersion + ", interval=" + this.interval + '}';
        }
    }

    public static class MobConfigResponseMsg
    implements IEntProtocol {
        public Uint32 result;
        public String bssCode;
        public Int64 bssVersion;
        public String bssMode;
        public Map<String, String> configs = new HashMap<String, String>();
        public Map<String, String> deletes = new HashMap<String, String>();
        public Map<String, String> extendInfo = new HashMap<String, String>();

        @Override
        public Uint32 getMaxType() {
            return MsgMaxType.MOB_CONFIG;
        }

        @Override
        public Uint32 getMinType() {
            return MsgMinType.MOB_CONFIG_RESPONSE;
        }

        public void toString(ByteString bs) {
            Pack pack = new Pack();
            pack.push(this.result);
            pack.push(this.bssCode);
            pack.push(this.bssVersion);
            pack.push(this.bssMode);
            MarshalContainer.marshalMapStringString((Pack)pack, this.configs);
            MarshalContainer.marshalMapStringString((Pack)pack, this.deletes);
            MarshalContainer.marshalMapStringString((Pack)pack, this.extendInfo);
            bs.setBytes(pack.toBytes());
        }

        public void unString(ByteString bs) {
            Unpack unpack = new Unpack(bs.getBytes());
            this.result = unpack.popUint32();
            this.bssCode = unpack.popString();
            this.bssVersion = unpack.popInt64();
            this.bssMode = unpack.popString();
            UnmarshalContainer.unmarshalMapStringString((Unpack)unpack, this.configs);
            UnmarshalContainer.unmarshalMapStringString((Unpack)unpack, this.deletes);
            UnmarshalContainer.unmarshalMapStringString((Unpack)unpack, this.extendInfo);
        }

        public String toString() {
            return "MobConfigResponseMsg{result=" + this.result + ", bssCode='" + this.bssCode + '\'' + ", bssVersion=" + this.bssVersion + ", bssMode='" + this.bssMode + '\'' + ", configs=" + this.configs + ", deletes=" + this.deletes + ", extendInfo=" + this.extendInfo + '}';
        }
    }

    public static class MobConfigRequestMsg
    implements IEntProtocol,
    CacheKey {
        public String bssCode;
        public Int64 bssVersion;
        public String bssMode;
        public String version;
        public String client;
        public String osVersion;
        public String market;
        public String net;
        public String isp;
        public String model;
        private long uid = LoginUtil.isLogined() ? LoginUtil.getUid() : 0L;
        public Map<String, String> extendInfo = new HashMap<String, String>();

        @Override
        public Uint32 getMaxType() {
            return MsgMaxType.MOB_CONFIG;
        }

        @Override
        public Uint32 getMinType() {
            return MsgMinType.MOB_CONFIG_REQUEST;
        }

        public void toString(ByteString bs) {
            Pack pack = new Pack();
            pack.push(this.bssCode);
            pack.push(this.bssVersion);
            pack.push(this.bssMode);
            pack.push(this.version);
            pack.push(this.client);
            pack.push(this.osVersion);
            pack.push(this.market);
            pack.push(this.net);
            pack.push(this.isp);
            pack.push(this.model);
            MarshalContainer.marshalMapStringString((Pack)pack, this.extendInfo);
            bs.setBytes(pack.toBytes());
        }

        public void unString(ByteString bs) {
            Unpack unpack = new Unpack(bs.getBytes());
            this.bssCode = unpack.popString();
            this.bssVersion = unpack.popInt64();
            this.bssMode = unpack.popString();
            this.version = unpack.popString();
            this.client = unpack.popString();
            this.osVersion = unpack.popString();
            this.market = unpack.popString();
            this.net = unpack.popString();
            this.isp = unpack.popString();
            this.model = unpack.popString();
            UnmarshalContainer.unmarshalMapStringString((Unpack)unpack, this.extendInfo);
        }

        public String toString() {
            return "MobConfigRequestMsg{bssCode='" + this.bssCode + '\'' + ", bssVersion=" + this.bssVersion + ", bssMode='" + this.bssMode + '\'' + ", version='" + this.version + '\'' + ", client='" + this.client + '\'' + ", osVersion='" + this.osVersion + '\'' + ", market='" + this.market + '\'' + ", net='" + this.net + '\'' + ", isp='" + this.isp + '\'' + ", model='" + this.model + '\'' + ", extendInfo=" + this.extendInfo + '}';
        }

        public boolean equals(Object o) {
            if (o instanceof MobConfigRequestMsg) {
                MobConfigRequestMsg req = (MobConfigRequestMsg)o;
                return this.bssCode.equals(req.bssCode) && this.bssVersion.equals((Object)req.bssVersion) && this.bssMode.equals(req.bssMode) && this.net.equals(req.net) && this.uid == req.uid;
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.bssCode.hashCode();
            hashCode = hashCode * 31 + this.bssVersion.hashCode();
            hashCode = hashCode * 31 + this.bssMode.hashCode();
            hashCode = hashCode * 31 + this.net.hashCode();
            hashCode = hashCode * 31 + (int)(this.uid >>> 32 ^ this.uid);
            return hashCode;
        }
    }

    public static final class BssMode {
        public static final String ALL = "all";
        public static final String NEWEST = "newest";
    }

    public static final class MsgMinType {
        public static final Uint32 MOB_CONFIG_REQUEST = new Uint32(1);
        public static final Uint32 MOB_CONFIG_RESPONSE = new Uint32(2);
        public static final Uint32 MOB_CONFIG_BROADCAST = new Uint32(3);
    }

    public static final class MsgMaxType {
        public static final Uint32 MOB_CONFIG = new Uint32(3314);
    }
}

