/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.utils;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import com.yymobile.core.utils.CommonParamUtil;
import com.yymobile.core.utils.IResponseCallback;
import com.yymobile.core.utils.JsonArrayResponseCallback;
import com.yymobile.core.utils.ParameterizedTypeImpl;
import com.yymobile.core.utils.ResponseCallback;
import com.yymobile.core.utils.Result;
import com.yymobile.core.utils.StringResponseCallback;
import java.lang.reflect.Type;
import java.util.List;

public class HttpRequest {
    private static final String TAG = "HttpRequest";
    public static final int SUCCESS_CODE = 0;

    public static <T> void sendRequest(String url, IResponseCallback callback) {
        HttpRequest.sendRequest(url, null, callback);
    }

    public static void sendRequest(String url, RequestParam param, final IResponseCallback callback) {
        MLog.info((Object)TAG, (String)("sendRequest url:" + url), (Object[])new Object[0]);
        if (callback == null) {
            return;
        }
        RequestParam commonParam = CommonParamUtil.fillCommonParam();
        if (param != null) {
            commonParam.getUrlParams().putAll(param.getUrlParams());
            commonParam.setCacheController(param.getCacheController());
        }
        ResponseListener<String> successListener = new ResponseListener<String>(){

            public void onResponse(final String response) {
                MLog.info((Object)HttpRequest.TAG, (String)("successListener onResponse:" + response), (Object[])new Object[0]);
                if (TextUtils.isEmpty((CharSequence)response)) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure();
                        }
                    });
                    return;
                }
                if (callback instanceof JsonArrayResponseCallback) {
                    Result result = null;
                    try {
                        result = ((JsonArrayResponseCallback)callback).parseJsonArray(response);
                    }
                    catch (JsonSyntaxException e2) {
                        MLog.error((Object)HttpRequest.TAG, (Throwable)e2);
                    }
                    HttpRequest.mainThreadExecuteCallback(result, callback);
                } else if (callback instanceof ResponseCallback) {
                    Result result = null;
                    try {
                        result = ((ResponseCallback)callback).parseJson(response);
                    }
                    catch (JsonSyntaxException e3) {
                        MLog.error((Object)HttpRequest.TAG, (Throwable)e3);
                    }
                    HttpRequest.mainThreadExecuteCallback(result, callback);
                } else if (callback instanceof StringResponseCallback) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ((StringResponseCallback)callback).onSuccess(response);
                        }
                    });
                }
            }
        };
        ResponseErrorListener errorListener = new ResponseErrorListener(){

            public void onErrorResponse(RequestError error) {
                MLog.info((Object)HttpRequest.TAG, (String)("onErrorResponse:" + error.toString()), (Object[])new Object[0]);
                callback.onFailure();
                callback.onRequestFailure(error);
            }
        };
        RequestManager.instance().submitStringQueryRequest(url, commonParam, (ResponseListener)successListener, errorListener, false);
    }

    private static void mainThreadExecuteCallback(final Result result, final IResponseCallback callback) {
        YYTaskExecutor.RunnableEx runnableEx = new YYTaskExecutor.RunnableEx(){

            public void run() {
                if (result == null) {
                    callback.onFailure();
                    return;
                }
                if (result.code == 0) {
                    if (result.data != null) {
                        callback.onSuccess(result.data);
                    }
                } else {
                    callback.onFailure();
                    callback.onResultFailure(result.code, result.message);
                }
            }
        };
        YYTaskExecutor.postToMainThread((Runnable)runnableEx);
    }

    private static <T> Result<T> parseJson(String json, Class<T> clazz) {
        ParameterizedTypeImpl type = new ParameterizedTypeImpl(Result.class, new Class[]{clazz});
        Gson gson = new Gson();
        return (Result)gson.fromJson(json, (Type)type);
    }

    private static <T> Result<List<T>> parseJsonArray(String json, Class<T> clazz) {
        ParameterizedTypeImpl listType = new ParameterizedTypeImpl(List.class, new Class[]{clazz});
        ParameterizedTypeImpl type = new ParameterizedTypeImpl(Result.class, new Type[]{listType});
        Gson gson = new Gson();
        return (Result)gson.fromJson(json, (Type)type);
    }
}

