/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.statistic;

import android.text.TextUtils;
import com.yy.mobile.miapi.YY2MIStatisticReporter;
import com.yy.mobile.replugin.ApiBridge;
import com.yy.mobile.util.log.MLog;
import org.json.JSONException;
import org.json.JSONObject;

public class YY2MIStatisticReporterProxy {
    private static final String TAG = "YY2MIStatisticReporterProxy";
    private int logType;
    private JSONObject mJSONObject = new JSONObject();

    private YY2MIStatisticReporterProxy(int logType) {
        this.logType = logType;
    }

    public static YY2MIStatisticReporterProxy with(int logType) {
        return new YY2MIStatisticReporterProxy(logType);
    }

    public YY2MIStatisticReporterProxy addProperty(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            return this;
        }
        try {
            this.mJSONObject.put(key, (Object)value);
        }
        catch (JSONException e2) {
            MLog.error((Object)TAG, (Throwable)e2);
        }
        return this;
    }

    public YY2MIStatisticReporterProxy addRoomId(String key, long topSid, long subSid) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return this;
        }
        try {
            if (topSid <= 0L && subSid <= 0L) {
                this.mJSONObject.put(key, (Object)"");
            } else {
                this.mJSONObject.put(key, (Object)(topSid + "_" + subSid));
            }
        }
        catch (JSONException e2) {
            MLog.error((Object)TAG, (Throwable)e2);
        }
        return this;
    }

    public YY2MIStatisticReporterProxy addRoomId(String key, String topSid, String subSid) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return this;
        }
        try {
            if (TextUtils.isEmpty((CharSequence)topSid) && TextUtils.isEmpty((CharSequence)subSid)) {
                this.mJSONObject.put(key, (Object)"");
            } else {
                this.mJSONObject.put(key, (Object)(topSid + "_" + subSid));
            }
        }
        catch (JSONException e2) {
            MLog.error((Object)TAG, (Throwable)e2);
        }
        return this;
    }

    public void report() {
        YY2MIStatisticReporter reporter = (YY2MIStatisticReporter)ApiBridge.INSTANCE.getApi(YY2MIStatisticReporter.class);
        if (null != reporter) {
            reporter.record(this.logType, this.mJSONObject.toString());
        }
    }
}

