/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.statistic;

import android.util.Log;
import com.yy.mobile.util.DontProguardClass;
import com.yy.mobile.util.log.MLog;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;

@DontProguardClass
public class HiidoStatisticContent {
    private static final String TAG = "HiidoStatisticContent";
    protected TreeMap<String, String> raw = new TreeMap();

    public String put(String key, int value) {
        return this.put(key, String.valueOf(value));
    }

    public String put(String key, long value) {
        return this.put(key, String.valueOf(value));
    }

    public String put(String key, double value) {
        return this.put(key, String.valueOf(value));
    }

    public String get(String key) {
        return this.raw.get(key);
    }

    public boolean containsKey(String key) {
        return this.raw.containsKey(key);
    }

    public String put(String key, String value) {
        if (this.empty(key)) {
            MLog.error((Object)TAG, (String)"key is invalid for value %s", (Object[])new Object[]{value});
            return null;
        }
        value = this.asEmptyOnNull(value);
        return this.raw.put(key, value);
    }

    public String put(String key, String value, boolean isCover) {
        if (this.empty(key)) {
            MLog.error((Object)TAG, (String)"key is invalid for value %s", (Object[])new Object[]{value});
            return null;
        }
        value = this.asEmptyOnNull(value);
        if (isCover) {
            return this.raw.put(key, value);
        }
        if (this.raw.containsKey(key)) {
            return this.raw.get(key);
        }
        return this.raw.put(key, value);
    }

    public boolean isEmpty() {
        return this.raw.isEmpty();
    }

    private boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    private String asEmptyOnNull(String s) {
        return s == null ? "" : s;
    }

    public TreeMap<String, String> getTreeMapContent() {
        return this.raw;
    }

    public String toString() {
        return this.getContent();
    }

    public String getContent() {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> localRaw = this.raw;
        for (Map.Entry<String, String> e2 : localRaw.entrySet()) {
            String value = e2.getValue();
            if (value == null || value.length() == 0) continue;
            sb.append(e2.getKey());
            sb.append("=");
            try {
                sb.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                Log.e((String)TAG, (String)"Empty Catch on getContent", (Throwable)e1);
            }
            sb.append("&");
        }
        if (sb.length() == 0) {
            sb = null;
            return null;
        }
        if (sb.length() > 0) {
            sb.append("hd_p=E&");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        String tmp = sb.toString();
        sb.setLength(0);
        sb = null;
        return tmp;
    }
}

