/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.statistic;

import android.content.Context;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.statistic.DurationStatisticDataModel;
import com.yy.mobile.statistic.StatisticNewDataContainer;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.statistic.StatisticUtil;

public class CostCommonOptionSampling
extends DurationStatisticDataModel {
    private static final String TAG = "CostCommonOptionSampling";
    public static final int TIME_OUT = 1002;
    public static final long TIMEOUT_VAL = 30000L;
    public static final int SUCCESS = 1;
    public static final int FAIL = 0;
    public static final int ERROR_NONE = 0;
    @Expose
    @SerializedName(value="key")
    private String key;
    @Expose
    @SerializedName(value="uid")
    private long uid;
    @Expose
    @SerializedName(value="network")
    private String newwork;
    @Expose
    @SerializedName(value="eventtime")
    private long eventtime;
    @Expose
    @SerializedName(value="cost")
    private long cost;

    protected String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void begin() {
        if (this.isRunning()) {
            this.onEventEnd();
        }
        this.cost = 0L;
        super.onEventBegin(30000L, true);
    }

    public void end() {
        if (!this.isRunning()) {
            return;
        }
        this.key = this.getKey();
        this.newwork = NetworkUtils.getNetworkName((Context)BasicConfig.getInstance().getAppContext());
        this.eventtime = System.currentTimeMillis();
        this.cost = this.onEventEnd();
        this.sendToContainer();
    }

    public void cancel() {
        this.onEventEnd();
    }

    protected String getActionName() {
        return "CommonOptionSampling";
    }

    protected long onTimeout() {
        if (!this.isRunning()) {
            return 0L;
        }
        this.key = this.getKey();
        this.newwork = NetworkUtils.getNetworkName((Context)BasicConfig.getInstance().getAppContext());
        this.eventtime = System.currentTimeMillis();
        this.cost = super.onTimeout();
        return 0L;
    }

    protected void sendToContainer() {
        try {
            this.uid = LoginUtil.getUid();
            MLog.info((Object)"Stub", (String)(this.getKey() + " end timecost=" + this.cost), (Object[])new Object[0]);
            if (0L < this.cost && this.cost < 30000L) {
                StatisticNewDataContainer container = StatisticUtil.instance().get(StatisticNewDataContainer.class);
                if (container != null) {
                    container.addData(this.clone());
                } else {
                    MLog.error((Object)TAG, (String)"sendToContainer: StatisticNewDataContainer is null", (Object[])new Object[0]);
                }
            }
        }
        catch (CloneNotSupportedException e2) {
            MLog.error((Object)TAG, (Throwable)e2);
        }
    }

    public String toString() {
        return " key =" + this.key + " uid =" + this.uid + " network =" + this.newwork + " cost =" + this.cost + " eventtime =" + this.eventtime;
    }
}

