/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.shenqu;

import android.text.TextUtils;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import com.yy.mobile.yyprotocol.core.Int64;
import com.yy.mobile.yyprotocol.core.Marshallable;
import com.yy.mobile.yyprotocol.core.Pack;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yy.mobile.yyprotocol.core.UnmarshalContainer;
import com.yy.mobile.yyprotocol.core.Unpack;
import com.yymobile.core.shenqu.IPlayVideoInfo;
import com.yymobile.core.shenqu.ShenquExtendkeys;
import com.yymobile.core.shenqu.ShenquUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class ShenquDetailMarshall
implements IPlayVideoInfo,
Marshallable,
Serializable {
    private static final String TAG = "ShenquDetailMarshall";
    public Int64 resId = new Int64(0);
    public Uint32 ownerId = new Uint32(0);
    public String resname = "";
    public String ownername = "";
    public String resdesc = "";
    public String resurl = "";
    public String songname = "";
    public String snapshoturl = "";
    public Uint32 duration = new Uint32(0);
    public Uint32 margin = new Uint32(0);
    public String time = "";
    public Map<Uint32, String> extend = new HashMap<Uint32, String>();
    public float dpi;
    public String videoUrl = "";
    public static final String ORIG_TAG = "10031";

    public void marshall(Pack pack) {
    }

    public void unmarshall(Unpack up) {
        this.resId = up.popInt64();
        this.ownerId = up.popUint32();
        this.resname = up.popString();
        this.ownername = up.popString();
        this.resdesc = up.popString();
        this.resurl = up.popString();
        if (!FP.empty((CharSequence)this.resurl)) {
            this.resurl = this.resurl.trim();
        }
        this.videoUrl = this.resurl;
        this.songname = up.popString();
        if (!FP.empty((CharSequence)this.songname)) {
            this.songname = this.songname.trim();
        }
        this.snapshoturl = up.popString();
        if (!FP.empty((CharSequence)this.snapshoturl)) {
            this.snapshoturl = this.snapshoturl.trim();
        }
        this.duration = up.popUint32();
        this.margin = up.popUint32();
        this.time = up.popString();
        UnmarshalContainer.unmarshalMapUint32String((Unpack)up, this.extend);
    }

    public String getVideoOneWord() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_VIDEO_WORD);
    }

    public int getUserRole() {
        String userRole = this.extend.get(ShenquExtendkeys.ExtendUintKeys.USER_ROLE);
        int result = 0;
        try {
            result = Integer.parseInt(userRole);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
        return result;
    }

    public String getCustomUserLogoUrl() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_CUSTOM_LOGO_URL);
    }

    public String getWechatSnapShotUrl() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.WECHAT_SHARE_SNAPSHOT);
    }

    public void setWechatSnapShotUrl(String url) {
        this.extend.put(ShenquExtendkeys.ExtendUintKeys.WECHAT_SHARE_SNAPSHOT, url);
    }

    public String getOriginalSnapshotUrl() {
        if (this.extend.containsKey(ShenquExtendkeys.ExtendUintKeys.VIDEO_ORIGINAL_SNAPSHOT)) {
            return this.extend.get(ShenquExtendkeys.ExtendUintKeys.VIDEO_ORIGINAL_SNAPSHOT);
        }
        return this.snapshoturl;
    }

    public int getCustomUserLogoIndex() {
        String index = this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_CUSTOM_LOGO_INDEX);
        int result = -1;
        try {
            result = Integer.parseInt(index);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
        return result;
    }

    public float getHeightRatio() {
        String dpi = this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_TINY_VIDEO_DPI);
        return ShenquUtils.getRatio(dpi);
    }

    public boolean isOrig() {
        String[] tagArray;
        String tags = this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_ORIG_KEY);
        if (!TextUtils.isEmpty((CharSequence)tags) && (tagArray = tags.split(",")) != null && tagArray.length > 0) {
            for (int i2 = 0; i2 < tagArray.length; ++i2) {
                if (!tagArray[i2].equals(ORIG_TAG)) continue;
                return true;
            }
        }
        return false;
    }

    public long getTodayRank() {
        String rankStr = this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_HOT_TODAY_RANK);
        long rank = 0L;
        if (!TextUtils.isEmpty((CharSequence)rankStr)) {
            rank = Long.valueOf(rankStr);
        }
        return rank;
    }

    public long getYestdayRank() {
        String rankStr = this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_HOT_YESTODAY_RANK);
        long rank = 0L;
        if (!TextUtils.isEmpty((CharSequence)rankStr)) {
            rank = Long.valueOf(rankStr);
        }
        return rank;
    }

    public long getBestHotRank() {
        String rankStr = this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_BEST_HOT_RANK);
        long rank = 0L;
        if (!TextUtils.isEmpty((CharSequence)rankStr)) {
            rank = Long.valueOf(rankStr);
        }
        return rank;
    }

    public long getBestHotRankLast() {
        String rankStr = this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_BEST_HOT_RANK_LAST);
        long rank = 0L;
        if (!TextUtils.isEmpty((CharSequence)rankStr)) {
            rank = Long.valueOf(rankStr);
        }
        return rank;
    }

    public static Long getDaysBetween(Date startDate, Date endDate) {
        Calendar fromCalendar = Calendar.getInstance();
        fromCalendar.setTime(startDate);
        fromCalendar.set(11, 0);
        fromCalendar.set(12, 0);
        fromCalendar.set(13, 0);
        fromCalendar.set(14, 0);
        Calendar toCalendar = Calendar.getInstance();
        toCalendar.setTime(endDate);
        toCalendar.set(11, 0);
        toCalendar.set(12, 0);
        toCalendar.set(13, 0);
        toCalendar.set(14, 0);
        return (toCalendar.getTime().getTime() - fromCalendar.getTime().getTime()) / 86400000L;
    }

    public boolean isTimeMoreThanSevenDays(long sevTimesamp) {
        SimpleDateFormat sf = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm:ss");
        try {
            Calendar fromCalendar = Calendar.getInstance();
            fromCalendar.setTime(sf.parse(this.time));
            fromCalendar.set(11, 0);
            fromCalendar.set(12, 0);
            fromCalendar.set(13, 0);
            fromCalendar.set(14, 0);
            Calendar toCalendar = Calendar.getInstance();
            toCalendar.setTimeInMillis(sevTimesamp);
            toCalendar.set(11, 0);
            toCalendar.set(12, 0);
            toCalendar.set(13, 0);
            toCalendar.set(14, 0);
            return (toCalendar.getTime().getTime() - fromCalendar.getTime().getTime()) / 86400000L > 7L;
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
            return false;
        }
    }

    public String getSeqId() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_SEQID);
    }

    public String getRecommend() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_RECOMMEND);
    }

    public String getRankChange() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_RANKCHANGE);
    }

    public String getHotDegree() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_HOT_DATE);
    }

    public String getLastRank() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_HOT_LAST_RANK);
    }

    public String getCurrRank() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_HOT_CURRENT_RANK);
    }

    public String getVoteCount() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_VOTE_COUNT);
    }

    public String getWatchCount() {
        String count = this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_WATCHCOUNT);
        if (TextUtils.isEmpty((CharSequence)count)) {
            count = "0";
        }
        return count;
    }

    public String getLikeCount() {
        String count = this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_LIKECOUNT);
        if (TextUtils.isEmpty((CharSequence)count)) {
            count = "0";
        }
        return count;
    }

    public String getShareCount() {
        String count = this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_SHARECOUNT);
        if (TextUtils.isEmpty((CharSequence)count)) {
            count = "0";
        }
        return count;
    }

    public String getFavorCount() {
        String count = this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_FAVORCOUNT);
        if (TextUtils.isEmpty((CharSequence)count)) {
            count = "0";
        }
        return count;
    }

    public String getIsILiked() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_ISILIKED);
    }

    public void setIsILiked(String liked) {
        this.extend.put(ShenquExtendkeys.ExtendUintKeys.SHENQU_ISILIKED, liked);
    }

    public String getSourceType() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_SOURCETYPE);
    }

    public String getAnchorLogoUrl() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.ANCHOR_LOGOURL);
    }

    public void setShareCount(String count) {
        this.extend.put(ShenquExtendkeys.ExtendUintKeys.SHENQU_SHARECOUNT, count);
    }

    public void setLikeCount(String count) {
        this.extend.put(ShenquExtendkeys.ExtendUintKeys.SHENQU_LIKECOUNT, count);
    }

    public String getTagId() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_TAGID);
    }

    public String getTagName() {
        return this.extend.get(ShenquExtendkeys.ExtendUintKeys.SHENQU_TAGNAME);
    }

    public String getVideoLabelName() {
        return this.extend.containsKey(ShenquExtendkeys.ExtendUintKeys.VIDEO_RESOURCE_TYPENAME) ? this.extend.get(ShenquExtendkeys.ExtendUintKeys.VIDEO_RESOURCE_TYPENAME) : null;
    }

    public long getVideoLabelType() {
        long type = 0L;
        try {
            String result = this.extend.get(ShenquExtendkeys.ExtendUintKeys.VIDEO_RESOURCE_TYPE);
            if (!TextUtils.isEmpty((CharSequence)result)) {
                return Long.parseLong(result);
            }
            return type;
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
            return type;
        }
    }

    public int getVideoType() {
        String videoType = this.extend.get(ShenquExtendkeys.ExtendUintKeys.VIDEO_TYPE);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"getVideoType =%s", (Object[])new Object[]{videoType});
        }
        if (BlankUtil.isBlank((String)videoType)) {
            return 15;
        }
        try {
            return Integer.parseInt(videoType);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
            return 15;
        }
    }

    public String getOwnersInfoJson() {
        try {
            String json = this.extend.get(new Uint32(1219));
            if (json != null) {
                return new JSONObject(json).getJSONArray("owners").toString();
            }
            return null;
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
            return null;
        }
    }

    public boolean canCoStar() {
        int canCostarInt = 0;
        try {
            canCostarInt = Integer.parseInt(this.extend.get(new Uint32(1220)));
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
        return canCostarInt == 1;
    }

    public void setVideoType(int type) {
        this.extend.put(ShenquExtendkeys.ExtendUintKeys.VIDEO_TYPE, String.valueOf(type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShenquDetailMarshall tinyVideoTopicMarshall = (ShenquDetailMarshall)o;
        return this.resId.longValue() == tinyVideoTopicMarshall.resId.longValue();
    }

    public int hashCode() {
        return String.valueOf(this.resId.longValue()).hashCode();
    }

    public String toString() {
        return "ShenquDetailMarshall{resId=" + this.resId + ", ownerId=" + this.ownerId + ", resname='" + this.resname + '\'' + ", ownername='" + this.ownername + '\'' + ", resdesc='" + this.resdesc + '\'' + ", resurl='" + this.resurl + '\'' + ", songname='" + this.songname + '\'' + ", videoUrl='" + this.videoUrl + '\'' + ", snapshoturl='" + this.snapshoturl + '\'' + ", duration=" + this.duration + ", margin=" + this.margin + ", time='" + this.time + '\'' + ", extend=" + this.extend + '}';
    }
}

