/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.profile;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.DefaultRequestParam;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.RequestParam;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.pref2.SharedPreferencesUtils;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.YSharedPref;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.UriProvider;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.profile.MyChannelInfo;
import com.yymobile.core.user.UserInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LatestAccessPref
extends YSharedPref {
    private static final String TAG = "LatestAccessPref";
    private static LatestAccessPref sInst;
    private static final String ACCESS_KEY = "myAccessList";
    private static final String ACCESS_EXTEND_KEY = "myAccessExtend";
    private Set<Long> mOfficialSet = new HashSet<Long>();

    private LatestAccessPref(SharedPreferences pref) {
        super(pref);
    }

    public static synchronized LatestAccessPref instance() {
        if (sInst == null) {
            SharedPreferences pref = SharedPreferencesUtils.getSharedPreferences((Context)BasicConfig.getInstance().getAppContext(), (String)TAG, (int)0);
            sInst = new LatestAccessPref(pref);
        }
        return sInst;
    }

    private String getAccessKey(long uid) {
        return "myAccessList|" + uid;
    }

    public List<MyChannelInfo> getChannelList() {
        return this.getChannelList(0L);
    }

    private List<MyChannelInfo> getChannelList(long uid) {
        String channelsJson = LatestAccessPref.instance().get(this.getAccessKey(uid));
        List<Object> chList = new ArrayList<MyChannelInfo>();
        if (!TextUtils.isEmpty((CharSequence)channelsJson)) {
            try {
                chList = JsonParser.parseJsonList((String)channelsJson, MyChannelInfo.class);
            }
            catch (Throwable e2) {
                MLog.error((Object)TAG, (Throwable)e2);
            }
        }
        return chList;
    }

    public void deleteChannelList() {
        LatestAccessPref.instance().clear();
    }

    public void addChannelList(ChannelInfo mInfo) {
        this.addChannelList(0L, mInfo);
    }

    public void addChannelList(ChannelInfo mInfo, HashMap<String, String> mExtendInfo) {
        this.addChannelList(0L, mInfo);
        this.saveExtendMap(mInfo, mExtendInfo);
    }

    private void saveExtendMap(ChannelInfo mInfo, HashMap<String, String> mExtendInfo) {
        try {
            IChannelLinkCore core;
            if (mExtendInfo == null) {
                mExtendInfo = new HashMap();
            }
            boolean isOfficial = this.isOfficialSet(mInfo.topSid);
            MLog.info((Object)TAG, (String)("\u5b98\u9891:" + isOfficial), (Object[])new Object[0]);
            String preKey = mInfo.topSid + "_" + mInfo.subSid;
            Map<String, String> extendMap = this.getExtendMap();
            extendMap.put(preKey + "_" + "channel_official_program", isOfficial ? "1" : "");
            if (!isOfficial) {
                String nickName = mExtendInfo.get("channel_show_nick_name");
                if (!TextUtils.isEmpty((CharSequence)nickName)) {
                    extendMap.put(preKey + "_" + "channel_show_nick_name", nickName);
                } else {
                    long micId = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
                    UserInfo info = ICoreManagerBase.getUserCore().getCacheUserInfoByUid(micId);
                    if (info != null) {
                        nickName = !TextUtils.isEmpty((CharSequence)info.reserve1) ? info.reserve1 : info.nickName;
                        extendMap.put(preKey + "_" + "channel_show_nick_name", nickName);
                    }
                }
            }
            if ((core = ICoreManagerBase.getCore(IChannelLinkCore.class)) != null) {
                long mAnchorUid = core.getCurrentTopMicId();
                extendMap.put(preKey + "_" + "channel_anchor_uid", String.valueOf(mAnchorUid));
            }
            this.put(ACCESS_EXTEND_KEY, JsonParser.toJson(extendMap));
            if (!isOfficial) {
                if (!TextUtils.isEmpty((CharSequence)mInfo.channelLogo)) {
                    extendMap.put(preKey + "_" + "channel_screenshot_url", mInfo.channelLogo);
                }
                this.getChannelDescAndSave(mInfo, extendMap);
            }
        }
        catch (Throwable e2) {
            MLog.error((Object)TAG, (Throwable)e2);
        }
    }

    private void getChannelDescAndSave(ChannelInfo info, final Map<String, String> extendMap) {
        DefaultRequestParam param = new DefaultRequestParam();
        final String preKey = info.topSid + "_" + info.subSid;
        param.put("sid_ssids", preKey);
        RequestManager.instance().submitStringQueryRequest(UriProvider.RECENT_ACCESS, (RequestParam)param, (ResponseListener)new ResponseListener<String>(){

            public void onResponse(String content) {
                try {
                    JSONObject jObject = new JSONObject(content);
                    String code = jObject.get("code").toString();
                    if (TextUtils.equals((CharSequence)code, (CharSequence)"0")) {
                        JSONArray array = jObject.getJSONArray("data");
                        int cnt = array.length();
                        for (int i2 = 0; i2 < cnt; ++i2) {
                            JSONObject arrayObject = array.getJSONObject(i2);
                            String topSid = arrayObject.get("sid").toString();
                            String subSid = arrayObject.get("ssid").toString();
                            if (!TextUtils.equals((CharSequence)preKey, (CharSequence)(topSid + "_" + subSid))) continue;
                            String desc = arrayObject.get("desc").toString();
                            String thumb = arrayObject.get("thumb").toString();
                            String name = arrayObject.get("name").toString();
                            boolean needSave = false;
                            if (!TextUtils.isEmpty((CharSequence)desc)) {
                                extendMap.put(preKey + "_" + "home_click_desc", desc);
                                needSave = true;
                            }
                            if (!TextUtils.isEmpty((CharSequence)thumb)) {
                                extendMap.put(preKey + "_" + "channel_screenshot_url", thumb);
                                needSave = true;
                            }
                            if (!TextUtils.isEmpty((CharSequence)name)) {
                                extendMap.put(preKey + "_" + "channel_show_nick_name", name);
                                needSave = true;
                            }
                            if (!needSave) break;
                            LatestAccessPref.this.put(LatestAccessPref.ACCESS_EXTEND_KEY, JsonParser.toJson((Object)extendMap));
                            break;
                        }
                    }
                    MLog.info((Object)LatestAccessPref.TAG, (String)("getChannelDescAndSave ret:" + content), (Object[])new Object[0]);
                }
                catch (JSONException e2) {
                    e2.printStackTrace();
                }
            }
        }, new ResponseErrorListener(){

            public void onErrorResponse(RequestError requestError) {
                MLog.error((Object)LatestAccessPref.TAG, (String)("get desc err:" + requestError), (Object[])new Object[0]);
            }
        });
    }

    public Map<String, String> getExtendMap() {
        Map<String, String> extendMap = new HashMap<String, String>();
        String content = this.getString(ACCESS_EXTEND_KEY, "");
        if (!TextUtils.isEmpty((CharSequence)content)) {
            try {
                extendMap = JsonParser.parseJsonMap((String)content, String.class, String.class);
            }
            catch (Throwable e2) {
                extendMap = (Map)new Gson().fromJson(content, new TypeToken<Map<String, String>>(){}.getType());
            }
        }
        return extendMap;
    }

    public void updateMap(Map<String, String> map) {
        if (map == null) {
            return;
        }
        this.put(ACCESS_EXTEND_KEY, JsonParser.toJson(map));
    }

    private void addChannelList(long uid, ChannelInfo mInfo) {
        if (mInfo.topSid == 0L) {
            return;
        }
        try {
            List<MyChannelInfo> chList = this.getChannelList(uid);
            MyChannelInfo foundChannel = null;
            MyChannelInfo info = new MyChannelInfo();
            info.setTopAsid(mInfo.topASid);
            info.setTopSid(mInfo.topSid);
            info.setSubSid(mInfo.subSid);
            if (!TextUtils.isEmpty((CharSequence)mInfo.channelLogo)) {
                info.setChannelLogo(mInfo.channelLogo);
            }
            info.setChannelName(mInfo.channelTopName);
            info.setOnlineCount(mInfo.onlineCount);
            info.setTemplateid(mInfo.templateid);
            info.setEnterChannelTime(mInfo.enterChannelTime);
            int k = -1;
            for (int i2 = 0; i2 < chList.size(); ++i2) {
                MyChannelInfo infoTemp = chList.get(i2);
                if (infoTemp.getTopSid() != mInfo.topSid) continue;
                foundChannel = infoTemp;
                k = i2;
                break;
            }
            if (k != -1) {
                chList.remove(k);
            }
            if (foundChannel != null) {
                foundChannel.setTopAsid(mInfo.topASid);
                foundChannel.setTopSid(mInfo.topSid);
                foundChannel.setSubSid(mInfo.subSid);
                if (!TextUtils.isEmpty((CharSequence)mInfo.channelLogo)) {
                    foundChannel.setChannelLogo(mInfo.channelLogo);
                }
                foundChannel.setChannelName(mInfo.channelTopName);
                foundChannel.setOnlineCount(mInfo.onlineCount);
                foundChannel.setTemplateid(mInfo.templateid);
                foundChannel.setEnterChannelTime(mInfo.enterChannelTime);
                chList.add(0, foundChannel);
            } else {
                chList.add(0, info);
            }
            if (chList.size() > 20) {
                chList.remove(chList.size() - 1);
            }
            String json = JsonParser.toJson(chList);
            this.put(this.getAccessKey(uid), json);
        }
        catch (Throwable e2) {
            MLog.error((Object)TAG, (Throwable)e2);
        }
    }

    public void updateList(List<MyChannelInfo> list) {
        try {
            String json = JsonParser.toJson(list);
            this.put(this.getAccessKey(0L), json);
            MLog.info((Object)TAG, (String)"update bucket", (Object[])new Object[0]);
        }
        catch (Throwable e2) {
            MLog.error((Object)TAG, (Throwable)e2);
        }
    }

    public void addOfficialSet(long topSid) {
        this.mOfficialSet.add(topSid);
    }

    public boolean isOfficialSet(long topSid) {
        return this.mOfficialSet.contains(topSid);
    }
}

