/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.playtogether;

import android.content.Context;
import android.text.Html;
import com.yy.mobile.yyprotocol.core.MarshalContainer;
import com.yy.mobile.yyprotocol.core.Marshallable;
import com.yy.mobile.yyprotocol.core.Pack;
import com.yy.mobile.yyprotocol.core.UnmarshalContainer;
import com.yy.mobile.yyprotocol.core.Unpack;
import com.yymobile.baseapi.R;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CategoryBean
implements Marshallable,
Serializable {
    public boolean isUseSeniorCharge;
    public int id;
    public String name;
    public int icon;
    public String url;
    public String img;
    public int duration;
    public int chargeId;
    public int charge;
    public String uint;
    public int discount;
    public int discountPrice;
    public String rule;
    public int owned;
    public int inService;
    public int group;
    public Map<String, String> extendInfo = new HashMap<String, String>();

    public void marshall(Pack pack) {
        pack.push(Integer.valueOf(this.id));
        pack.push(this.name);
        pack.push(Integer.valueOf(this.icon));
        pack.push(this.url);
        pack.push(this.img);
        pack.push(Integer.valueOf(this.duration));
        pack.push(Integer.valueOf(this.chargeId));
        pack.push(Integer.valueOf(this.charge));
        pack.push(this.uint);
        pack.push(Integer.valueOf(this.discount));
        pack.push(Integer.valueOf(this.discountPrice));
        pack.push(this.rule);
        pack.push(Integer.valueOf(this.owned));
        pack.push(Integer.valueOf(this.inService));
        pack.push(Integer.valueOf(this.group));
        if (this.extendInfo != null) {
            MarshalContainer.marshalMapStringString((Pack)pack, this.extendInfo);
        }
    }

    public CharSequence getDes(Context context) {
        String text = context.getString(R.string.plan_category_des, new Object[]{this.uint, this.getDuration()});
        text = context.getString(R.string.plan_category_des2, new Object[]{this.getCharge(), text});
        return Html.fromHtml((String)text);
    }

    public void unmarshall(Unpack up) {
        this.id = up.popInt();
        this.name = up.popString();
        this.icon = up.popInt();
        this.url = up.popString();
        this.img = up.popString();
        this.duration = up.popInt();
        this.chargeId = up.popInt();
        this.charge = up.popInt();
        this.uint = up.popString();
        this.discount = up.popInt();
        this.discountPrice = up.popInt();
        this.rule = up.popString();
        this.owned = up.popInt();
        this.inService = up.popInt();
        this.group = up.popInt();
        UnmarshalContainer.unmarshalMapStringString((Unpack)up, this.extendInfo);
    }

    public String getDuration() {
        if (this.duration < 60) {
            return String.valueOf(this.duration) + "\u79d2";
        }
        if (this.duration % 60 != 0) {
            return String.format("%1d\u5206\u949f%2d\u79d2", this.duration / 60, this.duration % 60);
        }
        return this.duration / 60 + "\u5206\u949f";
    }

    public String getCharge() {
        if (this.charge % 100 == 0) {
            return String.valueOf(this.charge / 100);
        }
        return String.valueOf((double)this.charge / 100.0);
    }

    public long getSeniorsCharge() {
        if (null == this.extendInfo) {
            return 0L;
        }
        String scahrgeString = this.extendInfo.get("sCharge");
        if (null == scahrgeString) {
            return 0L;
        }
        return Long.valueOf(scahrgeString);
    }

    public boolean isSeniorsCategory() {
        if (null == this.extendInfo) {
            return false;
        }
        String isSeniorsString = this.extendInfo.get("senior");
        if (null == isSeniorsString) {
            return false;
        }
        return Integer.valueOf(isSeniorsString) == 1;
    }

    public void setIsSenior(int isSenior) {
        if (null == this.extendInfo) {
            this.extendInfo = new HashMap<String, String>();
        }
        this.extendInfo.put("senior", String.valueOf(isSenior));
    }

    public String getMenuName() {
        if (null == this.extendInfo) {
            return null;
        }
        return this.extendInfo.get("menuName");
    }

    public boolean isIntimateType() {
        if (this.extendInfo != null) {
            return "1".equals(this.extendInfo.get("type"));
        }
        return false;
    }
}

