/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.mobilelive;

import android.text.TextUtils;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import com.yymobile.core.media.MobileLiveTranscodeInfo;
import com.yymobile.core.media.MobileLiveTranscodingInfo;
import java.util.Iterator;
import org.json.JSONObject;

public class MobileLiveTranscodingRsp {
    private static final String TAG = "MobileLiveTranscodingRsp";

    public static boolean parseIsAllowMic(String msg) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"parseIsAllowMic", (Object[])new Object[0]);
        }
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            try {
                JSONObject jsonObject = new JSONObject(msg);
                JSONObject data = jsonObject.optJSONObject("data");
                boolean isAllowMic = data.optInt("result", 0) == 1;
                MLog.info((Object)TAG, (String)("isAllowMic " + isAllowMic), (Object[])new Object[0]);
                return isAllowMic;
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, (String)("parse error! " + throwable), (Object[])new Object[0]);
            }
        }
        return false;
    }

    public static MobileLiveTranscodingInfo parseMsg(String msg) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("parseMsg msg = " + msg), (Object[])new Object[0]);
        }
        try {
            if (!BlankUtil.isBlank((String)msg)) {
                MobileLiveTranscodeInfo codeInfo;
                JSONObject obj;
                String key;
                Iterator keyStr;
                JSONObject jsonObject = new JSONObject(msg);
                int code = jsonObject.optInt("code");
                String uri = jsonObject.optString("uri");
                JSONObject dataObject = jsonObject.optJSONObject("data");
                String beautyParam = dataObject.optString("meiyan");
                MobileLiveTranscodingInfo info = new MobileLiveTranscodingInfo();
                JSONObject micJson = dataObject.optJSONObject("mic");
                JSONObject encodeIdJson = dataObject.optJSONObject("encode");
                JSONObject codeJson = dataObject.optJSONObject("code");
                JSONObject playCodeJson = dataObject.optJSONObject("playcode");
                if (!BlankUtil.isBlank((Object)micJson)) {
                    keyStr = micJson.keys();
                    while (keyStr.hasNext()) {
                        key = (String)keyStr.next();
                        obj = micJson.optJSONObject(key);
                        if (BlankUtil.isBlank((Object)obj)) continue;
                        codeInfo = (MobileLiveTranscodeInfo)JsonParser.parseJsonObject((String)obj.toString(), MobileLiveTranscodeInfo.class);
                        codeInfo.index = key;
                        info.transMicInfos.add(codeInfo);
                    }
                }
                if (!BlankUtil.isBlank((Object)codeJson)) {
                    keyStr = codeJson.keys();
                    while (keyStr.hasNext()) {
                        key = (String)keyStr.next();
                        obj = codeJson.optJSONObject(key);
                        if (BlankUtil.isBlank((Object)obj)) continue;
                        codeInfo = (MobileLiveTranscodeInfo)JsonParser.parseJsonObject((String)obj.toString(), MobileLiveTranscodeInfo.class);
                        codeInfo.index = key;
                        info.transCodeInfos.add(codeInfo);
                    }
                }
                if (!BlankUtil.isBlank((Object)playCodeJson)) {
                    info.hcode = playCodeJson.optString("hcode");
                    info.vcode = playCodeJson.optString("vcode");
                }
                if (info.encodeInfo != null && encodeIdJson != null) {
                    info.encodeInfo.encodeId = encodeIdJson.optInt("encode_id");
                    info.encodeInfo.param = encodeIdJson.optString("param");
                }
                info.code = code;
                info.uri = uri;
                info.beautyParam = beautyParam;
                return info;
            }
            MLog.error((Object)TAG, (String)("parseMsg error msg = " + msg), (Object[])new Object[0]);
            return null;
        }
        catch (Exception e2) {
            MLog.error((Object)TAG, (Throwable)e2);
            return null;
        }
    }
}

