/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.media;

import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class MicSpeaker {
    private long uid;
    private String nick;
    private long muteTime;
    private long speakTime;
    private String headUrl;
    private boolean isSpeaking;
    private boolean isAuchor;
    public static Comparator<MicSpeaker> mMuteTimeComparator = new Comparator<MicSpeaker>(){

        @Override
        public int compare(MicSpeaker a, MicSpeaker b) {
            return Long.signum(b.muteTime - a.muteTime);
        }
    };
    public static Comparator<MicSpeaker> mSpeakTimeComparator = new Comparator<MicSpeaker>(){

        @Override
        public int compare(MicSpeaker a, MicSpeaker b) {
            return Long.signum(b.speakTime - a.speakTime);
        }
    };

    public MicSpeaker(long usrid, String nickname, String url) {
        this.uid = usrid;
        this.nick = nickname;
        this.headUrl = url;
        this.muteTime = 0L;
        this.speakTime = 0L;
        this.isSpeaking = false;
        this.isAuchor = false;
    }

    public long uid() {
        return this.uid;
    }

    public String nickname() {
        return this.nick;
    }

    public String headUrl() {
        return this.headUrl;
    }

    public void setHeadUrl(String url) {
        this.headUrl = url;
    }

    public void setNick(String nickName) {
        this.nick = nickName;
    }

    public boolean isSpeaking() {
        return this.isSpeaking;
    }

    public boolean isAuchor() {
        return this.isAuchor;
    }

    public void setAuchor(boolean isAuchor) {
        this.isAuchor = isAuchor;
    }

    public long getSpeakTime() {
        return this.speakTime;
    }

    public long getLastMuteTime() {
        return this.muteTime;
    }

    public MicSpeaker stopSpeak() {
        if (this.isSpeaking) {
            this.isSpeaking = false;
        }
        this.muteTime = System.currentTimeMillis();
        return this;
    }

    public MicSpeaker startSpeak() {
        if (!this.isSpeaking) {
            this.isSpeaking = true;
        }
        this.speakTime = System.currentTimeMillis();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"xiaoming", (String)"%d start speak and start speakTime is %d ", (Object[])new Object[]{this.uid, this.speakTime});
        }
        return this;
    }

    public String toString() {
        return String.valueOf(this.uid) + this.nick + this.headUrl + String.valueOf(this.muteTime) + String.valueOf(this.speakTime) + String.valueOf(this.isSpeaking);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MicSpeaker speaker = (MicSpeaker)o;
        return this.uid == speaker.uid;
    }

    public int hashCode() {
        int result = Long.valueOf(this.uid).hashCode();
        return result;
    }

    public static List<MicSpeaker> listFromMap(Map<Integer, MicSpeaker> map) {
        ArrayList<MicSpeaker> list = new ArrayList<MicSpeaker>(map.values());
        return list;
    }

    public static MicSpeaker getFurthestSpeaker(List<MicSpeaker> list) {
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        if (list != null && list.size() > 1) {
            Collections.sort(list, mSpeakTimeComparator);
            return list.get(list.size() - 1);
        }
        return null;
    }

    public static MicSpeaker getRecentlySpeaker(List<MicSpeaker> list) {
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        if (list != null && list.size() > 1) {
            Collections.sort(list, mSpeakTimeComparator);
            return list.get(0);
        }
        return null;
    }

    public static List<MicSpeaker> getNoSpeakerList(List<MicSpeaker> list) {
        ArrayList<MicSpeaker> noSpeakList = null;
        if (list != null && list.size() > 0) {
            noSpeakList = new ArrayList<MicSpeaker>();
            for (MicSpeaker micSpeaker : list) {
                if (micSpeaker.isSpeaking()) continue;
                noSpeakList.add(micSpeaker);
            }
        }
        return noSpeakList;
    }

    public static MicSpeaker getFurthestNoSpeaker(List<MicSpeaker> list) {
        List<MicSpeaker> noSpeakerList = MicSpeaker.getNoSpeakerList(list);
        if (noSpeakerList != null && noSpeakerList.size() == 1) {
            return noSpeakerList.get(0);
        }
        if (noSpeakerList != null && noSpeakerList.size() > 1) {
            Collections.sort(noSpeakerList, mMuteTimeComparator);
            return noSpeakerList.get(noSpeakerList.size() - 1);
        }
        return null;
    }

    public static MicSpeaker getRecentlyNoSpeaker(List<MicSpeaker> list) {
        List<MicSpeaker> noSpeakerList = MicSpeaker.getNoSpeakerList(list);
        if (noSpeakerList != null && noSpeakerList.size() == 1) {
            return noSpeakerList.get(0);
        }
        if (noSpeakerList != null && noSpeakerList.size() > 1) {
            Collections.sort(noSpeakerList, mSpeakTimeComparator);
            return noSpeakerList.get(0);
        }
        return null;
    }

    public static List<MicSpeaker> take(int n, List<MicSpeaker> list) {
        Collections.sort(list, mSpeakTimeComparator);
        if (list.size() <= n) {
            return list;
        }
        ArrayList<MicSpeaker> speakingList = new ArrayList<MicSpeaker>();
        for (MicSpeaker speaker : list) {
            if (!speaker.isSpeaking) continue;
            speakingList.add(speaker);
        }
        if (speakingList.size() >= n) {
            return speakingList.subList(0, n);
        }
        int complement = n - speakingList.size();
        speakingList.clear();
        int i2 = 0;
        for (MicSpeaker speaker : list) {
            if (speaker.isSpeaking) {
                speakingList.add(speaker);
                continue;
            }
            if (i2 >= complement) continue;
            speakingList.add(speaker);
            ++i2;
        }
        return speakingList;
    }
}

