/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.h5push;

import com.google.gson.annotations.SerializedName;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ent.IEntCore;
import com.yymobile.core.h5push.H5PushRegisterInfo;
import com.yymobile.core.h5push.H5PushResult;
import com.yymobile.core.h5push.H5PushRsp;
import com.yyproto.utils.FP;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import org.reactivestreams.Publisher;

public class H5PushManager {
    private static final String TAG = "H5PushManager";
    private static H5PushManager INSTANCE = new H5PushManager();

    public static H5PushManager getInstance() {
        return INSTANCE;
    }

    private H5PushManager() {
    }

    public void register(final H5PushRegisterInfo info) {
        MLog.info((Object)TAG, (String)"register, registerInfo: %s", (Object[])new Object[]{info});
        info.disposable = ((IEntCore)CoreFactory.getCore(IEntCore.class)).registerBroadcast(H5PushRsp.class).filter((Predicate)new Predicate<H5PushRsp>(){

            public boolean test(H5PushRsp rsp) {
                return FP.eq((Object)rsp.biz, (Object)info.biz);
            }
        }).flatMap((Function)new Function<H5PushRsp, Publisher<H5PushResult>>(){

            public Publisher<H5PushResult> apply(H5PushRsp rsp) {
                H5PushResult result = new H5PushResult(rsp.biz, rsp.json);
                WrapResult wrapResult = new WrapResult(result.biz, result.json);
                result.wrappedJson = JsonParser.toJson((Object)wrapResult);
                return Flowable.just((Object)result);
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<H5PushResult>(){

            public void accept(H5PushResult result) {
                info.h5PushCallback.onReceiveH5RegisteredPush(result);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) {
                MLog.error((Object)H5PushManager.TAG, (String)"Handle H5Push error", (Throwable)throwable, (Object[])new Object[0]);
            }
        });
    }

    public void unRegister(H5PushRegisterInfo info) {
        MLog.info((Object)TAG, (String)"unRegister, registerInfo: %s", (Object[])new Object[]{info});
        if (info.disposable != null && !info.disposable.isDisposed()) {
            info.disposable.dispose();
        }
    }

    class WrapResult {
        @SerializedName(value="biz")
        String biz;
        @SerializedName(value="rspJson")
        String rspJson;

        public WrapResult(String biz, String rspJson) {
            this.biz = biz;
            this.rspJson = rspJson;
        }
    }
}

