/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.ent;

import com.yymobile.core.ent.EntError;
import com.yymobile.core.ent.EntRetryPolicy;

public class DefaultEntRetryPolicy
implements EntRetryPolicy {
    protected int mCurrentTimeoutMs;
    protected int mCurrentRetryCount;
    protected final int mMaxNumRetries;
    protected final float mBackoffMultiplier;
    protected boolean mTimeoutReceive;
    public static final int DEFAULT_TIMEOUT_MS = 5000;
    public static final int DEFAULT_MAX_RETRIES = 1;
    public static final float DEFAULT_BACKOFF_MULT = 0.5f;

    public DefaultEntRetryPolicy() {
        this(5000, 1, 0.5f, true);
    }

    public DefaultEntRetryPolicy(int initialTimeoutMs, int maxNumRetries, float backoffMultiplier) {
        this(initialTimeoutMs, maxNumRetries, backoffMultiplier, true);
    }

    public DefaultEntRetryPolicy(int initialTimeoutMs, int maxNumRetries, float backoffMultiplier, boolean timeoutReceive) {
        this.mCurrentTimeoutMs = initialTimeoutMs;
        this.mMaxNumRetries = maxNumRetries;
        this.mBackoffMultiplier = backoffMultiplier;
        this.mTimeoutReceive = timeoutReceive;
    }

    @Override
    public int getCurrentTimeout() {
        return this.mCurrentTimeoutMs;
    }

    @Override
    public int getCurrentRetryCount() {
        return this.mCurrentRetryCount;
    }

    @Override
    public void retry(EntError error) throws EntError {
        ++this.mCurrentRetryCount;
        this.mCurrentTimeoutMs = (int)((float)this.mCurrentTimeoutMs + (float)this.mCurrentTimeoutMs * this.mBackoffMultiplier);
        if (!this.hasAttemptRemaining()) {
            throw error;
        }
    }

    @Override
    public boolean timeoutReceive() {
        return this.mTimeoutReceive;
    }

    protected boolean hasAttemptRemaining() {
        return this.mCurrentRetryCount <= this.mMaxNumRetries;
    }
}

