/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.auth.bind;

import com.yy.mobile.bizmodel.login.Account;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.bizmodel.login.ThirdType;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.share.ShareApi;
import com.yy.mobile.share.SharePlatform;
import com.yy.mobile.util.Logger;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yymobile.core.auth.bind.ThirdPartyUserInfoListener;

public class FixThirdNickNameEmptyUtils {
    public static final String TAG = "FixThirdNickNameEmptyUtils";
    public static FixThirdNickNameEmptyUtils INSTANCE = new FixThirdNickNameEmptyUtils();
    private boolean updatePortrait = false;

    private FixThirdNickNameEmptyUtils() {
    }

    public boolean isUpdatePortrait() {
        return this.updatePortrait;
    }

    public void setUpdatePortrait(boolean updatePortrait) {
        this.updatePortrait = updatePortrait;
    }

    public boolean isThirdPartyLogin(Account account) {
        if (account == null) {
            return false;
        }
        ThirdType thirdType = account.thirdPartyType;
        return thirdType == ThirdType.SINA || thirdType == ThirdType.QQ || thirdType == ThirdType.WECHAT;
    }

    public void getThirdPartyUserInfo() {
        SharePlatform platform;
        Account currentAccount = LoginUtil.getCurrentAccount();
        if (currentAccount == null) {
            MLog.error((Object)TAG, (String)"getThirdPartyUserInfo, current account is null", (Object[])new Object[0]);
            return;
        }
        ShareApi shareApi = CoreApiManager.getInstance().getApi(ShareApi.class);
        if (shareApi == null) {
            MLog.error((Object)"share", (String)"shareapi is null", (Object[])new Object[0]);
            return;
        }
        switch (currentAccount.thirdPartyType) {
            case QQ: {
                platform = SharePlatform.QQ;
                break;
            }
            case WECHAT: {
                platform = SharePlatform.Wechat;
                break;
            }
            case SINA: {
                platform = SharePlatform.Sina_Weibo;
                break;
            }
            default: {
                Logger.error((String)TAG, (String)("getThirdPartyUserInfo, wrong thirdType = " + currentAccount.thirdPartyType));
                return;
            }
        }
        this.updatePortrait = true;
        MLog.info((Object)TAG, (String)("getThirdPartyUserInfo updatePortrait = " + this.updatePortrait), (Object[])new Object[0]);
        shareApi.showUser(BasicConfig.getInstance().getAppContext(), platform, new ThirdPartyUserInfoListener(BasicConfig.getInstance().getAppContext(), currentAccount.userId, currentAccount.thirdPartyType));
    }
}

