/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.alertmonitor;

import android.os.SystemClock;
import com.yy.mobile.util.valid.BlankUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;

public abstract class AlertEvent {
    private static final int DEFAULT_EXPIRE = 30000;
    protected final AlertEventType mAlertEventType;
    protected final AlertEventErrorType mAlertEventErrorType;
    public String mAlertEventDesc;
    protected Map<String, String> mExtra;
    protected boolean mShouldExpire = true;
    protected boolean mShouldReportImmediately;
    protected long mExpire = 30000L;
    protected long mEventId = SystemClock.uptimeMillis();

    public AlertEvent(AlertEventType alertEventType, AlertEventErrorType alertEventErrorType) {
        this.mAlertEventType = alertEventType;
        this.mAlertEventErrorType = alertEventErrorType;
    }

    public String getAlertEventKey() {
        return this.getAlertEventKeyPrex() + "-" + this.getAlertEventKeyContent();
    }

    public abstract String getAlertEventKeyContent();

    private String getAlertEventKeyPrex() {
        return this.getClass().getSimpleName() + "-" + this.mAlertEventType.name() + "-" + this.mAlertEventErrorType.name();
    }

    public AlertEventType getAlertEventType() {
        return this.mAlertEventType;
    }

    public AlertEventErrorType getAlertEventErrorType() {
        return this.mAlertEventErrorType;
    }

    public long getEventId() {
        return this.mEventId;
    }

    public long getExpire() {
        return this.mExpire;
    }

    public void setExpire(long expire) {
        this.mExpire = expire;
    }

    public void setShouldExpire(boolean shouldExpire) {
        this.mShouldExpire = shouldExpire;
    }

    public boolean shouldExpire() {
        return this.mShouldExpire;
    }

    public void setShouldReportImmediately(boolean shouldReportImmediately) {
        this.mShouldReportImmediately = shouldReportImmediately;
    }

    public boolean shouldReportImmediately() {
        return this.mShouldReportImmediately;
    }

    public String getAlertEventDesc() {
        return this.mAlertEventDesc;
    }

    public void addExtra(String key, String value) {
        if (BlankUtil.isBlank((String)key) || BlankUtil.isBlank((String)value)) {
            return;
        }
        if (this.mExtra == null) {
            this.mExtra = new HashMap<String, String>();
        }
        this.mExtra.put(key, value);
    }

    public void setAlertEventDesc(String desc) {
        this.mAlertEventDesc = desc;
    }

    public String buildKeyJson() throws JSONException {
        StringBuilder sb = new StringBuilder();
        sb.append("alert_type").append(":").append(this.mAlertEventType.name()).append(",");
        sb.append("alert_error_type").append(":").append(this.mAlertEventErrorType.name()).append(",");
        this.onKey(sb);
        return sb.toString();
    }

    public String buildExtraJson() throws JSONException {
        if (BlankUtil.isBlank(this.mExtra)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = this.mExtra.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            String value = this.mExtra.get(key);
            sb.append(key).append(":").append(value);
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected abstract void onKey(StringBuilder var1) throws JSONException;

    public String toString() {
        return "mAlertEventType:" + this.mAlertEventType.ordinal() + ", mAlertEventErrorType:" + this.mAlertEventErrorType.ordinal() + ", mAlertEventDesc:" + this.mAlertEventDesc;
    }

    public static enum AlertEventErrorType {
        PROTOCOL_NOT_ACK,
        PROTOCOL_RESULT_ABNORMAL,
        UPLOAD_VIDEO_FAIL,
        UPLOAD_LOG_FAIL,
        TRANS_CODE_FAIL,
        RECORD_VIDEO_FAIL,
        PLAY_VIDEO_FAIL,
        EDIT_VIDEO_FAIL,
        RECORD_AUDIO_FAIL,
        DOWNLOAD_MUSIC_FAIL,
        TRANSCODE_VIDEO_STATISTIC,
        SEND_PM_FAIL,
        SYNC_PM_FAIL,
        PM_BLOCK_SOMEONE_FAIL,
        PM_UPDATE_SWITCH_FAIL,
        PM_QUERY_BLOCK_FAIL,
        PM_QUERY_MASTER_BLOCK_FAIL;

    }

    public static enum AlertEventType {
        PROTOCOL,
        FUNCTION;

    }
}

